unit Viewcode;
(*-----
    File: VIEWCODE.PAS for Project CODEAPP.DPR
-----*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Grids,
  TextClip, FindWhat;

type
  TViewText = class(TForm)
    Panel1: TPanel;
    CloseBtn: TBitBtn;
    StringGrid1: TStringGrid;
    Copy2TCBtn: TBitBtn;
    Panel3: TPanel;
    Label3: TLabel;
    FindAgainBtn: TBitBtn;
    FindWhatBtn: TBitBtn;
    Label1: TLabel;
    HelpBtn: TBitBtn;
    RefNoteOption: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure Copy2TCBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FindAgainBtnClick(Sender: TObject);
    procedure FindWhatBtnClick(Sender: TObject);
    procedure StringGrid1TopLeftChanged(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure StringGrid1KeyPress(Sender: TObject; var Key: Char);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    FirstTime: boolean;
    ViewFile: string;
    Marker: string;
    fsize: LongInt;
    procedure FindString(const Atag: integer);
    procedure DisplayPosition;
  public
    { Public declarations }
    theTarget: string; {what to search for}
    procedure LoadFile(const FN, FD: string);
  end;

var
  ViewText: TViewText;

implementation

{$R *.DFM}

procedure TViewText.FindString(const Atag: integer);
{-Puts source containing 'target' into grid window view}
const
  { "Whole Word only" delimiters are any characters except these: }
  WordDelimiters : set of Char = ['0'..'9', 'A'..'Z', 'a'..'z', '_'];
var iy: integer;
  Srect: TGridRect;
  found: boolean;
  cp, StartPoint: integer;
  S: string;
begin
  Srect.Left := 0;
  Srect.Right  := 0;
  found := False;
  with StringGrid1 do
  begin
    FirstTime := False;
    if (ATag = 0) and FindWhatDlg.StartTop.Checked then
      StartPoint := 0
    else
    begin
      if TopRow < Row then
        StartPoint := TopRow { start at top line in view}
      else
        StartPoint := TopRow+1; {just below top line in view}
    end;
    if FindWhatDlg.AnyCase.Checked then
      theTarget := UpperCase(theTarget);
    found := False;

    {Search loop}
    for iy := StartPoint to RowCount do
    begin
      S := Cells[0, iy];
      if FindWhatDlg.WholeWords.Checked then
        S := ' '+S+' ';
      if FindWhatDlg.AnyCase.Checked then
        S := UpperCase(S);
      cp := pos(theTarget, S);
      if cp > 0 then
      begin
        if FindWhatDlg.WholeWords.Checked then
          if (S[cp-1] in WordDelimiters) or
             (S[cp+Length(theTarget)] in WordDelimiters) then
            continue;
        found := True;
        break;
      end;
    end;

    if found then
    begin
      Srect.Top := iy;
      Srect.Bottom  := iy;
      Selection := Srect;
      if iy >= RowCount - VisibleRowCount then
        TopRow := RowCount - VisibleRowCount
      else
        TopRow := iy;
    end
    else
      MessageBeep(64); {could put friendly msg box here instead}
  end
end;

procedure TViewText.FindAgainBtnClick(Sender: TObject);
{-Find again action}
begin
  FindString(FindAgainBtn.Tag);
end;

procedure TViewText.FindWhatBtnClick(Sender: TObject);
{-Find string setup & go}
begin
  with FindWhatDlg do
  begin
    if ShowModal <> mrCancel then
    begin
      theTarget := ComboBox1.Text;
      if theTarget <> ComboBox1.Items[0] then {stuff it once only}
        ComboBox1.Items.Insert(0, theTarget);
      FirstTime := True;
      FindString(FindWhatBtn.Tag);
    end;
  end
end;

procedure TViewText.LoadFile(const FN, FD: string);
{-Load text into viewer}
var
  F: TextFile;
  Buf: array[0..4095] of Char;
  iy: integer;
  S: string;
begin
  {Clear old - in case new file size=0 or load fail}
  StringGrid1.RowCount := 12;
  for iy := 0 to StringGrid1.RowCount do
    StringGrid1.Cells[0, iy] := '';
  {Load new}
  ViewFile := FN;
  AssignFile(F, FN);
  Marker := Format('(* From: %s  %s, on %s *)',
   [ExtractFileName(ViewFile), FD, DateTimeToStr(Now)]);
  system.SetTextBuf(F, Buf);  { Bigger buffer for faster reads }
  try
    Reset(F);
    try
      iy := 0;
      fsize := 0;
      while not Eof(F) do
      begin
        readln(F, S);
        inc(fsize, Length(S)+2);
        StringGrid1.Cells[0, iy] := S;
        inc(iy);
        StringGrid1.RowCount := iy;
      end;
    finally
      CloseFile(F);
    end;
    Caption := 'Viewer - '+ UpperCase(ExtractFileName(FN));

    with FindWhatDlg do
    begin
      if theTarget <> '' then
      begin
        ComboBox1.Text := theTarget;
        if theTarget <> ComboBox1.Items[0] then {stuff it once only}
          ComboBox1.Items.Insert(0, theTarget);
        FirstTime := True;
        FindString(FindWhatBtn.Tag);
      end;
    end;
    Show;
  except
    MessageDlg('Unable to load '+FN, mtError, [mbOk], 0);
  end;
end;

procedure TViewText.DisplayPosition;
begin
  Label1.Caption := 'Top Line: '+IntTostr(StringGrid1.TopRow);
  ActiveControl := StringGrid1;
end;

procedure TViewText.FormActivate(Sender: TObject);
{-Shows size of contents upon activation}
begin
  with StringGrid1 do
  begin
    Label3.Caption := Format('Lines: %d    Bytes: %s',
      [RowCount, FormatFloat(',##########', fsize)]);
    DisplayPosition;
  end;
end;

procedure TViewText.Copy2TCBtnClick(Sender: TObject);
{-Copy StringGrid selection to Memo window}
var iy: integer;
  SRect: TGridRect;
begin
  SRect := StringGrid1.Selection;
  with TextClips do
  try
    if RefNoteOption.Checked then
    begin
      Memo1.Lines.Add('');
      Memo1.Lines.Add(Marker);
    end;
    for iy := Srect.Top to Srect.Bottom do
      Memo1.Lines.Add(StringGrid1.Cells[0, iy]);
    iy := Srect.Bottom-Srect.Top + 1;
    inc(LinesCopied, iy);
    Label1.Caption := Format('%d Lines added      %d Lines total',
    [iy, LinesCopied]);
    Show;
    AllBtnClick(Sender);
    CopyButtonClick(Sender);
  except
    MessageDlg('Error loading TextClip buffer.', mtError, [mbOk], 0);
  end;
end;

procedure TViewText.FormCreate(Sender: TObject);
begin
  Left := 0;
  Top := (Screen.Height - Height) div 2; {center it}
  FirstTime := False;
  theTarget := '';
end;

procedure TViewText.CloseBtnClick(Sender: TObject);
begin
  Close
end;

procedure TViewText.StringGrid1TopLeftChanged(Sender: TObject);
begin
  DisplayPosition;
end;

procedure TViewText.HelpBtnClick(Sender: TObject);
{-Some help}
begin
  MessageDlg('Select lines of text and then,'+#13+
  'click on Copy to TextClip.',
  mtInformation, [mbCancel], 0);
  ActiveControl := StringGrid1;
end;

procedure TViewText.StringGrid1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key = ^C then
    Copy2TCBtnClick(Sender);
end;

procedure TViewText.StringGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_INSERT then
    if ssCtrl in Shift then
      Copy2TCBtnClick(Sender);
end;

end.

