unit CRCUnit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    Label1: TLabel;
    Button3: TButton;
    Label2: TLabel;
    BufferSizeBox: TRadioGroup;
    ModeBox: TRadioGroup;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ModeBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

const
  BufferSizes: array[0..6] of integer =
  (16384,32768,65536,131072,262144,524288,1048576);

implementation

{$R *.DFM}
uses Crc32;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if OpenDialog1.Execute then Edit1.Text:=OpenDialog1.FileName;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
 CRC,CrcTime: integer;
 Stream: TMemoryStream;
begin
 if not FileExists(Edit1.Text) then
 begin
  MessageBeep(MB_IconExclamation);
  MessageDlg('The file "'+Edit1.Text+'" doesn'+#39+'t exist',mtError,[mbOk],0);
  Exit;
 end;
 Label1.Caption:='Working';
 Label2.Caption:='Please wait';
 Application.ProcessMessages;
 case ModeBox.ItemIndex of
  0:
  begin
   BufferSize:=BufferSizes[BufferSizeBox.ItemIndex];
   CrcTime:=GetTickCount;
   CRC:=GetFileCrc32(Edit1.Text);
   CrcTime:=GetTickCount-CrcTime;
  end;
  1:
  begin
   BufferSize:=BufferSizes[BufferSizeBox.ItemIndex];
   CrcTime:=GetTickCount;
   CRC:=AsmGetFileCrc32(Edit1.Text);
   CrcTime:=GetTickCount-CrcTime;
  end;
  2:
  begin
   CrcTime:=GetTickCount;
   Stream:=TMemoryStream.Create;
   Stream.LoadFromFile(Edit1.Text);
   CRC:=GetMemoryStreamCrc32(Stream);
   Stream.Free;
   CrcTime:=GetTickCount-CrcTime;
  end;
  3:
  begin
   CrcTime:=GetTickCount;
   Stream:=TMemoryStream.Create;
   Stream.LoadFromFile(Edit1.Text);
   CRC:=AsmGetMemoryStreamCrc32(Stream);
   Stream.Free;
   CrcTime:=GetTickCount-CrcTime;
  end;
 end;
 Label1.Caption:='CRC:  '+IntToHex(CRC,8);
 Label2.Caption:='Time: '+IntToStr(CrcTime)+' ms';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.ModeBoxClick(Sender: TObject);
begin
 if ModeBox.ItemIndex>1 then BufferSizeBox.Enabled:=False else BufferSizeBox.Enabled:=True; 
end;

end.
