unit DynTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  DynArray;

type
  TfmDynamicTest = class(TForm)
    lbNumber: TLabel;
    edNumber: TEdit;
    lbY: TLabel;
    edX: TEdit;
    lbX: TLabel;
    edZ: TEdit;
    lbZ: TLabel;
    btSet: TButton;
    btGet: TButton;
    btClose: TButton;
    edY: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btSetClick(Sender: TObject);
    procedure btGetClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
  private
    fCoords : tCoordsArray;
  public
    { Public declarations }
  end;

var
  fmDynamicTest: TfmDynamicTest;

implementation

const
   TEST_FILE = 'PRUEBA.NCF';

{$R *.DFM}

procedure TfmDynamicTest.FormCreate(Sender: TObject);
begin
   if FileExists( TEST_FILE ) then
      fCoords := tCoordsArray.CreateFromFile( TEST_FILE )
   else
      fCoords := tCoordsArray.CreateNew( 2000, TEST_FILE );
end;

procedure TfmDynamicTest.FormDestroy(Sender: TObject);
begin
   fCoords.Destroy;
end;

procedure TfmDynamicTest.btSetClick(Sender: TObject);
var
   c : tCoord;
   i : Integer;
begin
   if edNumber.Text = '' then
      i := 0
   else
      i := StrToInt( edNumber.Text );
   if i <> 0 then
      begin
         c.y := StrToFloat( edY.Text );
         c.x := StrToFloat( edX.Text );
         c.z := StrToFloat( edZ.Text );
         fCoords[ i ] := c;
      end
   else
      ShowMessage( 'Coordinate Number not set' );
end;

procedure TfmDynamicTest.btGetClick(Sender: TObject);
var
   c : tCoord;
   i : Integer;
begin
   if edNumber.Text = '' then
      i := 0
   else
      i := StrToInt( edNumber.Text );

   if i <> 0 then
      begin
         c := fCoords[ i ] ;
         edY.Text := Format( '%1.4f', [ c.y ] );
         edX.Text := Format( '%1.4f', [ c.x ] );
         edZ.Text := Format( '%1.3f', [ c.z ] );
      end
   else
      ShowMessage( 'Coordinate Number not set' );
end;

procedure TfmDynamicTest.btCloseClick(Sender: TObject);
begin
   Application.Terminate;
end;

end.
