//
//  Copyright 1996, Artemis Alliance, Inc.
//  St. Paul, Mn 55101
//  (612) 227-7172
//
unit FrmCube2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GL, GLU;

type
  TfrmCube = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    
  private
    hrc: HGLRC;

    procedure DrawScene;

  public
  end;

var
  frmCube: TfrmCube;

implementation

{$R *.DFM}

procedure SetDCPixelFormat(Handle: HDC);
var
  pfd: TPixelFormatDescriptor;
  nPixelFormat: Integer;

begin
  FillChar(pfd, SizeOf(pfd), 0);
  
  with pfd do begin
    nSize     := sizeof(pfd);                               // Size of this structure
    nVersion  := 1;                                         // Version number
    dwFlags   := PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL;  // Flags
    iPixelType:= PFD_TYPE_RGBA;                             // RGBA pixel values
    cColorBits:= 24;                                        // 24-bit color
    cDepthBits:= 32;                                        // 32-bit depth buffer
    iLayerType:= PFD_MAIN_PLANE;                            // Layer type
  end;
  
  nPixelFormat := ChoosePixelFormat(Handle, @pfd);
  SetPixelFormat(Handle, nPixelFormat, @pfd);
end;

procedure TfrmCube.DrawScene;
const
  glfLightAmbient : Array[0..3] of GLfloat = (0.1, 0.1, 0.1, 1.0);
  glfLightDiffuse : Array[0..3] of GLfloat = (0.7, 0.7, 0.7, 1.0);
  glfLightSpecular: Array[0..3] of GLfloat = (0.0, 0.0, 0.0, 1.0);
  glfMaterialColor: Array[0..3] of GLfloat = (0.0, 0.0, 1.0, 1.0);

begin
  //
  // Enable depth testing and clear the color and depth buffers.
  //
  glEnable(GL_DEPTH_TEST);
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);


  //
  // Add a light to the scene.
  //
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR,@glfLightSpecular);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);

  //
  // Define the modelview transformation.
  //
  glTranslatef(0.0, 0.0, -8.0);
  glRotatef(30.0, 1.0, 0.0, 0.0);
  glRotatef(70.0, 0.0, 1.0, 0.0);

  //
  // Define the reflective properties of the cube's faces.
  //
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor);

  //
  // Set the drawing color to blue.
  //
  glColor3f(0.0, 0.0, 1.0);

  //
  // Draw the six faces of the cube.
  //
  glBegin(GL_POLYGON);
    glNormal3f(0.0, 0.0, 1.0);
    glVertex3f(1.0, 1.0, 1.0);
    glVertex3f(-1.0, 1.0, 1.0);
    glVertex3f(-1.0, -1.0, 1.0);
    glVertex3f(1.0, -1.0, 1.0);
  glEnd;

  glBegin(GL_POLYGON);
    glNormal3f(0.0, 0.0, -1.0);
    glVertex3f(1.0, 1.0, -1.0);
    glVertex3f(1.0, -1.0, -1.0);
    glVertex3f(-1.0, -1.0, -1.0);
    glVertex3f(-1.0, 1.0, -1.0);
  glEnd;

  glBegin(GL_POLYGON);
    glNormal3f(-1.0, 0.0, 0.0);
    glVertex3f(-1.0, 1.0, 1.0);
    glVertex3f(-1.0, 1.0, -1.0);
    glVertex3f(-1.0, -1.0, -1.0);
    glVertex3f(-1.0, -1.0, 1.0);
  glEnd;

  glBegin(GL_POLYGON);
    glNormal3f(1.0, 0.0, 0.0);
    glVertex3f(1.0, 1.0, 1.0);
    glVertex3f(1.0, -1.0, 1.0);
    glVertex3f(1.0, -1.0, -1.0);
    glVertex3f(1.0, 1.0, -1.0);
  glEnd;

  glBegin(GL_POLYGON);
    glNormal3f(0.0, 1.0, 0.0);
    glVertex3f(-1.0, 1.0, -1.0);
    glVertex3f(-1.0, 1.0, 1.0);
    glVertex3f(1.0, 1.0, 1.0);
    glVertex3f(1.0, 1.0, -1.0);
  glEnd;

  glBegin(GL_POLYGON);
    glNormal3f(0.0, -1.0, 0.0);
    glVertex3f(-1.0, -1.0, -1.0);
    glVertex3f(1.0, -1.0, -1.0);
    glVertex3f(1.0, -1.0, 1.0);
    glVertex3f(-1.0, -1.0, 1.0);
  glEnd;

  //
  // Flush the drawing pipeline.
  //
  glFlush;
end;


// EVENT HANDLERS

procedure TfrmCube.FormCreate(Sender: TObject);
begin
  // Create a rendering context.
  SetDCPixelFormat(Canvas.Handle);
  hrc := wglCreateContext(Canvas.Handle);
end;

procedure TfrmCube.FormResize(Sender: TObject);
var
  gldAspect : GLdouble;

begin
  // Redefine the viewing volume and viewport when the window size changes.
  wglMakeCurrent(Canvas.Handle, hrc);
  gldAspect := Width / Height;

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(30.0,           // Field-of-view angle
                 gldAspect,      // Aspect ratio of viewing volume
                 1.0,            // Distance to near clipping plane
                 10.0);          // Distance to far clipping plane
  glViewport(0, 0, Width, Height);
  wglMakeCurrent(0, 0);
  Invalidate;
end;

procedure TfrmCube.FormPaint(Sender: TObject);
begin
  // Draw the scene.
  wglMakeCurrent(Canvas.Handle, hrc);
  DrawScene;
  wglMakeCurrent(0, 0);
end;

procedure TfrmCube.FormDestroy(Sender: TObject);
begin
  // Clean up and terminate.
  wglDeleteContext(hrc);
end;

end.

