{ Component Create for Delphi }
{ Sample form for property editor - TStringList and TStrings object types }

unit Edit_sl;

interface

uses
    WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
    StdCtrls, ExtCtrls, Dialogs, Menus, Clipbrd;

type
  TStringListPropDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Memo1: TMemo;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    EditDlgMenu: TMainMenu;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Selectall1: TMenuItem;
    File1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Selectall1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
      { Transfer buffer for property's value }
      Value : TStringList;
  end;

var
  StringListPropDlg: TStringListPropDlg;

implementation

{$R *.DFM}

procedure TStringListPropDlg.FormActivate(Sender: TObject);
begin
     Memo1.Lines.Clear;
     Memo1.Lines.AddStrings(Value);
end;

procedure TStringListPropDlg.OKBtnClick(Sender: TObject);
begin
     if Memo1.Modified then
        begin
        Value.Assign(Memo1.Lines)
        end;
     ModalResult := mrOK
end;

procedure TStringListPropDlg.Open1Click(Sender: TObject);
begin
     if OpenDialog.Execute then
        begin
        Memo1.Lines.LoadFromFile(OpenDialog.FileName);
        Memo1.Modified := True
        end
end;

procedure TStringListPropDlg.Saveas1Click(Sender: TObject);
begin
     if SaveDialog.Execute then
        Memo1.Lines.SaveToFile(SaveDialog.FileName)
end;

procedure TStringListPropDlg.Exit1Click(Sender: TObject);
begin
     if Memo1.Modified then
        begin
        Value.Assign(Memo1.Lines)
        end;
     ModalResult := mrOK
end;

procedure TStringListPropDlg.Edit1Click(Sender: TObject);
var
   AnyTextSelected : Boolean;
begin
     if ActiveControl is TMemo then
        { A memo is the active control }
        begin
        { Any text selected? }
        AnyTextSelected :=
              (ActiveControl as TMemo).SelLength > 0;
        Cut1.Enabled := AnyTextSelected;
        Copy1.Enabled := AnyTextSelected;
        { Any text on the clipboard? }
        Paste1.Enabled := Clipboard.HasFormat(CF_TEXT);
        end
     else
         begin
         Cut1.Enabled := False;
         Copy1.Enabled := False;
         Paste1.Enabled := False
         end
end;

procedure TStringListPropDlg.Paste1Click(Sender: TObject);
begin
     if ActiveControl is TMemo then
        (ActiveControl as TMemo).PasteFromClipBoard
end;

procedure TStringListPropDlg.Cut1Click(Sender: TObject);
begin
     if ActiveControl is TMemo then
        (ActiveControl as TMemo).CutToClipBoard
end;

procedure TStringListPropDlg.Selectall1Click(Sender: TObject);
begin
     ActiveControl := Memo1;
     Memo1.SelectAll
end;

end.
