unit SimFunc;

{
	SimCoP - Funktionssammlung.
  Fr einige Delphi - Funktionen sind Wrapper ntig, da von SimCoP
  nicht alle Datentypen (meist Arrays) untersttzt werden. Andere Funktionen
  (z.B. Int, Length, ...) werden vom Compiler direkt aufgelst und knnen daher
  auch nicht von SimCoP aufgerufen werden.
  Da SimCoP keine Variablenparameter untersttzt, gibt es auch Wrapper-Funktionen
  fr div. Prozeduren (Str, Val)
}

interface

uses
	Dialogs,
	SimExpr,
	SimConst,
	SysUtils,
  Funcs;

{ Wrapper fr Delphi-Funktionen }
function _Format (s : String; a : Variant) : String;
function _Copy (cValue : String; nPos, nCount : Integer) : String;
function _Length (cValue : String) : Integer;
function _Str (nValue : Extended; nLen, nDec : Integer) : String;
function _Val (cValue : String) : Double;
function _Int (nValue : Double) : Integer;
function _Asc (cValue : String) : Integer;
function _Chr (nValue : Integer) : String;
function _Pos (cValue1, cValue2 : String) : Integer ;
function _Random : Double;

{ SimCoP - Funktionen }
function ValType (xValue : Variant) : Integer;
function ALen (aValue : Variant) : Integer;

const

  { vordefinierte SimCoP - Funktionen }
  DefaultFuncDef : array [1 .. 27] of TFuncDef = (

  	(Name : 'At';											// Name fr SimCoP, hier gleich auf X-Base umbenannt
        ClassID			: nil;						// ist Funktion -> Klasse = nil
    		Address 		: @_Pos;					// Adresse der (Wrapper)funktion
        CallType		: ctRegister;			// Aufruftyp (ctRegister = ctDefault)
        ResultType 	: varInteger;			// Rckgabewert der Funktion
        							{ Liste der Parameter }
        Parameters 	: (varString, varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Asc';
        ClassID			: nil;
    		Address 		: @_Asc;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Upper';
        ClassID			: nil;
    		Address 		: @AnsiUpperCase;		// AnsiUpperCase bentigt keinen Wrapper
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Format';
        ClassID			: nil;
    		Address 		: @_Format;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varArray or varVariant, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FormatDateTime';
        ClassID			: nil;
    		Address 		: @FormatDateTime;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varDate, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SubStr';
        ClassID			: nil;
    		Address 		: @_Copy;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Trim';
        ClassID			: nil;
    		Address 		: @Trim;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'StrTran';
        ClassID			: nil;
    		Address 		: @StrTran;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varString, varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Replicate';
        ClassID			: nil;
    		Address 		: @Replicate;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Pad';
        ClassID			: nil;
    		Address 		: @Pad;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'LPad';
        ClassID			: nil;
    		Address 		: @LPad;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varString, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Space';
        ClassID			: nil;
    		Address 		: @Space;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Len';
        ClassID			: nil;
    		Address 		: @_Length;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ALen';
        ClassID			: nil;
    		Address 		: @ALen;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varVariant, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Str';
        ClassID			: nil;
    		Address 		: @_Str;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varExtended, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Val';
        ClassID			: nil;
    		Address 		: @_Val;
        CallType		: ctRegister;
        ResultType 	: varDouble;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Int';
        ClassID			: nil;
    		Address 		: @_Int;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varDouble, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Chr';
        ClassID			: nil;
    		Address 		: @_Chr;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'IntToStr';
        ClassID			: nil;
    		Address 		: @IntToStr;
        CallType		: ctRegister;
        ResultType 	: varString;
        Parameters 	: (varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'StrToInt';
        ClassID			: nil;
    		Address 		: @StrToInt;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Date';
        ClassID			: nil;
    		Address 		: @Date;
        CallType		: ctRegister;
        ResultType 	: varDate;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Time';
        ClassID			: nil;
    		Address 		: @Time;
        CallType		: ctRegister;
        ResultType 	: varDate;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Now';
        ClassID			: nil;
    		Address 		: @Now;
        CallType		: ctRegister;
        ResultType 	: varDate;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Randomize';
        ClassID			: nil;
    		Address 		: @Randomize;
        CallType		: ctRegister;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Random';
        ClassID			: nil;
    		Address 		: @_Random;
        CallType		: ctRegister;
        ResultType 	: varDouble;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ShowMessage';
        ClassID			: nil;
    		Address 		: @ShowMessage;
        CallType		: ctRegister;
        ResultType 	: varEmpty;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ValType';
        ClassID			: nil;
    		Address 		: @ValType;
        CallType		: ctRegister;
        ResultType 	: varInteger;
        Parameters 	: (varVariant, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))
  );


implementation


{
	Nicht erschrecken! Format bekommt ein "array of const" als Parameter,
  das ist leider nicht ganz so einfach aus einem Variantenarray erzeugbar,
  alle anderen Funktionen sind einfacher (bzw. mssen berhaupt nicht
  geschrieben werden).
}

function _Format (s : String; a : Variant) : String;
type
	PVarRecArray = ^TVarRecArray;
	TVarRecArray  = array [1 .. MaxInt div SizeOf (TVarRec)] of TVarRec;
var
	p, hp		: PVarRec;		    	// Zeiger auf Speicherbereich fr Const-Array
  ap 			: PVariant;					// Zeiger auf Varianten-Array
  ep, ehp	: Pointer;					// Zeiger auf Extended und Currency
  i, Size,										// div. Hilfsvariable
  ESize,
  Count		: Integer;
begin

	Count := VarArrayHighBound (a, 1) - VarArrayLowBound (a, 1) + 1;
	Size 	:= Count * SizeOf (TVarRec);				// Gre fr Konstantenarray
  ESize	:= Count * SizeOf (Extended);				// Max von Currency, Extended
	GetMem (p, Size);                       	// Speicher fr Arrays allozieren
  GetMem (ep, ESize);

  try

  	if VarType (a) <> (varVariant or varArray) then
    	raise EVariantError.CreateRes (E_RB + E_TypeMissMatch);
    hp 		:= p;        											// Hilfspointer setzen
    ehp		:= ep;
    ap		:= VarArrayLock (a);  						// Varianten-Array direkt bearbeiten
                                            // lst exception aus, falls ap kein
                                            // array
    try

    	// fr Varianten gilt nur das %s-Format, daher Typen entsprechend
      // umwandeln
      for i := 1 to Count do begin
        case VarType (ap^) of
          varInteger, varSmallint	:
            begin
              hp^.VType			:= vtInteger;
              hp^.VInteger 	:= ap^;
            end;
          varSingle, varDouble, varDate	:
          	// Format bentigt Extended-Floats, daher konvertieren:
            begin
            	Extended (ehp^)	:= ap^;
              hp^.VType				:= vtExtended;
              hp^.VExtended 	:= PExtended (ehp);
            end;
          varCurrency	:
            begin
            	Currency (ehp^)	:= ap^;
              hp^.VType 			:= vtCurrency;
              hp^.VCurrency 	:= PCurrency (ehp);
            end;
        else
        	// alle anderen Datentypen werden Variant-intern zu Strings
          // konvertiert
          hp^.VType			:= vtVariant;
          hp^.VVariant	:= ap;
        end;
        Inc (ap);
        Inc (hp);
        ehp := Pointer (Cardinal (ehp) + SizeOf (Extended));
      end;

      { unglaublich, aber wahr, hier wird bereits Format aufgerufen }
      Result := Format (s, Slice (PVarRecArray (p)^, Count));

    finally
		  VarArrayUnlock (a);
    end;

  finally
	  FreeMem (p, Size);
    FreeMem (ep, ESize);
  end;

end;

{
	Versprochen ist Versprochen, und wird auch nicht gebrochen (einfachere
  Funktionen) :
}

function _Copy (cValue : String; nPos, nCount : Integer) : String;
begin
	Result := Copy (cValue, nPos, nCount)
end;


function _Length (cValue : String) : Integer;
begin
	Result := Length (cValue);
end;


function _Str (nValue : Extended; nLen, nDec : Integer) : String;
begin
	Str (nValue : nLen : nDec, Result)
end;


function _Val (cValue : String) : Double;
var
	i : Integer;
begin
	try
  	{ Wer wei was fr Dezimaltrennzeichen in welchen Windows-Einstellungen
    	verwendet werden? Also ich nicht, daher: }
  	for i := 1 to Length (cValue) do
    	if not (cValue[i] in [#0 .. #32, '0' .. '9', 'e', 'E', '+', '-']) then
      	cValue[i] := DecimalSeparator;
  	Result := StrToFloat (cValue);
  except
  	Result := 0;
  end
end;


function _Int (nValue : Double) : Integer;
begin
	Result := Trunc (nValue)
end;


function _Chr (nValue : Integer) : String;
begin
	Result := Chr (nValue)
end;


function _Pos (cValue1, cValue2 : String) : Integer;
begin
	Result := Pos (cValue1, cValue2)
end;


function _Asc (cValue : String) : Integer;
begin
	if Length (cValue) = 0 then
  	Result := 0
  else
  	Result := Ord (cValue [1])
end;


function _Random : Double;
begin
	Result := Random
end;


function ValType (xValue : Variant) : Integer;
begin
	Result := TVarData (xValue).VType
end;

function ALen (aValue : Variant) : Integer;
begin
  if VarIsArray (aValue) then
    Result := VarArrayHighBound (aValue, 1) - VarArrayLowBound (aValue, 1) + 1
  else
    Result := 0;
end;

{
	Alle anderen Funktionen die hier definiert wurden (AnsiUpperCase, ...)
  bentigen keinen Wrapper.
}


end.

