unit SimTable;

interface

uses
	SimConst,
	SimCoP,
  SimExpr,
	Db,
  DbTables,
  Forms;

type

	TSimTable = class (TTable)
  protected
  	SimCoP		: TSimCoP;
  public
    constructor CreateSim (oSimCoP : TSimCoP);
    destructor	Destroy; override;

    function 		GetField (const cName : String) : Variant;
    procedure		SetField (const cName : String; const Value : Variant);

  published
  	property BOF;
    property EOF;

  end;

procedure SimRegister (SimCoP : TSimCoP);

implementation

const

	SimFuncDef : array [1 .. 37] of TFuncDef = (

  { ************ TSimTable ************* }
  	(Name : 'Create';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.CreateSim;
        CallType		: ctDefault or ctConstructor;
        ResultType 	: varObject;
        Parameters 	: (varObject, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Destroy';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Destroy;
        CallType		: ctDefault or ctDestructor;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ApplyRange';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.ApplyRange;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Append';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Append;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Cancel';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Cancel;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Close';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Close;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'CancelRange';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.CancelRange;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ClearFields';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.ClearFields;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'CommitUpdates';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.CommitUpdates;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Delete';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Delete;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Edit';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Edit;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'EditKey';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.EditKey;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'EditRangeEnd';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.EditRangeEnd;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'EditRangeStart';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.EditRangeStart;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FieldByName';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FieldByName;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FindFirst';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FindFirst;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FindLast';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FindLast;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FindNext';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FindNext;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FindPrior';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FindPrior;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'FreeBookmark';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.FreeBookmark;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varObject, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'GetBookmark';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.GetBookmark;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'GotoBookmark';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.GotoBookmark;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varObject, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'GotoKey';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.GotoKey;
        CallType		: ctDefault;
        ResultType 	: varBoolean;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'GotoNearest';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.GotoNearest;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Insert';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Insert;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'First';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.First;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Last';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Last;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'MoveBy';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.MoveBy;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Next';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Next;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Open';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Open;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Post';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Post;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Prior';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.Prior;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SetKey';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.SetKey;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SetRangeEnd';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.SetRangeEnd;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SetRangeStart';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.SetRangeStart;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'GetField';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.GetField;
        CallType		: ctDefault;
        ResultType 	: varVariant;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SetField';
        ClassID			: TSimTable;
    		Address 		: @TSimTable.SetField;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varString, varVariant, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))

		);

procedure SimRegister (SimCoP : TSimCoP);
begin
	// Funktionen definieren:
	SimCoP.AddFuncList (SimFuncDef);
  // Variable vorbelegen (Klassentypen):
	SimCop.SetVar ('TTable', SimClass (TSimTable));
  // Tabletypes
	SimCop.SetVar ('ttDefault', 0);
	SimCop.SetVar ('ttParadox', 1);
	SimCop.SetVar ('ttDBase', 2);
	SimCop.SetVar ('ttASCII', 3);
end;


constructor TSimTable.CreateSim (oSimCoP : TSimCoP);
begin
	inherited Create (Application);
  SimCoP := oSimCoP;
  SimCoP.Register (Self);
end;


destructor TSimTable.Destroy;
begin
	SimCoP.Unregister (Self);
  inherited Destroy;
end;


function TSimTable.GetField (const cName : String) : Variant;
begin

  with FieldByName (cName) do begin
    case DataType of
      ftString :
        Result := AsString;
      ftSmallint, ftInteger, ftWord, ftAutoInc :
        Result := AsInteger;
      ftBoolean :
        Result := AsBoolean;
      ftFloat, ftBCD :
        Result := AsFloat;
      ftCurrency :
        Result := AsCurrency;
      ftDate, ftTime, ftDateTime :
        Result := AsDateTime;
      ftBytes, ftVarBytes, ftBlob, ftMemo, ftGraphic, ftFmtMemo,
      ftParadoxOle, ftDBaseOle, ftTypedBinary :
        Result := AsString;
    end;
  end;

end;

procedure TSimTable.SetField (const cName : String; const Value : Variant);
var
	v : Variant;
begin

	v := Value;

  with FieldByName (cName) do begin
    case DataType of
      ftString :
        AsString		:= v;
      ftSmallint, ftInteger, ftWord, ftAutoInc :
        AsInteger 	:= v;
      ftBoolean :
        AsBoolean		:= v;
      ftFloat, ftBCD :
        AsFloat 		:= v;
      ftCurrency :
        AsCurrency	:= v;
      ftDate, ftTime, ftDateTime :
        AsDateTime	:= v;
      ftBytes, ftVarBytes, ftBlob, ftMemo, ftGraphic, ftFmtMemo,
      ftParadoxOle, ftDBaseOle, ftTypedBinary :
        AsString		:= v;
    end;
  end;

end;

end.
