//***************************************************************************
// MAIN.CPP                                         Copyright 1996 by MUTTLEY
// Main game program
//***************************************************************************

#include <conio.h>
#include <stdlib.h>
#include <math.h>
#include "modex32w.h"
#include "keys.h"
#include "2d_objs.h"
#include "structs.h"
#include "main.h"

int DispPage = 0, NonDispPage;                  // Display pages

int c,d,e,f,i,j,k,l,t;                          // Used in loops
int P1MaxBull = 5;                              // Max no of bullets for P1
int BullDelay = 2;                              // Bullet delay rate
int b = 10;                                     // Used in bullet delays


int main(void)
{
 Build_Structures();                            // Build object arrays
 SetModeX();                                    // Set graphics mode    
 Build_Waves();                                 // Build attack waves
 InitNewKeyISR();                               // Install new key ISR

 while(!KeyBuffer[MAKE_ESC]) {                      

 NonDispPage = DispPage ^ 1;                    // Swap page numbers

   // If Ship is active/dying then erase it in it's old position
   if (P1Ship.State != INACTIVE) Erase_Object(&P1Ship, NonDispPage); 

   // If any enemies active/dying then erase them in their old positions
   for (e=0; e<MAXENEMIES; e++)                     
       if (Enemies.ObjPtr[e].State != INACTIVE)
	  Erase_Object(&Enemies.ObjPtr[e], NonDispPage);

   // If any fragments active/dying then erase them in their old psoitions
   for (f=0; f<MAXFRAGS; f++)                      
       if (Fragments.ObjPtr[f].State != INACTIVE)
	  Erase_Object(&Fragments.ObjPtr[f], NonDispPage);

   // If any bullets active/dying then erase them in their old positions
   for (j=0; j<P1MaxBull; j++)                  
      if (P1Bullets[j].State != INACTIVE)       
	  Erase_Particle(&P1Bullets[j], NonDispPage);
   
   // If any thrust particles active/dying then erase them in their old positions
   for (l=0; l<MAXTHRUST; l++)                  
       if (P1Thrust[l].State != INACTIVE)        
	  Erase_Particle(&P1Thrust[l], NonDispPage);            
  


   if (KeyBuffer[MAKE_SPACE]){
      for (int s=0; s < 6; s++)                      // If SpaceBar pressed..
	  //if (Enemies.ObjPtr[s].State == INACTIVE)   // If enemy is inactive
	  //    Enemies.ObjPtr[s].State = ACTIVE;            // then re-activate it

	  P1Ship.x = rand()%300 + 30;                // Re-activate ship in     
	  P1Ship.y = rand()%200 + 30;                // a new position
	  P1Ship.State = ACTIVE;                                
   }

   if (KeyBuffer[MAKE_A])                            // If 'A' key pressed      
      if (P1Ship.State == ACTIVE) P1Ship.Angle -= 5; // Rotate ship left

   if (KeyBuffer[MAKE_S])                            // If 'S' key pressed
      if (P1Ship.State == ACTIVE) P1Ship.Angle += 5; // Rotate ship right

   if (KeyBuffer[MAKE_K]) {                          // If 'K' key pressed
      if (P1Ship.State == ACTIVE) {                  // then if Ship is active
	 Thrust_Object(&P1Ship);                     // Thrust ship forward &
	 for (k=0; k<MAXTHRUST; k++) {               // find next inactive
	     if (P1Thrust[k].State == INACTIVE) {    // thrust particle 
		Fire_Thrust(&P1Ship, &P1Thrust[k]);  // and fire it off
		break;                              
	     }                                      
	 }                                                  
      } 
   }
   else {                                            // Else 'K' key released
     if (P1Ship.State == ACTIVE) {                   // so kill acceleration
	 P1Ship.ax = P1Ship.ay = 0;                  // and slow ship down
	 P1Ship.vx *= FRICTION;                      // gradually
	 P1Ship.vy *= FRICTION;                     
     }
   }

   if (KeyBuffer[MAKE_L]) {                          // If 'L' key pressed
      if (P1Ship.State == ACTIVE) {                  // then find next  
	 for (i=0; i<P1MaxBull; i++) {               // inactive bullet & fire
	     if (P1Bullets[i].State == INACTIVE) {   // it - but only if the
		b += 1;                              // bullet delay completed
		if (b > BullDelay) {                    
		   Fire_Bullet(&P1Ship, &P1Bullets[i]); 
		   b = 0;                               
		} 
		break;                              
	     }                                      
	 }                                                  
      }
   }


   // If ship is active then move it
   if (P1Ship.State == ACTIVE) Trans_Object(&P1Ship);
   
   // If any enemies are active then move them
   for (e=0; e<MAXENEMIES; e++)             
       if (Enemies.ObjPtr[e].State == ACTIVE)
	  Trans_Object(&Enemies.ObjPtr[e]);

   // Check for collisions between ship and all active enemies
   if (P1Ship.State == ACTIVE) 
      for (e=0; e<MAXENEMIES; e++)                      
	  if (Enemies.ObjPtr[e].State == ACTIVE)        
	     Check_Object(&P1Ship, &Enemies.ObjPtr[e]); 

   // Move all active fragments
   for (f=0; f<MAXFRAGS; f++)
       if (Fragments.ObjPtr[f].State == ACTIVE)
	  Trans_Object(&Fragments.ObjPtr[f]);
  
   // Move all active bullets and check each one against all active enemies
   for (j=0; j<P1MaxBull; j++) {                
       if (P1Bullets[j].State == ACTIVE) {      
	  Trans_Particle(&P1Bullets[j]);
	  for (c=0; c<MAXENEMIES; c++)    
	      if (Enemies.ObjPtr[c].State == ACTIVE)
		 Check_Bullet(&P1Bullets[j], &Enemies.ObjPtr[c]);  
       }
   }    

   // Move all active thrust particles
   for (l=0; l<MAXTHRUST; l++)        
       if (P1Thrust[l].State == ACTIVE) 
	  Trans_Particle(&P1Thrust[l]);
	


   // If ship is not inactive then draw it
   if (P1Ship.State != INACTIVE) Draw_Object(&P1Ship, NonDispPage); 

   // Draw all non inactive enemies
   for (e=0; e<MAXENEMIES; e++)    
       if (Enemies.ObjPtr[e].State != INACTIVE)
	  Draw_Object(&Enemies.ObjPtr[e], NonDispPage);

   // Draw all non inactive fragments
   for (f=0; f<MAXFRAGS; f++)   
       if (Fragments.ObjPtr[f].State != INACTIVE)
	  Draw_Object(&Fragments.ObjPtr[f], NonDispPage);

   // Draw all non inactive bullets
   for (j=0; j<P1MaxBull; j++)     
       if (P1Bullets[j].State != INACTIVE)      
	  Draw_Particle(&P1Bullets[j], NonDispPage);
   
   // Draw all non inactive thrust particles
   for (l=0; l<MAXTHRUST; l++)          
       if (P1Thrust[l].State != INACTIVE)        
	  Draw_Particle(&P1Thrust[l], NonDispPage);     
	

 ShowPage(PageOffsets[DispPage = NonDispPage]);  // Flip the display pages


 }                                               // Repeat until 'ESC' pressed

 RestoreOldKeyISR();                             // Restore old key ISR
 ResetModeX();                                   // Reset to text mode
 return 0;
}


