//***************************************************************************
// PCXGRAF.H - Header file for PCX graphics and sprite routines
//***************************************************************************

#define SPR_WIDTH         16           // default width of a sprite
#define SPR_HEIGHT        16           // default height of a sprite
#define MAX_SPR_FRAMES    16           // Max number of sprite anim frames

#define SPRITE_DEAD       0            // Different sprite states
#define SPRITE_ALIVE      1
#define SPRITE_DYING      2


// DEFINED EXTERNALS --------------------------------------------------------
extern int Screen_Width, Screen_Height;


// DEFINED STRUCTURES -------------------------------------------------------
// The structure of a PCX file
typedef struct PCXHeaderType {
        char manufacturer;             // Manufacturer of the file
        char version;                  // File format version
        char encoding;                 // Type of compression
        char bits_per_pixel;           // Number of bits per pixel
        int x, y;                      // Starting location of image
        int width,height;              // Dimensions of image
        int horz_res;                  // Resolution in DPI (dots per inch)
        int vert_res;
        char ega_palette[48];          // Old EGA palette (usually ignored)
        char reserved;                 // Reserved for future use
        char num_color_planes;         // Number of color planes
        int bytes_per_line;            // Number of bytes per line of image
        int palette_type;              // 1 for color, 2 for grey scale
        char padding[58];              // Extra padding bytes
} PCXHeader, *PCXHeaderPtr;


// This structure holds the PCX header and the actual image data
typedef struct PCXPictureType {
        PCXHeader header;              // Header of the PCX file
        RGBColor palette[256];         // Palette data
        unsigned char far *buffer;     // Ptr to buffer holding final image
} PCXPicture, *PCXPicturePtr;


// Structure for a bitmap
typedef struct BitmapType
        {
        int x, y;                      // Position of bitmap
        int width, height;             // Size of bitmap
        unsigned char far *buffer;     // Buffer holding image

        } Bitmap, *BitmapPtr;


// Structure for a sprite
typedef struct SpriteType {
        int x, y;                      // Position of sprite
        int dx, dy;                    // Direction vectors
        int width, height;             // Dimensions of sprite
        int cntr1, cntr2, cntr3;       // Counters for timing and animation
        int thr1, thr2, thr3;          // Thresholds for the counters
        unsigned char far *frames[MAX_SPR_FRAMES]; // Array of ptrs to frames
        unsigned char far *background; // Ptr to image under the sprite
        int curr_frame;                // Current frame being displayed
        int num_frames;                // Total number of frames
        int state;                     // Holds state of sprite
        int x_clip, y_clip;            // Clipped position of sprite
        int width_clip, height_clip;   // Clipped size of sprite
        int visible;                   // Flags if sprite is visible or not
} Sprite, *SpritePtr;


// DEFINED PROTOTYPES -------------------------------------------------------
int  PCX_Init(PCXPicturePtr image);

int  PCX_Load(char *filename, PCXPicturePtr image, int enable_palette);

void PCX_Delete(PCXPicturePtr image);

void PCX_Show_Buffer(PCXPicturePtr image);

void PCX_Copy_To_Buffer(PCXPicturePtr image, unsigned char far *buffer);

void PCX_Get_Sprite(PCXPicturePtr image, SpritePtr sprite, int sprite_frame,
                    int loc_x, int loc_y);

void Sprite_Init(SpritePtr sprite, int x, int y, int dx, int dy, int width,
                 int height, int c1, int c2, int c3, int t1,int t2,int t3);

void Sprite_Delete(SpritePtr sprite);

void Sprite_Under(SpritePtr sprite, unsigned char far *buffer);

void Sprite_Erase(SpritePtr sprite, unsigned char far *buffer);

void Sprite_Erase_Quick(SpritePtr sprite, unsigned char far *buffer);

void Sprite_Draw(SpritePtr sprite, int transparent);

void Sprite_Under_Clip(SpritePtr sprite, unsigned char far *buffer);

void Sprite_Erase_Clip(SpritePtr sprite, unsigned char far *buffer);

void Sprite_Draw_Clip(SpritePtr sprite, unsigned char far *buffer, int transparent);

int  Sprite_Collide(SpritePtr sprite_1, SpritePtr sprite_2);

void fwordcpy(void far *destination, void far *source, int num_words);


