//***************************************************************************
// STRUCTS.CPP                                      Copyright 1996 by MUTTLEY
// Module that builds different structures used throughout the game
//***************************************************************************

#include <stdlib.h>
#include <math.h>
#include "modex32w.h"
#include "2d_objs.h"
#include "structs.h"


//---------------------------------------------------------------------------
void Build_Structures()
// Routine to initialise the different object arrays
{
 Build_SinCos_Tables();				 // Build trig tables

 Create_Player(15, 4, 80, 80, 0, 0, 0, 0, 5, 5, 0, 0, ACTIVE, P1ShipVerts);

 Enemies.ObjPtr = new ObjectType [MAXENEMIES];  // Allocate memory for enemies

 // Initialise array with dummy enemies
 for (int i=0; i<MAXENEMIES; i++) 
     Create_Enemy(i, ENEMYTYPE, 10, 8, 100, 100, 0, 0, 0, 0, 0, 0, 0, 0, DYING, Star4Verts);

 // Set up some real enemies
 // Create_Enemy(0, ENEMYTYPE, 10, 8, 100, 100, -1, 1, 0, 0, 5, 5, 0, 8, ACTIVE, Star4Verts);
 Create_Enemy(0, ROCKTYPE, 12, 10, 120, 80, 1, 1, 0, 0, 5, 5, 0, -4, ACTIVE, Rock1Verts);
 Create_Enemy(1, ROCKTYPE, 12, 7, 280, 50, -1, 2, 0, 0, 5, 5, 0, 3, ACTIVE, Rock2Verts);
 Create_Enemy(2, ROCKTYPE, 12, 8, 180, 150, 2, -1, 0, 0, 5, 5, 0, 5, ACTIVE, Rock3Verts);
 Create_Enemy(3, ROCKTYPE, 12, 10, 50, 90, -1, -1, 0, 0, 5, 5, 0, -3, ACTIVE, Rock1Verts);
 Create_Enemy(4, ROCKTYPE, 12, 7, 190, 120, 1, 2, 0, 0, 5, 5, 0, 6, ACTIVE, Rock2Verts);
 Create_Enemy(5, ROCKTYPE, 12, 8, 80, 170, 2, 2, 0, 0, 5, 5, 0, -7, ACTIVE, Rock3Verts);
 

 Fragments.ObjPtr = new ObjectType [MAXFRAGS];  // Allocate memory for frags

 // Initialise array with dummy fragments
 for (int f=0; f<MAXFRAGS; f++) {
     Fragments.ObjPtr[f].Type = FRAGTYPE;   	
     Fragments.ObjPtr[f].Scale = LARGE;	
     Fragments.ObjPtr[f].Color = 0;
     Fragments.ObjPtr[f].NumVerts = 2;     
     Fragments.ObjPtr[f].Track_Index = 0;     
     Fragments.ObjPtr[f].x = 0;
     Fragments.ObjPtr[f].y = 0;
     Fragments.ObjPtr[f].vx = 0;
     Fragments.ObjPtr[f].vy = 0;
     Fragments.ObjPtr[f].ax = 0;
     Fragments.ObjPtr[f].ay = 0;
     Fragments.ObjPtr[f].mx = 0;
     Fragments.ObjPtr[f].my = 0;
     Fragments.ObjPtr[f].Angle = 100;
     Fragments.ObjPtr[f].Rotate = 0;
     Fragments.ObjPtr[f].State = INACTIVE;
     Fragments.ObjPtr[f].VertPtr = new VertexType [2]; 
     Fragments.ObjPtr[f].VertPtr[0].lx = 0;
     Fragments.ObjPtr[f].VertPtr[0].ly = 0;
     Fragments.ObjPtr[f].VertPtr[1].lx = 0;
     Fragments.ObjPtr[f].VertPtr[1].ly = 0;

     for (int v=0; v < 2; v++) {
         Fragments.ObjPtr[f].VertPtr[v].rx = 0;	      
         Fragments.ObjPtr[f].VertPtr[v].ry = 0;      	
         Fragments.ObjPtr[f].VertPtr[v].sx = 0;
         Fragments.ObjPtr[f].VertPtr[v].sy = 0;
         Fragments.ObjPtr[f].VertPtr[v].ox = 0;
         Fragments.ObjPtr[f].VertPtr[v].oy = 0;
     }
 }     
}

//---------------------------------------------------------------------------
void Create_Enemy(int Index, int Type, int Color, int NumVerts, int x, int y, 
		  float vx, float vy, float ax, float ay, int mx, int my, 
		  int Angle, int Rotate, int State, PointType *Shape)
// Routine to create a new enemy object and add it to the enemy array
{
 Enemies.ObjPtr[Index].Type = Type;
 Enemies.ObjPtr[Index].Scale = LARGE;
 Enemies.ObjPtr[Index].Color = Color;
 Enemies.ObjPtr[Index].NumVerts = NumVerts;
 Enemies.ObjPtr[Index].Track_Index = rand()%199;
 Enemies.ObjPtr[Index].x = x;
 Enemies.ObjPtr[Index].y = y;
 Enemies.ObjPtr[Index].vx = vx;
 Enemies.ObjPtr[Index].vy = vy;
 Enemies.ObjPtr[Index].ax = ax;
 Enemies.ObjPtr[Index].ay = ay;
 Enemies.ObjPtr[Index].mx = mx;
 Enemies.ObjPtr[Index].my = my;
 Enemies.ObjPtr[Index].Angle = Angle;
 Enemies.ObjPtr[Index].Rotate = Rotate;
 Enemies.ObjPtr[Index].State = State;
 Enemies.ObjPtr[Index].VertPtr = new VertexType [NumVerts]; // Ptr to verts	

 for (int v=0; v<NumVerts; v++) {			// Initialise verts
     Enemies.ObjPtr[Index].VertPtr[v].lx = Shape[v].x;	// Copy shape co-ords
     Enemies.ObjPtr[Index].VertPtr[v].ly = Shape[v].y;  // into this object
     Enemies.ObjPtr[Index].VertPtr[v].rx = 0;
     Enemies.ObjPtr[Index].VertPtr[v].ry = 0;
     Enemies.ObjPtr[Index].VertPtr[v].sx = 0;
     Enemies.ObjPtr[Index].VertPtr[v].sy = 0;
     Enemies.ObjPtr[Index].VertPtr[v].ox = 0;
     Enemies.ObjPtr[Index].VertPtr[v].oy = 0;
 }
}


//---------------------------------------------------------------------------
void Create_Player(int Color, int NumVerts, int x, int y, float vx, float vy,
		   float ax, float ay, int mx, int my, int Angle, int Rotate,
		   int State, PointType *Shape)
// Routine to create a new player object
{
 P1Ship.Type = PLAYERTYPE;
 P1Ship.Scale = LARGE;
 P1Ship.Color = Color;
 P1Ship.NumVerts = NumVerts;
 P1Ship.Track_Index = 0;			// Ships don't follow pattern
 P1Ship.x = x;
 P1Ship.y = y;
 P1Ship.vx = vx;
 P1Ship.vy = vy;
 P1Ship.ax = ax;
 P1Ship.ay = ay;
 P1Ship.mx = mx;
 P1Ship.my = my;
 P1Ship.Angle = Angle;
 P1Ship.Rotate = Rotate;
 P1Ship.State = State;
 P1Ship.VertPtr = new VertexType [NumVerts];            // Ptr to verts	
 for (int v=0; v<NumVerts; v++) {			// Initialise verts
     P1Ship.VertPtr[v].lx = Shape[v].x;			// Copy shape co-ords
     P1Ship.VertPtr[v].ly = Shape[v].y;     	 	// into this object
     P1Ship.VertPtr[v].rx = 0;
     P1Ship.VertPtr[v].ry = 0;
     P1Ship.VertPtr[v].sx = 0;
     P1Ship.VertPtr[v].sy = 0;
     P1Ship.VertPtr[v].ox = 0;
     P1Ship.VertPtr[v].oy = 0;
 }

}

//---------------------------------------------------------------------------
void Explode_Object(ObjectType *Object)
// Explodes an object into a number of line fragment objects
{
 int f, i, Index=0, v2;

 srand(Object->x + Object->y);		    // Seed random number generator

 for (i=0; i<Object->NumVerts; i++) {       // For every vert in the object..
     v2 = i + 1;			    // Get next vert after current one
     if (v2 >= Object->NumVerts) {          // Wrap v2 to point to the first
        v2 = 0;				    // vertex if necessary
     }

     for (f=0; f<MAXFRAGS; f++) {		    // Get the next free
         if (Fragments.ObjPtr[f].State == INACTIVE) // position in the
	    Index = f;				    // array
     }

     Fragments.ObjPtr[Index].Type = FRAGTYPE;       // Fragment type object	
     Fragments.ObjPtr[Index].Scale = LARGE;
     Fragments.ObjPtr[Index].Color = Object->Color; // Get color
     Fragments.ObjPtr[Index].NumVerts = 2;          // Lines only have 2 points
     Fragments.ObjPtr[Index].Track_Index = 0;       // Frags don't follow patt


     // Find the new origin for this line fragment
     Fragments.ObjPtr[Index].x = Object->x + (Object->VertPtr[i].lx + Object->VertPtr[v2].lx) / 2;
     Fragments.ObjPtr[Index].y = Object->y + (Object->VertPtr[i].ly + Object->VertPtr[v2].ly) / 2;

     // Create a random velocity for the line fragment
     Fragments.ObjPtr[Index].vx = rand()%3 - rand()%3;
     Fragments.ObjPtr[Index].vy = rand()%3 - rand()%3;

     // Next line makes sure fragment does not stay still
     if ((Fragments.ObjPtr[Index].vx == 0) && (Fragments.ObjPtr[Index].vy == 0))
        Fragments.ObjPtr[Index].vx = Fragments.ObjPtr[Index].vx = 1;  

     Fragments.ObjPtr[Index].ax = 0;
     Fragments.ObjPtr[Index].ay = 0;
     Fragments.ObjPtr[Index].mx = 10;
     Fragments.ObjPtr[Index].my = 10;
     Fragments.ObjPtr[Index].Angle = 100;
     Fragments.ObjPtr[Index].Rotate = rand()%20 - rand()%20;
     Fragments.ObjPtr[Index].State = ACTIVE;
     Fragments.ObjPtr[Index].VertPtr = new VertexType [2]; // Ptr to line verts	

     // Find new local verts for first point of line fragment
     Fragments.ObjPtr[Index].VertPtr[0].lx = (Object->VertPtr[i].lx - Object->VertPtr[v2].lx) / 2;
     Fragments.ObjPtr[Index].VertPtr[0].ly = (Object->VertPtr[i].ly - Object->VertPtr[v2].ly) / 2;

     // Find new local verts for second point of line fragment
     Fragments.ObjPtr[Index].VertPtr[1].lx = -(Object->VertPtr[i].lx - Object->VertPtr[v2].lx) / 2;
     Fragments.ObjPtr[Index].VertPtr[1].ly = -(Object->VertPtr[i].ly - Object->VertPtr[v2].ly) / 2;

     for (int v=0; v < 2; v++) {
         Fragments.ObjPtr[Index].VertPtr[v].rx = 0;      // Set other co-ords 
         Fragments.ObjPtr[Index].VertPtr[v].ry = 0;      // to 0	
         Fragments.ObjPtr[Index].VertPtr[v].sx = 0;
         Fragments.ObjPtr[Index].VertPtr[v].sy = 0;
         Fragments.ObjPtr[Index].VertPtr[v].ox = 0;
         Fragments.ObjPtr[Index].VertPtr[v].oy = 0;
     }
 }
}

//---------------------------------------------------------------------------
void Spawn_Object(ObjectType *Object)
// Splits an object into smaller versions of itself
{
 int f, i, Index=0, v;

 srand(Object->x + Object->y);		    // Seed random number generator

 for (i=0; i<3; i++) {                      // Create 3 spawned objects


     for (f=0; f<MAXENEMIES; f++) {		    // Get the next free
         if (Enemies.ObjPtr[f].State == INACTIVE)   // position in the
	    Index = f;				    // enemy object array
     }

     Enemies.ObjPtr[Index].Type = ENEMYTYPE;            // Enemy type object	

     // Change the scale of ROCKS accordingly depending on current size
     if (Object->Type == ROCKTYPE) {
        if (Object->Scale == LARGE) Enemies.ObjPtr[Index].Scale = MEDIUM;		
        if (Object->Scale == MEDIUM) Enemies.ObjPtr[Index].Scale = SMALL;		
     }
     // Else make all other types of enemy small 
     else 
        Enemies.ObjPtr[Index].Scale = SMALL;
     
     Enemies.ObjPtr[Index].Color = Object->Color;       // Duplicate color
     Enemies.ObjPtr[Index].NumVerts = Object->NumVerts; // Same no. of verts
     Enemies.ObjPtr[Index].Track_Index = 0;             // Don't follow patt
	

     // Find the new origin for this spawned object - will be same as master
     Enemies.ObjPtr[Index].x = Object->x;
     Enemies.ObjPtr[Index].y = Object->y;

     // Create a random velocity for the spawned object
     Enemies.ObjPtr[Index].vx = (rand()%2 - rand()%2) * .75;
     Enemies.ObjPtr[Index].vy = (rand()%2 - rand()%2) * .75;

     // Next line makes sure spawned object does not stay still
     if ((Enemies.ObjPtr[Index].vx == 0) && (Enemies.ObjPtr[Index].vy == 0))
        Enemies.ObjPtr[Index].vx = Enemies.ObjPtr[Index].vy = 1;  

     // Initialise other variables
     Enemies.ObjPtr[Index].ax = 0;
     Enemies.ObjPtr[Index].ay = 0;
     Enemies.ObjPtr[Index].mx = Object->mx;
     Enemies.ObjPtr[Index].my = Object->my;
     Enemies.ObjPtr[Index].Angle = rand()%360;
     Enemies.ObjPtr[Index].Rotate = rand()%10 - rand()%10;
     Enemies.ObjPtr[Index].State = ACTIVE;
     Enemies.ObjPtr[Index].VertPtr = new VertexType [Object->NumVerts]; 	

     // Copy scaled down local co-ords of master object into spawned object
     for (int v=0; v < Object->NumVerts; v++) {
         Enemies.ObjPtr[Index].VertPtr[v].lx = Object->VertPtr[v].lx * .75;
         Enemies.ObjPtr[Index].VertPtr[v].ly = Object->VertPtr[v].ly * .75;

         Enemies.ObjPtr[Index].VertPtr[v].rx = 0;      // Set other co-ords 
         Enemies.ObjPtr[Index].VertPtr[v].ry = 0;      // to 0	
         Enemies.ObjPtr[Index].VertPtr[v].sx = 0;
         Enemies.ObjPtr[Index].VertPtr[v].sy = 0;
         Enemies.ObjPtr[Index].VertPtr[v].ox = 0;
         Enemies.ObjPtr[Index].VertPtr[v].oy = 0;
     }
 }
}

//---------------------------------------------------------------------------
void Build_SinCos_Tables()
// Routine to build trig lookup tables
{
 int angle;
 float rad;

 for (angle=0; angle<361; angle++) {
     rad = angle * 0.017453; 		// Degrees to Radians
     Sin_Look[angle] = sin(rad);	// Build Sin table
     Cos_Look[angle] = cos(rad);	// Build Cos table
 }		
}

//---------------------------------------------------------------------------
void Build_Waves()
{
 int cx = 160;					// Centre of attack pattern
 int cy = 120;
 int index = 0;					// Index into track array
 float theta = 0;
 float twopi = 6.28;
 float size = 110;
 float radius;
 
 
 // Next section builds a 3 leaf wave
 Wave_3Leaf[index].x = cx + size;
 Wave_3Leaf[index].y = cy;
 while (theta < twopi) {
   radius = size * cos(3 * theta);
   index += 1;
   Wave_3Leaf[index].x = cx + radius * cos(theta);
   Wave_3Leaf[index].y = cy + radius * sin(theta);
   theta += .0157;
 }

}
