//***************************************************************************
// STRUCTS.H 					    Copyright 1996 by MUTTLEY
// Header file for building object structures 
//***************************************************************************

//--- DEFINED EXTERNALS -----------------------------------------------------

// These arrays will hold the Sin and Cos look-up tables
extern float Sin_Look[361];
extern float Cos_Look[361];


// These definitions hold the local co-ords for the different enemy shapes
extern PointType P1ShipVerts[];
extern PointType Star4Verts[];	   	 
extern PointType Star5Verts[]; 
extern PointType DiamondVerts[];	
extern PointType DiabloVerts[]; 	
extern PointType Rock1Verts[];
extern PointType Rock2Verts[];
extern PointType Rock3Verts[];

// These definitions hold the co-ords of different attack waves
extern PointType Wave_3Leaf[401];			

extern ObjectType P1Ship;				// Player 1 object
extern ObjectListType Enemies;				// Array of enemies
extern ObjectListType Fragments;			// Array of fragments
extern ParticleType P1Bullets[MAXBULLETS];		// Player 1 bullets
extern ParticleType P1Thrust[MAXTHRUST];      		// Player 1 thrust particles


//---------------------------------------------------------------------------

void Build_SinCos_Tables();			// Builds trig tables
void Build_Structures();			// Sets up object arrays
void Build_Waves();				// Build attack wave arrays

void Create_Enemy(int Index, int Type, int Color, int NumVerts, int x, int y, 
		  float vx, float vy, float ax, float ay, int mx, int my, 
		  int Angle, int Rotate, int State, PointType *Shape);

void Create_Player(int Color, int NumVerts, int x, int y, float vx, float vy,
		   float ax, float ay, int mx, int my, int Angle, int Rotate,
		   int State, PointType *Shape);

void Explode_Object(ObjectType *Object);
void Spawn_Object(ObjectType *Object);


