/* 
   BOBOLI THE MIGHTY KNIGHT
   Networked Medieval Conflict
*/

#include "mgraph.h"

#ifndef _boboli_gogo_
#define _boboli_gogo_

/* the cmd_ constants are the bits of the command byte of the player
   record.  It is the only real information to be sent across the network
   for each player.  Everything else MUST remain in sync between computers. 
*/
#define cmd_up 1  /* command&1 is up key */
#define cmd_lf 2
#define cmd_dn 4
#define cmd_rt 8
#define cmd_at 16 /* command&16 is the attack key */
#define cmd_next 32 /* go to next item */
#define cmd_drop 64 /* drop item */
#define cmd_use  128  /* use item */

#define Player_pressed_ESC 0xFF
/* the do_ constants define what "move" the character is executing. */
#define do_stand 0
#define do_walk  1
#define do_melee 2
#define do_ouch  3
#define do_spell 4  /* or whatever special trick this guy has */
#define do_arrow 5  /* this means launching a projectile */
#define do_get   6
#define do_bigouch 7 /* knocked down */
#define do_die   8

/* display modes */
#define md_none   0
#define md_normal 1
#define md_boboli 2
#define md_shadow 3
#define md_floor  4 /* same as mode normal, but is drawn before all else */

/* item types */
#define it_none     0
/* no item #1, because item numbers must correspond with object #s */
#define it_xbow     2
#define it_fball    3
#define it_inferno  4
#define it_3xbow    5
#define it_elfswd   6
#define it_gntswd   7
#define it_souledge 8
#define it_mirshield 9
#define it_tornado  10
#define it_fxbow    11
#define it_souledge2 12
#define it_greenthumb 13
#define it_invis     14
#define it_shieldspl 15
#define it_healing   16
#define it_summon    17

/* map object types */
#define ob_none   0
#define ob_genrtr 1
#define ob_xbow   2
#define ob_fball  3
#define ob_inferno 4
#define ob_3xbow    5
#define ob_elfswd   6
#define ob_gntswd   7
#define ob_souledge 8
#define ob_mirshield 9
#define ob_tornado  10
#define ob_fxbow    11
#define ob_souledge2 12
#define ob_greenthumb 13
#define ob_invis     14
#define ob_shieldspl 15
#define ob_healing   16
#define ob_summon    17
#define ob_flower    18

/* generator types */
#define gn_none     0
#define gn_bonehead 1
#define gn_glob     2
#define gn_boboli   3

/* projectile types */
#define pr_none  0
#define pr_spark 1
#define pr_arrow 2
#define pr_slime 3
#define pr_splat 4
#define pr_fball 5
#define pr_inferno 6
#define pr_brightspot 7 /* the bright thing right before an inferno lights up */
#define pr_hsprk 8 /* 'hit'spark */
#define pr_tornado 9
#define pr_tornado_hit 10
#define pr_splash 11
#define pr_smoke 12
#define pr_skull 13
#define pr_tornado_done 14
#define pr_shield 15
#define pr_flower 16
#define pr_golem  17
#define pr_burst  18 /* green inferno flame */
#define pr_homing 19 /* homing blob */

/* bit fields for 'state' record for each creature */
#define st_invis  1
#define st_invinc 2

/* each type of creature has 10 "moves" (walking, attacking, etc.), each
   of which has 25 frames */
#define nummoves 10
#define numsteps 25

/* size of maps */
#define mapwidth 128
#define mapheight 128

/* size of virtual screen upon which background is drawn */
#define backgdwidth  256
#define backgdheight 256

#define maxguys   70
#define maxgen    30
#define numplayers 4
#define maxdisplay 60
#define maxprjctls 100
#define souledgefull 1000 /* 100 hit points are needed to fill Soul Edge */
#define FRAMERATE 35

typedef struct {
  byte x,y;
  byte hp;
  byte frame;
  byte kind;
  word timer;
} genrec;

typedef struct {
  umkrec u;
  short x,y,cmpy;
  byte mode;
  byte value;
} displayrec;

typedef struct {
  char name[17];
  byte color;
  byte command;
  byte who;     /* which creature is he?  guy[who] */
  byte victimkind;  /* for hitpoint display */
  byte victimhp;
  byte victimcurhp;
  byte hptimer;
  byte strength,speed,intellect,armor,skill;
  byte magic,selfhp;
  byte magictimer;
  byte selfhptimer;
  byte realmagic,realselfhp;
  byte inv[6];
  byte using;
  byte spell;
  byte skillmax;
  char message[17];
  byte messtimer;
  word souledgecharge;
  word invistimer;
  word invinctimer;
  byte homex,homey;
} playerrec;

typedef struct {
  short x,y;
  byte z;
  char dx,dy,dz;
  short hp;
  byte kind;
  byte doing;
  byte dir;
  byte frame;
  byte control;
  byte nearfoe;
  byte friend;
  byte timer;
  byte state;
} creature;

typedef struct {
  short x,y;
  byte z;
  char dx,dy;
  char dz;
  byte dir;
  byte kind;
  byte timer;
  byte launchguy;
  byte launcher; /* the 'control' value for the guy who launched it */
} projectile;

typedef struct {
  byte floor;
  byte object;
  byte shadow;
} tilerec;

typedef tilerec maprec[mapwidth*mapheight];

typedef byte tileset[128][256];

typedef struct {
  byte x,y;
} centerrec;
  
typedef centerrec centerray[256];

extern playerrec player[numplayers];

#endif
