/*
  COM port library.
*/

#include "com.h"

byte data_rcvd=0;
static unsigned short port;
/* the various registers relative to the base port number */
#define xmit_buf      (port)
#define recv_buf      (port)
#define baudset_lo    (port)
#define baudset_hi    (port+1)
#define line_control  (port+3)
#define modem_control (port+4)
#define line_status   (port+5)
#define modem_status  (port+6)

void init_rs232(byte which) 
{
  short divisor;
  byte divlow,divhigh;
  byte settings;
  if(which==0) {      /* com 1 */
    port = 0x03F8;
  } else {            /* com 2 */
    port = 0x02F8;
  }
  settings=BITS_8|STOP_1|NO_PARITY;
  divisor=115200/baud_rate;
  disable();
  outportb(line_control,settings|0x80);
  outportb(baudset_lo,divisor&0xFF);
  outportb(baudset_hi,(divisor>>8)&0xFF);
  outportb(line_control,settings&0x7F);
  enable();
}

void send_packet(byte packet)
{
  while(~inportb(line_status)&0x20);
  outportb(xmit_buf,packet);
}

byte recv_packet(void)
{
  if(!(inportb(line_status)&1)) return 0; /* nothing to receive yet */
  data_rcvd=1;
  return(inportb(recv_buf));
}
