#include <stdio.h>
#include <dpmi.h>
#include <sys\movedata.h>
#include <stdlib.h>
#include <sys\nearptr.h>
#include "mgraph.h"
#include <pc.h>

scrntype screen;

void gmode(byte mode)
{
  __dpmi_regs regs;
  regs.x.ax=mode;
  __dpmi_int(0x10,&regs);
}

void scrcpy(scrntype src,scrntype dst)
{
  memcpy(dst,src,64000);  /* could be faster? */
}

void near_scrcpy(scrntype src,scrntype dst)
{
  memcpy(dst,src,64000);  /* could be faster? */
}

void initmg()
{
  screen=(scrntype)(0xa0000 + __djgpp_conventional_base);
}

void loadpal(char *name,paltype p)
{
  FILE *f;
  f=fopen(name,"rb");
  fread(p,768,1,f);
  fclose(f);
}

void getpal(paltype p)
{
  int i;
  for(i=0;i<256;i++) {
    outportb(0x3C7,i);
    p[i][0]=inportb(0x3C9) & 0x3F;
    p[i][1]=inportb(0x3C9) & 0x3F;
    p[i][2]=inportb(0x3C9) & 0x3F;
  }
}

void fade_in(byte r, byte g, byte b, paltype p1)
{
  paltype p2;
  int i,j,k,l;
  for(i=0;i<256;i++) {
    p2[i][0]=r;
    p2[i][1]=g;
    p2[i][2]=b;
  }
  do {
    k=0;
    for(i=0;i<256;i++) {
      j=0;
      for(l=0;l<3;l++) {
        if(p2[i][l]!=p1[i][l])
          p2[i][l]+=(p1[i][l]>p2[i][l])-(p1[i][l]<p2[i][l]);
        else j++;
      }
      if(j==3) k++;
    }
    waitretrace();
    setpal(p2);
  } while(k<256);
}
 
void fade_out(byte r, byte g, byte b, paltype p1)
{
  paltype p2;
  int i,j,k;
  for(i=0;i<256;i++) {
    p2[i][0]=p1[i][0];
    p2[i][1]=p1[i][1];
    p2[i][2]=p1[i][2];
  }
  do {
    k=0;
    for(i=0;i<256;i++) {
      j=0;
      if(p2[i][0]!=r)
        p2[i][0]+=(r>p2[i][0])-(r<p2[i][0]);
      else j++;
      if(p2[i][1]!=g)
        p2[i][1]+=(g>p2[i][1])-(g<p2[i][1]);
      else j++;
      if(p2[i][2]!=b)
        p2[i][2]+=(b>p2[i][2])-(b<p2[i][2]);
      else j++;
      if(j==3) k++;
    }
    waitretrace();
    setpal(p2);
  } while(k<256);
}

void waitretrace()
{
  while(inportb(0x3DA)&0x8);
  while(!(inportb(0x3DA)&0x8));
}

void setcol(byte c, byte r, byte g,byte b)
{
  outportb(0x3C8,c);
  outportb(0x3C9,r);
  outportb(0x3C9,g);
  outportb(0x3C9,b);
}

void setpal(paltype pal)
{
  int i;
  outportb(0x3C8,0);
  for(i=0;i<256;i++) {
    outportb(0x3C9,pal[i][0]);
    outportb(0x3C9,pal[i][1]);
    outportb(0x3C9,pal[i][2]);
  }
}

void line(short x,short y,short x2,short y2,byte col,scrntype scrn)
{
  short count,slope,ypos,ydir,xpos,xdir,dx,dy;
  ypos=y;
  dy=y2-y;
  if(dy<0) ydir=-1;
  if(dy>0) ydir=1;
  if(dy==0) ydir=0;
  dy=abs(dy);  
  xpos=x;
  dx=x2-x;
  if(dx<0) xdir=-1;
  if(dx>0) xdir=1;
  if(dx==0) xdir=0;
  dx=abs(dx);
  if(dx<=dy) {
    slope=dx*2-dy;
    for(count=0;count<=dy;count++) {
      if((xpos>-1)&&(xpos<320)&&(ypos>-1)&&(ypos<200))
        scrn[xpos+ypos*320]=col;
      if(slope>0) {
        slope+=2*(dx-dy);
        xpos+=xdir;
      } else slope+=2*dx;
      ypos+=ydir;
    }
    return;
  }
  slope=2*dy-dx;
  for(count=0;count<=dx;count++) {
    if((xpos>-1)&&(xpos<320)&&(ypos>-1)&&(ypos<200))
      scrn[xpos+ypos*320]=col;
    if(slope>0) {
      slope+=2*(dy-dx);
      ypos+=ydir;
    } else slope+=2*dy;
    xpos+=xdir;
  }
}

void scale_xfer(rect s,rect d,scrntype src,scrntype dst)
{
  unsigned int i,j,dx,dy;
  unsigned int wid,hgt;
  unsigned int x,y,ty,maxy;
  wid=((s.x2-s.x)<<6)/(d.x2-d.x);
  hgt=((s.y2-s.y)<<6)/(d.y2-d.y);
  y=s.y<<6;
  dy=d.y*320;
  maxy=(d.y2+1)*320;
  do {
    ty=(y>>6)*320;
    dx=d.x;
    x=s.x<<6;
    do {
      x+=wid;
      dst[dx+dy]=src[(x>>6)+ty];
      dx++;   
    } while(dx<d.x2);
    dy+=320;
    y+=hgt;
  } while(dy<maxy);

}

void clear(byte col,scrntype scrn)
{
  memset(scrn,col,64000);
}

void xfer(short x,short y,short x2,short y2,scrntype src,scrntype dst)
{
  unsigned short yy,xx,w;
  w=x2-x+1;
  for(yy=y;yy<=y2;yy++) {
    xx=x+yy*320;
    memcpy(&(dst[xx]),&(src[xx]),w);
  }
}

byte loadPCX(char *name,paltype pal,scrntype scrn)
{
  FILE *f;
  byte *buf;
  long amt,bpos=0;
  int i,j;
  int pos=0;
  byte v,x;
  f=fopen(name,"rb");
  fseek(f,-768L,SEEK_END);
  amt=ftell(f)-128;
  fread(pal,1,768,f);
  for(i=0;i<256;i++)
    for(j=0;j<3;j++) pal[i][j]=pal[i][j]>>2;
  fseek(f,128,SEEK_SET);
  if(!(buf=malloc(amt))) {
    fclose(f);
    return -1;
  }  
  fread(buf,1,amt,f);
  fclose(f);
  while(pos<64000) {
    v=buf[bpos++];
    if((v&0xC0)==0xC0) {
      x=v&0x3F;
      v=buf[bpos++];
      while((x--)>0) scrn[pos++]=v;
    } else scrn[pos++]=v;
  }
  free(buf);
  return 0;
}

void box(short x,short y,short x2,short y2,byte col, scrntype dst)
{
  unsigned short yy,xx,w;
  w=x2-x+1;
  for(yy=y;yy<=y2;yy++) {
    xx=x+yy*320;
    memset(&(dst[xx]),col,w);
  }
}

/* LAME ASS PRINTING CRAP WITH BIOS... */

void lame_gotoxy(byte x,byte y)
{
  __dpmi_regs r;
  r.h.dh=y;
  r.h.dl=x;
  r.h.bh=0;
  r.h.ah=2;
  __dpmi_int(0x10,&r);
}

void lame_printchar(char c, byte col)
{
  __dpmi_regs r;
  r.h.al=c;
  r.h.bl=col;
  r.h.ah=14;
  __dpmi_int(0x10,&r);

}

void lame_print(char *s, byte col)
{
  int i;
  for(i=1;i<strlen(s);i++)
    lame_printchar(s[i],col);
}

void lame_printat(byte x,byte y, char *s, byte col)
{
  int i;
  lame_gotoxy(x,y);
  for(i=0;i<(strlen(s)-1);i++)
    lame_printchar(s[i],col);
}

/* END LAME ASS PRINTING CRAP WITH BIOS... */
