/* MKEY
   keyboard interface unit
*/

#ifndef _mkey_gogo
#define _mkey_gogo

#define pressed 1
#define held 2
#define released 3
#define open 0

typedef unsigned char keyarray[128];

/* extern variables */

extern keyarray oldkeyb,keyb;
extern unsigned char keyspressed[20];
extern unsigned char numkeyspressed;
extern unsigned char keyevent;

/* forward declarations */

void kb_init();
void kb_exit(void);
unsigned char keypress();
unsigned char keystate(unsigned char k);
void kb_clearbuf();

/* Key defines follow... LONG */

#define Esc 1
#define _1 2
#define _2 3
#define _3 4
#define _4 5
#define _5 6
#define _6 7
#define _7 8
#define _8 9
#define _9 10
#define _0 11
#define Minus 12
#define Plus 13
#define BS 14
#define Tab 15
#define _Q 16
#define _W 17
#define _E 18
#define _R 19
#define _T 20
#define _Y 21
#define _U 22
#define _I 23
#define _O 24
#define _P 25
#define Lbracket 26
#define RBracket 27
#define Enter 28
#define Ctrl 29
#define _A 30
#define _S 31
#define _D 32
#define _F 33
#define _G 34
#define _H 35
#define _J 36
#define _K 37
#define _L 38
#define Colon 39
#define Quote 40
#define Tilde 41
#define LShift 42
#define BackSlash 43
#define _Z 44
#define _X 45
#define _C 46
#define _V 47
#define _B 48
#define _N 49
#define _M 50
#define Comma 51
#define Period 52
#define Question 53
#define RShift 54
#define Asterisk 55
#define Alt 56
#define Space 57
#define Caps 58
#define F1 59
#define F2 60
#define F3 61
#define F4 62
#define F5 63
#define F6 64
#define F7 65
#define F8 66
#define F9 67
#define F10 68
#define NumLock 69
#define ScrLock 70
#define Home 71
#define Up 72
#define PgUp 73
#define GreyMinus 74
#define Left 75
#define Center 76  {Center of Numeric Keypad}
#define Right 77
#define GreyPlus 78
#define _End 79
#define Down 80
#define PgDn 81
#define Ins 82
#define Del 83
#define F11 87
#define F12 88

#endif
