#ifndef __GTILE_H__
#define __GTILE_H__

//GTILE.H
//Copyright (c) 1996 Kevin Hoffman
//All Rights Reserved

//Feel free to use this code in your own applications and programs :)
//If you're nice you can give me some credit :)

//This file contains some C api functions to draw a tiled world :)
//Enjoy! It should compile on the Microsoft,Turbo C++, and Watcom C++
//compilers. :)

#include "mydefs.h" //Include some standard defs :)

#ifndef TILEINFO_MAXTILES
  //The number of different bitmaps for the
  //tiles(i.e. different bitmaps for tiles) you can have!
  #define TILEINFO_MAXTILES     128
#endif

//Pointer to display memory!
KDATA extern char KFAR *vidmemory;

typedef struct
{
    //----INIT

    int tmi_bInit;              //1 if initialized
    int tmi_bSurfaceInit;       //1 if dest surface initialized!

    //----MAP

    int  tmi_iMapWidth;          //Width of map
    int  tmi_iMapHeight;         //Height of map
    long tmi_iMaxX;              //Maximum you can scroll X-wise!
    long tmi_iMaxY;              //Maximum you can scroll Y-wise!
    char KFAR *tmi_ptrTheMap;   //Pointer to map data!

    //----TILEDATA

    int tmi_iNumTiles;          //Number of bitmaps for tiles
    int tmi_iTileWidth;         //Tile Width
    int tmi_iTileHeight;        //Tile Height
    int tmi_iShiftX;            //Number you can << shift by to simulate muls
    int tmi_iShiftY;            //Number you can << shift by to simulate muls
    char KFAR *tmi_aTiles[TILEINFO_MAXTILES];   //Pointer to tile bitmaps!

    //----Draw surface

    char KFAR *tmi_ptrDrawSurface;  //The Drawing surface.
    int tmi_iBytesPerScanline;  //Bytes per scanline of drawing surface.
    int tmi_iClipX;             //Start of clipping region on drawing surface.
    int tmi_iClipY;             //Start of clipping region on drawing surface.
    int tmi_iClipWidth;         //Width of clipping region
    int tmi_iClipHeight;        //Height of clipping region

    //----Tile Draw

    int tmi_iTileDrawX;         //Maxiumum tiles you see X-ways in the view.
    int tmi_iTileDrawY;         //Maxiumum tiles you see Y-ways in the view.

}TileMapInfo, KFAR *TileMapInfoPtr;

//----------------TILE ENGINE INIT FUNCTIONS-------------------//

//Initilizes a tile engine structure...
//You must free memory for the map yourself! We don't copy the map...
//We copy the pointer to the map.
//Returns 0 on error or 1 on success!
KCALL int  TileEngine_Init(TileMapInfo &cTileEI,   //Tile Engine Info Struct
                     int iMapWidth,          //Map Width
                     int iMapHeight,         //Map Height
                     char KFAR *ptrTheMap,   //Pointer to map data
                     int iNumTiles,          //Number of bitmap tiles
                     int iTileWidth,         //Width of tile
                     int iTileHeight,        //Height of tile
                     char KFAR *aTiles[]);   //Array of (char *) that point to the data for the different tiles!

//Uninitilizes a tile engine structure.
KCALL void TileEngine_UnInit(TileMapInfo &cTileEI);  //Tile Engine Info Struct

//Sets the drawing surface for the tile engine structure.
//Returns 0 on error or 1 on success!
KCALL int TileEngine_SetDrawSurface(TileMapInfo &cTileEI,     //Tile Engine Info Struct
                               char KFAR *ptrDraw,      //Pointer to drawing surface
                               int  iBytesPerScan,      //Number of bytes per scanline
                               int  iViewX,             //Start of view
                               int  iViewY,             //Start of view
                               int  iViewWidth,         //The viewport clip width
                               int  iViewHeight);       //The viewport clip height

//Sets the drawing surface for the tile engine structure.
//Instead of width and height its coords...
//Returns 0 on error or 1 on success!
KCALL int TileEngine_SetDrawSurface2(TileMapInfo &cTileEI,     //Tile Engine Info Struct
                               char KFAR *ptrDraw,      //Pointer to drawing surface
                               int  iBytesPerScan,      //Number of bytes per scanline
                               int  iViewX,             //Start of view
                               int  iViewY,             //Start of view
                               int  iViewX2,            //End of view
                               int  iViewY2);           //End of view


//Clears Drawing surface information!
KCALL void TileEngine_UnSetDrawSurface(TileMapInfo &cTileEI); //Tile Engine Info Struct

//----------------TILE ENGINE DRAW FUNCTIONS-------------------//

//Draws the tiled view on the current drawing surface
//at iDrawX,iDrawY. it does not let iDrawX and iDrawY
//go beyond our limits.
//Returns 0 on error or 1 on success!
KCALL int TileEngine_DrawAtPos(TileMapInfo &cTileEI,      //Tile Engine Info Structure
                         long &iDrawX,long &iDrawY);//Position to draw tiled map.

//-----------------DRAWING FUNCTIONS------------------//

//Draws a bitmap onto another bitmap clipped!
KCALL void DrawBitmapClipped(char KFAR *ptrBitmap,    //Pointer to bitmap
                       int iDrawX,              //X Coord to draw bitmap
                       int iDrawY,              //Y Coord to draw bitmap
                       int iBWidth,             //Width of bitmap
                       int iBHeight,            //Height of bitmap
                       char KFAR *ptrDrawDest,  //Where we draw to
                       int iBytesPerScanline,   //Num of bytes per scanline
                       int iDrawDestClipX,      //Start of clip region
                       int iDrawDestClipY,      //End of clip region
                       int iDrawDestWidth,      //Clip region width
                       int iDrawDestHeight);    //Clip region height

#endif
