#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include "mydefs.h"
#include "gtile.h"

#define UP_ARROW_KEY        72
#define DOWN_ARROW_KEY      80
#define LEFT_ARROW_KEY      75
#define RIGHT_ARROW_KEY     77

#define ESC_KEY             27

TileMapInfo tmInfo;
char KFAR *LoadedTiles[TILEINFO_MAXTILES];
char TestMap[16][16] = {
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,
    1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,
    1,2,2,1,1,1,2,1,1,1,1,1,1,1,1,1,
    1,2,2,1,1,2,2,1,1,1,1,1,1,1,1,1,
    1,2,2,1,2,2,1,1,1,2,2,2,1,2,1,2,
    1,2,2,2,2,1,1,1,1,2,1,2,1,2,1,2,
    1,2,2,2,2,1,1,1,1,2,2,2,1,2,1,2,
    1,2,2,1,2,2,1,1,1,2,1,1,1,2,1,2,
    1,2,2,1,1,2,2,1,1,2,2,2,1,1,2,1,
    1,2,2,1,1,1,2,2,1,1,1,1,1,1,1,1,
    1,2,2,1,1,1,2,2,1,1,2,2,2,2,2,1,
    1,2,2,1,1,1,1,2,1,1,2,1,2,1,2,1,
    1,2,2,1,1,1,1,2,1,1,2,2,1,2,2,1,
    1,2,2,1,1,1,1,2,1,1,2,2,2,2,2,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

//Loads a VGA picture file into memory...
char KFAR *LoadVGAPicture(char *filename)
{
    //Try to open the file
    FILE *fp =fopen(filename,"rb");
    if (fp == NULL) return NULL;    //Error! couldn't open file!
    unsigned short width;
    unsigned short height;
    //Read width and height
    fread(&width,2,1,fp);
    fread(&height,2,1,fp);
    //Width and height are stored one less then they really are....
    width++;
    height++;
    //Try to allocate some memory
    unsigned int tmem=(unsigned int)(width * height);
    char KFAR *newmem = (char KFAR *)KALLOC((unsigned int)(tmem+1));
    //Enough memory?
    if (newmem==NULL)
    {
        //Nope!
        fclose(fp);
        return NULL;
    }
    //Read in data!
    for (long i=0; i<tmem; i++)
    {
        newmem[i]=(char)(getc(fp));
    }
    //Close the file
    fclose(fp);
    return newmem;
}

//Loads the graphics for the demo
void LoadGraphics()
{
    LoadedTiles[0] = NULL;
    LoadedTiles[1] = LoadVGAPicture("tile0001.vga");
    LoadedTiles[2] = LoadVGAPicture("tile0002.vga");
    if (LoadedTiles[1] == NULL ||
        LoadedTiles[2] == NULL)
    {
        printf("Error loading graphics!\n");
        exit(1);
    }
}

void UnLoadGraphics()
{
    KFREE(LoadedTiles[1]);
    KFREE(LoadedTiles[2]);
}

void DoDemo()
{
    int iWeQuit=0;
    long iX=0;
    long iY=0;
    //While we don't quit do:
    while (0 == iWeQuit)
    {
        //Is there a key pending?
        if (kbhit())
        {
            //Get the key.
            int key=getch();
            //Is it an extended key?
            //If it is then process?
            if (key==0)
            {
                //Extended key!
                key=getch();
                switch(key)
                {
                    case UP_ARROW_KEY:
                        iY-=3;                        
                        break;
                    case DOWN_ARROW_KEY:
                        iY+=3;
                        break;
                    case LEFT_ARROW_KEY:
                        iX-=4;                        
                        break;
                    case RIGHT_ARROW_KEY:
                        iX+=4;
                        break;
                    default:
                        break;
                }
            }
            else
            {
                //Not extended key!
                switch(key)
                {
                    case 'q':
                    case 'Q':
                    case ESC_KEY:
                        iWeQuit=1;
                        break;
                    default:
                        break;
                }                
            }
        } //kbhit...
        TileEngine_DrawAtPos(tmInfo,iX,iY);
    }
}

#ifdef __WATCOMC__
void SetVideoMode(unsigned short vMode);
#pragma aux SetVideoMode=\
    "int 10h"\
    parm [ax];
#else
void SetVideoMode(unsigned short vMode)
{
    KASM{
    mov ax,vMode
    int 10h
    }
}
#endif

void SetPaletteRegister(int index,int r,int g,int b)
{
    outp(0x3C8,index);
    outp(0x3C9,r);
    outp(0x3C9,g);
    outp(0x3C9,b);
}

int LoadPalette(char *filename)
{
    char r,g,b;
    FILE *fp=fopen(filename,"rb");
    if (fp==NULL) return 0;
    for (int i=0; i<256; i++)
    {
        r=(char)getc(fp);
        g=(char)getc(fp);
        b=(char)getc(fp);
        SetPaletteRegister(i,r,g,b);
    }
    fclose(fp);
    return 1;
}

void main()
{
    //Load the graphics...
    printf("GTILE demo made by Kevin Hoffman!\n\n");
    printf("Loading graphics...\n\n");
    LoadGraphics();
    printf("Keys:\n");
    printf("  Use the arrow keys to move around. Q to quit!\n");
    printf("Press a key to continue...\n");
    getch();

    TileEngine_Init(tmInfo,16,16,(char KFAR *)(TestMap),3,32,32,LoadedTiles);
    TileEngine_SetDrawSurface2(tmInfo,vidmemory,320,32,32,292,162);
    //TileEngine_SetDrawSurface(tmInfo,vidmemory,320,0,0,319,199);
    //Do the demo
    SetVideoMode(0x13);
    if (!LoadPalette("gtile.pal"))
    {
        SetVideoMode(0x03);
        printf("Error loading palette!\n");
        UnLoadGraphics();
        return;
    }
    DoDemo();
    SetVideoMode(0x03);
    TileEngine_UnSetDrawSurface(tmInfo);
    TileEngine_UnInit(tmInfo);
    UnLoadGraphics();
}
