; **************************************************************************
; *                      Procedure :  Get Integer                          *
; **************************************************************************
; *                                                                        *
; * Author  : Assembly Book Page 168                                       *
; * Purpose : get an integer from the keyboard                             *
; * input   : none.                                                        *
; * output  : AX contains binary integer   CF set on Error                 *
; *                                                                        *
; **************************************************************************

TITLE   GET_INT
.MODEL  SMALL
.DATA

        .CODE
        EXTRN   WRITELN:PROC
        EXTRN   BININT:PROC
        
        PUBLIC  GET_INT
GET_INT PROC
        PUSH    BX                      ; Save effected registers
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSH    DS                      ; Save DS

        PUSH    SS                      ; Push the Stack Segment
        POP     DS                      ; to place it in the Data Segment
        SUB     SP,18                   ; Make Space for a Keyboard Buffer
        MOV     BX,SP                   ; DS:BX points to buffer
        MOV     BYTE PTR [BX],16        ; buffer length is 16
        MOV     AH,0AH                  ; select buffered keyboard input
        MOV     DX,BX                   ; DS:DX points to buffer
        INT     21H                     
        CALL    WRITELN                 ; Advance cursor to next line

        SUB     CX,CX                   ; Clear the CX register
        MOV     CL,[BX]+1               ; Length is at buffer start plus one
        LEA     SI,[BX]+2               ; string's offset is at buffer plus 2
        CALL    BININT                  ; convert to Binary
        JNC     GETINT1                 ; Branch if no Carry
        ADD     SP,18                   ; restore SP and
        STC                             ; set carry
        JMP     SHORT GETINT2

GETINT1:ADD     SP,18                   ; restore SP and
        CLC                             ; Clear the Carry Flag
GETINT2:POP     DS
        POP     SI
        POP     DX
        POP     CX
        POP     BX
        RET
GET_INT ENDP
        END

INCLUDE WRITELN.ASM 
INCLUDE BININT.ASM

