;Program : Lander v1.0
;Author  : Scott Glass     TakeFlight@aol.com
;Purpose : To learn and explain simple Assembly Language programming.

TITLE   LANDER.EXE
DOSSEG
.MODEL  SMALL

.STACK  100H

                .DATA
PROGTITLE       DB      "Scott's virtual Carrier Lander",13,10
PROGINFO1       DB      "The source code and executables generated are for learning$"
PROGINFO2       DB      "purposes only. There is no charge for the use of this code,$"
PROGINFO3       DB      "please read the READTHIS.NFO file before doing any modifcations.$"
SHOW_CLIMB      DB      "Climb    :$"
LABEL_CLIMB     DB      "Feet/Sec $"
SHOW_AIRSPEED   DB      "Airspeed :$"
LABEL_AIRSPEED  DB      "N M P H $"
SHOW_ALTITUDE   DB      "Altitude :$"
LABEL_ALTITUDE  DB      "Feet $"
SHOW_THROTTLE   DB      "Throttle :$"
LABEL_THROTTLE  DB      "Percent $"
SHOW_PITCH      DB      "Pitch    :$"
LABEL_PITCH     DB      "Degrees $"
SHOW_FUEL       DB      "Fuel     :$"
LABEL_FUEL      DB      "Lbs. $"
SHOW_DISTANCE   DB      "Distance :$"
LABEL_DISTANCE  DB      "NM$"
VERT_LINE       DW      179d
HORZ_LINE       DW      196d
FLIGHT_CLIMB    DW      0D
FLIGHT_AIRSPEED DW      500D
FLIGHT_ALTITUDE DW      500D
FLIGHT_THROTTLE DW      100D
FLIGHT_PITCH    DW      0D
FLIGHT_FUEL     DW      2000D
FLIGHT_DISTANCE DW      50D
JET             DW      146d
WELCOME         DB      "Welcome Home Captain.",13,10
WELCOME2        DB      32,"You are Currently Crusing at 500 NMPH, 50 miles from Atlantis.$"
WEATHER         DB      "Visibility is clear, wind shear is at 0 MPH.",13,10
EASYGOING       DB      32,"Should be smooth sailing right onto wire 4.$"
ASK_THROTTLE    DB      "Please enter new Throttle setting (0 - 100) : $"
ASK_PITCH       DB      "Please enter new Angle of Attack (-90 - 90) : $"
ASK_VALID       DB      13,10," Are you sure this is the value you wanted (Y/N)? : $"
OUTTARANGE      DB      "You've Over Shot the Carrier!!$"
CRASHED         DB      "Fires are immediately quenched by the salt water, You've crashed!$"
CONGRATS        DB      "Congradulations! You've landed...$"
TRYMESSAGE      DB      13,10,32,"Try again (Y/N)? : $"
JET_ROW         DB      4d
JET_COLUMN      DB      75d
CLEAR_VALUE     DB      "     $"




                .CODE
                EXTRN  Pause:PROC
                EXTRN  FScreen:PROC
                EXTRN  Put_Int:PROC
                EXTRN  Get_Int:PROC

main:           call   CLRSCR                   ; Call Clear Screen Module

                mov     dh, 1                   ; move to row 1
                mov     dl, 25                  ; move to column 25
                call    MOVCURS

                mov     ax,@DATA                ; Load segment location into
                mov     ds,ax                   ; DS register

                mov     bx,1                    ; Load 1 - file handle for
                                                ; standard output
                mov     cx,31                   ; Load length of title
                mov     dx,OFFSET PROGTITLE     ; Load address of title
                mov     ah,40H                  ; Load number for DOS write function
                int     21h                     ; Call DOS

                mov     dh, 10                  ; move to row 10
                mov     dl, 10                  ; move to column 10
                call    MOVCURS

                mov     dx,OFFSET PROGINFO1     ; Load Offset for Proram Info String
                mov     ah,9H                   ; DOS Write String Function
                int     21h

                mov     dh,11                   ; Goto the 11th Row of the Display
                mov     dl,10                   ; Goto the 10th Column
                call    MOVCURS

; NOTE: You might be wondering why I set DH and DL seperately, for some reason setting DX as
;       a whole seems to give erratic results. I feel it's also easier to read by splitting
;       DX up into DH and DL.

                mov     dx,OFFSET PROGINFO2     ; Load the Offset for the second PI string.
                mov     ah,9h                   ; NOTE: To tell Vector 9H that the string ends
                                                ;       it's necessary to place a $ at the
                                                ;       end of the string. See the Data
                                                ;       Segment Above.
                int    21h                      ; 21H does the declared function. ex. 9h

                mov     dh, 12
                mov     dl, 10                  ; Move to Row 12, Column 10
                call    MOVCURS                 ; Check out MOVCURS.ASM to see what's happening

                mov     dx,OFFSET PROGINFO3     ; Load the Offset for the third PI string.
                mov     ah,9h                   ; The Display String Function
                int     21h                     ; Do the declared function in AH

                mov     bx,10d                  ; 10 second pause note the "d"ecimal
                call    pause                   ; Subroutine to Pause Display

                mov     bx,1                    ; Future use of the write screen Function
                call    clrscr                  ; Clear Screen

; **************************************************************************
; *                             Main Program                               *
; **************************************************************************

                mov     dh,0                    ; Move to row 1
                mov     dl,25                   ; Column 25
                call    movcurs                 ; Call MovCurs Routine

                mov     cx,31
                mov     dx,OFFSET PROGTITLE
                mov     ah,40h
                int     21h

                mov     dh,1
                mov     dl,25
                call    movcurs

                mov     cx,30

Underline:      push    CX                     ; Save current value in CX
                mov     bx, 1                  ; DOS Write String Setup
                mov     cx, 1                  ; the HORIZ_LINE string is 1 character long
                mov     dx,OFFSET HORZ_LINE    ; Move the Offset of the _ character to DX
                mov     ah,40h                 ; 40H is another Write String Function see note.
                int     21h
                pop     cx                     ; Retrieve the current value of CX
                loop    underline              ; Repeat until CX = 0

; NOTE:  Before I used AH = 9H as the write string function, normally this is the function I prefer
;        but for the case of the underline it didn't work. Try to figure out why..
;        HINT: Take note of how it's declared in the Code Segment.


; ALSO:  Below is a whole mess of write string functions, all self explanatory.

                mov     dh,4                    ; Move to row 2
                mov     dl,5                    ; Move to Column 5
                call    movcurs                 ; Call Move Cursor function

                mov     dx,OFFSET SHOW_ALTITUDE ; Offset of Altitude
                mov     ah,9h                   ; Write String Function
                int     21h

                mov     dh,6                    ; Row 4
                mov     dl,5                    ; column 5
                call    movcurs                 ; Call Move Cursor

                mov     dx,OFFSET SHOW_AIRSPEED ; Offset of Airspeed
                mov     ah,9h                   ; DOS Write String Function
                int     21h

                mov     dh,8                    ; Row 8
                mov     dl,5                    ; Column 5
                call    movcurs

                mov     dx,OFFSET SHOW_PITCH  
                mov     ah,9h
                int     21h

                mov     dh,10
                mov     dl,5
                call    movcurs

                mov     dx,OFFSET SHOW_CLIMB
                mov     ah,9h
                int     21h

                mov     dh,12
                mov     dl,5
                call    movcurs

                mov     dx,OFFSET SHOW_THROTTLE ; "Throttle :"
                mov     ah,9h
                int     21h

                mov     dh,14
                mov     dl,5
                call    movcurs

                mov     dx,OFFSET SHOW_DISTANCE
                mov     ah,9h
                int     21h

                mov     dh,16
                mov     dl,5
                call    movcurs

                mov     dx,OFFSET SHOW_FUEL     ; Offset of Fuel
                mov     ah,9h
                int     21h

                mov     dh,20                   ; Row 20
                mov     dl,0                    ; Column 0
                call    movcurs

; Here is where the status line is generated at the bottom of the game string.
; Remember CX is the count register.

                mov     cx,80                   ; Since we are dealing with
                                                ; a 40X80 Display, we need
                                                ; to have 80 characters
                                                ; to create the line

StatLine:       Push    cx                      ; Save the Loop Count
                mov     bx,1                    ; Needed for the 40H interrupt vector.
                mov     cx,1                    ; Printing one character
                mov     dx,OFFSET HORZ_LINE     ; Offset of horizontal
                                                ; character
                mov     ah,40h                  ; DOS Print String Function
                int     21h
                pop     cx                      ; Restore Loop Count
                Loop    StatLine                ; Loop

                call    Fscreen                 ; In the name of modularity
                                                ; I decided to keep the 
                                                ; flight screen seperate
                                                ; I've got a few ideas for it
                                                ; that I couldn't incorporate
                                                ; by the time this was due for class.

; **************************************************************************
; *                          Show Initial Flight Values                    *
; **************************************************************************

; Here is where the program spits out the current flight values.

                mov     dh,4                                    ; Move to row 2
                mov     dl,18                                   ; Move to Column 18
                call    movcurs                                 ; call Move Cursor function

                mov     ax,FLIGHT_ALTITUDE                      ; Offset of altitude
                call    put_int                                 ; Here is a module that was
                                                                ; extremely handy to have around
                                                                ; especially dealing with positive
                                                                ; and negative values.

                mov     dh,6                                    ; Row 4
                mov     dl,18                                   ; column 5
                call    movcurs                                 ; call Move Cursor

                mov     ax,FLIGHT_AIRSPEED                      ; Offset to Airspeed
                call    put_int

                mov     dh,8                                    ; Move to Row 8
                mov     dl,18                                   ; Move Column 18
                call    movcurs

                mov     ax,FLIGHT_PITCH                         ; Offset to Pitch
                call    put_int

                mov     dh,10
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_CLIMB
                call    put_int


                mov     dh,12
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_THROTTLE
                call    put_int

                mov     dh,14
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_DISTANCE
                call    put_int

                mov     dh,16
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_FUEL           ; Offset of Fuel
                call    put_int


; **************************************************************************
; *                    Give our values some meaning                        *
; **************************************************************************

; This segment places the values after the Flight Values

                mov     dh,4                     ; Move to row 4
                mov     dl,25                    ; Move to Column 10
                call    movcurs                  ; Call Move Cursor function

                mov     dx,OFFSET LABEL_ALTITUDE ; Offset of Altitude
                mov     ah,9h                    ; Write String Function
                int     21h

                mov     dh,6                     ; Row 6
                mov     dl,25                    ; column 10
                call    movcurs                  ; Call Move Cursor

                mov     dx,OFFSET LABEL_AIRSPEED ; Offset of Airspeed
                mov     ah,9h                    ; DOS Write String Function
                int     21h

                mov     dh,8                     ; Row 8
                mov     dl,25                    ; Column 10
                call    movcurs

                mov     dx,OFFSET LABEL_PITCH    ; "Degrees"
                mov     ah,9h
                int     21h

                mov     dh,10
                mov     dl,25
                call    movcurs

                mov     dx,OFFSET LABEL_CLIMB
                mov     ah,9h
                int     21h

                mov     dh,12
                mov     dl,25
                call    movcurs

                mov     dx,OFFSET LABEL_THROTTLE ; "Percent"
                mov     ah,9h
                int     21h

                mov     dh,14
                mov     dl,25
                call    movcurs

                mov     dx,OFFSET LABEL_DISTANCE
                mov     ah,9h
                int     21h

                mov     dh,16
                mov     dl,25
                call    movcurs

                mov     dx,OFFSET LABEL_FUEL     ; Offset of Fuel
                mov     ah,9h
                int     21h

; Here is where I had the compuer place the little JET symbol, JET_ROW and JET_COLUMN
; are simple integer values that reflect screen coordinates. It's 40 rows, by 80 columns.
                
                mov     dh,JET_ROW              ; Move to coordinates of Jet
                mov     dl,JET_COLUMN           ; and place one there
                call    movcurs

                mov     bx,1                    ; Setup for DOS write string Function
                mov     cx,1                    ; Write 1 character
                mov     dx,offset Jet           ; ASCII value of the Jet
                mov     ah,40h                  ; DOS Write String Vector
                int     21h

; **************************************************************************
; *                   Welcome to the game screen                           *
; **************************************************************************

; Here is where the code draws the inital Welcome Messages

                mov     dh,21
                mov     dl,1
                call    movcurs

                mov     bx,1
                mov     cx,23
                mov     DX,OFFSET Welcome
                mov     ah,40h
                int     21h

                mov     DX,OFFSET Welcome2
                mov     ah,9h
                int     21h

                mov     bl,3d                   ; 3 second pause in BL, "d" tells the
                                                ; assembler it's a decimal value.
                                                ; I could also represent this as a "H"ex value
                                                ; "B"inary value or a "O"ctal value
                call    pause                   ; Allow user to read message

                call    clear_message           ; Clear Message Box

                mov     bx,1                    ; DOS Write String Function
                mov     cx,46                   ; String is 46 characters long
                mov     DX,OFFSET Weather       ; "Weather is beautiful" or 
                mov     ah,40h                  ; something like that
                int     21h

                mov     DX,OFFSET EASYGOING     ; Take it easy dude
                mov     ah,9h                   ; don't crash message
                int     21h

                mov     bl,3d                   ; 3 second pause in bl
                call    pause

; **************************************************************************
; *                Start Asking for Flight Values                          *
; **************************************************************************

GetThrottle:    call    clear_message           ;Clear the Message Display area

                mov     dx,OFFSET ASK_THROTTLE  ;Offset of Get Throttle in DX
                mov     ah,9h
                int     21h

                call    get_int

;  Here is where I get the user input values, hopefully you know a little Assembler
;  syntax, "cmp" means compare,
;          "jl"     Jump if less than,
;          "jg"     Jump if Greater Than,
;          "jle"    Jump if less than or Equal to,
;          and so on.. Think Logic.

                cmp     ax,0                    ; Check the minimum range of GetThrottle
                jl      getthrottle

                cmp     ax,100                  ; Check the maximum range of get_throttle
                jg      getthrottle

                mov     Flight_Throttle,AX      ; Update Throttle setting with new value


 GETPITCH:      call    clear_message           ; Clear input area get ready to ask for Pitch Value

                mov     dx,OFFSET ASK_PITCH     ; Ask User what new pitch he'd like
                mov     ah,9h                   ; DOS write String Function
                int     21h

                call    get_int                 ; Get the Pitch Value

                cmp     ax,-90d                 ; Check the low range of range
                jl      GetPitch

                cmp     ax,90                   ; check the high range of range
                jg      Getpitch
 
                mov     Flight_Pitch,AX         ; Save Pitch Value

                call    updatevals              ; Update the values on the screen

; **************************************************************************
; *                           Check for crash                              *
; **************************************************************************

                call    Clear_Message           ; Clear the message area prepare for results

                cmp     Flight_Fuel,0           ; Check to see if ran outta fuel
                jle     Crash

                cmp     Flight_Altitude,0       ; Check to see if altitude has hit bottom
                jle     Crash

                cmp     Jet_Row,4               ; Check to see if overflown flight path
                jl      Outta_range

                cmp     Jet_Column,36           ; Check to see if jet has overflown carrier
                jl      Check_Landing
                jmp     GetThrottle

Crash:          mov     dx,OFFSET CRASHED       ; Print You crashed message
                mov     ah,9h
                int     21h
                jmp     TryAgain

Check_Landing:  cmp     Flight_Altitude,100     ; Check to see if you made carrer
                jle     Good_Landing
                jmp     Outta_Range

Outta_Range:    Call    Clear_Message
                mov     dx,OFFSET OUTTARANGE    ; Print Outta Range message
                mov     ah,9h
                int     21h
                jmp     TryAgain

Good_Landing:   mov     dx,offset Congrats      ; Print Congradulations message
                mov     ah,40h
                int     21h
                jmp     TryAgain
 
TryAgain:       mov     dx,OFFSET TRYMESSAGE
                mov     ah,9h
                int     21h
                mov     ah,1                    ; DOS get key function
                int     21h
                cmp     al,'N'                  ; Check for Yes
                je      EndOfGame
                cmp     al,'n'
                je      EndOfGame
                call    resetvals
                jmp     Main

EndOfGame:      mov     ax,4C00H                ; Load DOS exit Function
                int     21h                     ; Call DOS

; **************************************************************************
; *         Procedure :  Clear Message Area on the Flight Screen           *
; **************************************************************************

CLEAR_MESSAGE   PROC
                mov     ch,21                   ; ROW 21
                mov     cl,0                    ; Column 0 for the top left corner
                mov     dh,25                   ; Row 25
                mov     dl,80                   ; Column 80 for the bottom right corner
                mov     bh,00000111b            ; Continue with same Attribute.
                call    clear_box

                mov     dh,21                   ; Row 21, Column 1 is a good place
                mov     dl,1                    ; to start the text
                call    movcurs

                ret
CLEAR_MESSAGE   ENDP

; **************************************************************************
; *                      Procedure :  Clear Display                        *
; **************************************************************************
; *                                                                        *
; * Author  : Macro Assember Programming Page 94                           *
; * Purpose : clear video Display                                          *
; * input   : none                                                         *
; * output  : none Registers DI and SI may possibly be altered.            *
; *                                                                        *
; **************************************************************************


CLRSCR PROC
                push    ax                      ; save AX register
                push    bp                      ; save BP register
                mov     AH, 0FH                 ; select read video state fctn
                int     10h                     ; interrupt 10H - get video mode in AL
                mov     AH,0                    ; select set mode function
                int     10h                     ; set mode in AL
                pop     bp                      ; restore BP
                pop     ax                      ; restore AX
                RET
CLRSCR  ENDP
 

; **************************************************************************
; *                      Procedure :  Clear box                            *
; **************************************************************************
; *                                                                        *
; * Author  : Macro Assember Programming Page 100                          *
; * Purpose : clear a rectangular box                                      *
; * input   : CH,CL upper left corner DH,DL contain lower right corner     *
; * output  : none. Registers DI, BP and  SI may possibly be altered.      *
; *                                                                        *
; **************************************************************************

CLEAR_BOX       PROC
                MOV     AL,0                    ; Clear Entire Window
                MOV     AH,7                    ; Function 7 Scrolls Down
                INT     10H                     ; BIOS  call
                RET
CLEAR_BOX       ENDP

; **************************************************************************
; *                      Procedure :  Move Cursor                          *
; **************************************************************************
; *                                                                        *
; * Author  : Macro Assember Programming Page 100                          *
; * Purpose : moves the cursor to input row and column coordinates         *
; * input   : DH is new row, DL is new column                              *
; * output  : BH is active page. BP, SI, and DI may be changed.            *
; *                                                                        *
; **************************************************************************
 
MOVCURS PROC
        push    ax                      ; save critical registers
        mov     ah, 0Fh                 ; function F to get page
        int     10h
        mov     ah, 2                   ; function 2 to move cursor
        int     10h
        pop     ax
        ret
MOVCURS ENDP

; **************************************************************************
; *                Procedure :  Update Values                              *
; **************************************************************************

UPDATEVALS      PROC    NEAR

             
                mov     bx,16                                   ; Place cursor at the bottom of the value row.

ClearVCol:      push    bx                                      ; This loop is used to clear the old
                                                                ; values from the flight data column.
                mov     dh,bl                                   ; move to row determined by bl
                mov     dl,18                                   ; Always Column 18.. Go figure.
                call    movcurs
                mov     dx,OFFSET CLEAR_VALUE                   ; Prepare to wipe out old values
                mov     ah,9h                                   ; DOS write string function
                int     21h
                pop     bx                                      ; restore row number to test for Top of Column
                cmp     bx,4                                    ; Test to see if we are at the top of the column
                je      UpDateData                              ; Update the Data
                dec     bx
                jmp     ClearVCol                               ; Repeat procedure until bx equals 4

UpDateData:     cmp     Flight_Throttle,75d                     ; Compare Throttle to 75%
                jge     Throttle_High                           ; Plane Accelerates 10%
                cmp     Flight_Throttle,60d                     ; Compare Throttle to 60%
                jge     New_Distance                            ; Plane remains at current speed
                cmp     Flight_Throttle,30d                     ; Compare Throttle to 30%
                jge     Throttle_Low                            ; Plane decelerates 10%
                jmp     Throttle_cut                            ; Plane Looses 30% speed

Throttle_High:  mov     AX,Flight_AirSpeed                      ; Move the Airspeed into AX
                mov     bl,10d
                div     bl                                      ; Multiply it by 10%
                mov     ah,0                                    ; Kill the Remainder
                add     Flight_AirSpeed,AX                      ; Add the new speed
                mov     BX,200d                                 ; Move 200 into BX
                sbb     Flight_Fuel,BX                          ; In order to burn fuel
                jmp     New_Distance                            ; Calculate Distance from Carrier

Throttle_Low:   mov     AX,Flight_AirSpeed                      ; Move the Airspeed into AX
                mov     bl,10d                                  ; Divide by 10 again
                div     bl
                mov     ah,0                                    ; Kill the Remainder
                sbb     Flight_Airspeed,Ax                      ; Remove some speed
                mov     bx,100d                                 ; Move 100 into bx
                sbb     Flight_Fuel,BX                          ; in order to burn less fuel
                jmp     New_Distance

Throttle_Cut:   mov     AX,Flight_AirSpeed                      ; Airspeed into AX
                mov     bl,30d                                  ; We cut Airspeed by 30%
                div     bl
                mov     ah,0
                sbb     Flight_Airspeed,AX

New_Distance:   mov     AX,Flight_Airspeed                      ; Place the Airspeed into AX
                mov     bl,60d                                  ; to caculate Miles per Minute
                div     bl
                mov     ah,0                                    ; Kill the Remainder
                sbb     Flight_Distance,AX

New_Climb:      cmp     Flight_Pitch,0                          ; Check if plane is "Nose Up"
                jg      Climb_Flight                            ; Yes. It's Climbing
                cmp     Flight_Pitch,0                          ; Check if Plane is level
                je      Level_Flight                            ; Yes. It's level flight
                cmp     Flight_Pitch,0                          ; Check is plane is "Nose Down"
                jl      Dec_Flight                              ; She's going down captain!!

Climb_Flight:   cmp     Flight_Pitch,45d                        ; Check for Rate of Climb
                jge     Major_AltG
                cmp     Flight_Pitch,10d                        ; Little Altitude gain
                jge     Minor_AltG
                add     Flight_Climb,5                          ; She's going up 5 feet per sec

Major_AltG:     add     Flight_Climb,30d                        ; Major Altitude gain
                jmp     New_Altitude

Minor_AltG:     add     Flight_Climb,10d
                jmp     New_Altitude

Level_Flight:   mov     Flight_Climb,0                          ; There's no change in Altitude
                jmp     New_Altitude

Dec_Flight:     neg     Flight_Pitch
                cmp     Flight_Pitch,45d                        ; Check for Rate of Climb
                jge     Major_AltD                              ; Major Altitude gain
                cmp     Flight_Pitch,10d                        ; Little Altitude gain
                jge     Minor_AltD
                sbb     Flight_Climb,5                          ; She's going up 5 feet per sec
              
Major_AltD:     sbb     Flight_Climb,30d                        ; Major Altitude gain
                jmp     New_Altitude

Minor_AltD:     sbb     Flight_Climb,10d

New_Altitude:   mov     AX,Flight_Altitude
                push    ax
                mov     BX,Flight_Climb
                add     BX,AX
                mov     Flight_Altitude,BX

Jet_Location:   mov     dh,Jet_Row                              ; move to Location of plane
                mov     dl,Jet_Column
                call    movcurs
                mov     dl,0                                    ; replace jet symbol with nothing
                mov     ah,2h
                int     21h

                cmp     Flight_AirSpeed,500d                    ; Test the Airspeed
                jge     Three_Space                             ; Very Fast
                cmp     Flight_AirSpeed,350d                    ; Moderate
                jge     Two_Space                               ; Moderately Fast
                sub     Jet_Column,1
                jmp     JetRLocation

Three_Space:    sub     Jet_Column,3                            ; 3 Spaces closer to the carrier
                jmp     JetRLocation

Two_Space:      sub     Jet_Column,2                            ; 2 Spaces closer to the carrier

JetRLocation:   pop     ax                                      ; Restore the original altitude in ax
                mov     bx,Flight_Altitude                      ; put the new alitiude in bx
                sbb     ax,bx                                   ; check the difference
                cmp     ax,41                                   ; check for 176ft alt difference
                jge     change_pos                              ; Change the posiiton
                jmp     placejet

change_Pos:     add     Jet_Row,1                               ; Add one onto the row.

placejet:       mov     dh,jet_Row
                mov     dl,Jet_column
                call    movcurs

                mov     dl,146                                  ; ASCII decimal for Jet
                mov     ah,2h
                int     21h

DisplayVals:    mov     dh,4                                    ; Move to row 2
                mov     dl,18                                   ; Move to Column 5
                call    movcurs                                 ; call Move Cursor function
 
                mov     ax,FLIGHT_ALTITUDE                      ; Offset of dxtitude
                call    put_int

                mov     dh,6                                    ; Row 4
                mov     dl,18                                   ; column 5
                call    movcurs                                 ; call Move Cursor

                mov     ax,FLIGHT_AIRSPEED
                call    put_int

                mov     dh,8
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_PITCH
                call    put_int

                mov     dh,10
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_CLIMB
                call    put_int


                mov     dh,12
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_THROTTLE
                call    put_int

                mov     dh,14
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_DISTANCE
                call    put_int

                mov     dh,16
                mov     dl,18
                call    movcurs

                mov     ax,FLIGHT_FUEL           ; Offset of Fuel
                call    put_int

                ret
UpDateVals      ENDP

; **************************************************************************
; *                      Procedure :  Reset Values                         *
; **************************************************************************

ResetVals       Proc
                mov     Flight_Altitude,500
                mov     Flight_Airspeed,500
                mov     Flight_Pitch,0
                mov     Flight_Climb,0
                Mov     Flight_Throttle,100
                mov     Flight_Distance,50
                mov     Flight_Fuel,2000
                mov     Jet_row,4
                mov     jet_column,75
ResetVals       ENDP
                END     main



INCLUDE         PAUSE.ASM                       ; Pause PRocedure
INCLUDE         FSCREEN.ASM                     ; Flight Screen
INCLUDE         PUT_INT.ASM                     ; Put Integer
INCLUDE         GET_INT.ASM                     ; Get Integer
