/*
 * rnd.h
 */

/*
 * Exported features:
 *   rnd_t
 *     Data type.  No user accessible features.
 *   uint rnd(void)
 *     Returns a random bit pattern with the MSB cleared.
 *   void rnd_init(rnd_t *state, int seed)
 *     Initalizes state to be a random seed value.  It does NOT modify which
 *     rnd_t rnd() will use.
 *   void rnd_use(rnd_t *state)
 *     Sets the rnd_t that rnd() will use.  State must have been set up by
 *     rnd_init(state, seed).  Passing NULL to rnd_use() will disable the
 *     random number generator, but "lock down" the state currently in use.
 *     If you want to copy a state, you have to lock it down first to
 *     guarantee you get all information necessary.
 */


#ifndef  _RND_H_
#define  _RND_H_

typedef unsigned int  uint;

#define  RND_DATASIZE  31
#define  RND_INDENT    3
typedef struct  {
	uint  indent;
	uint  data[RND_DATASIZE];
} rnd_t;


extern uint  rnd(void);
extern void  rnd_init(rnd_t *state, int seed);
extern void  rnd_use(rnd_t *state);

#endif
