/* Calc the CRC of an GB-program                     (C) Jens Ch. Restemeier */
/* Header checksum does not work ! */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char page[0x4000];
unsigned short int crc,oldcrc;
unsigned char comp,oldcomp;
char pagenum,smartcard;

#ifdef UNIX
#define stricmp strcasecmp 
#define strnicmp strncasecmp
#endif

int calc_crc(char *infile)
{
  FILE *data;

  if ((data=fopen(infile,"rb"))!=NULL)
  {
    int c,b;
    size_t blksize;
    long size;
    /* check for smart card */
    fread(&page,1,2,data);
    fseek(data,0,SEEK_END);
    size=ftell(data);
    if (((size-512)>>13)==((((long)page[0])|((long)page[1]<<8))))
    {
      smartcard=1;
      fseek(data,512,SEEK_SET);
    } else {
      smartcard=0;
      fseek(data,0,SEEK_SET);
    }
    /* read first page */
    blksize=fread(&page,1,sizeof(page),data);
    oldcrc=(page[0x14e]<<8) | page[0x14f];
    oldcomp=page[0x14e];
    page[0x14e]=0;page[0x14f]=0;
    pagenum=2 << page [0x148];
    comp=0;
    for (c=0x100;c<0x14d;c++) comp+=page[c];
/*  page[0x14e]=comp;*/
    crc=0;
    for (c=0;c<blksize;c++) crc+=page[c];
    /* read the rest */
    for (b=1;b<pagenum;b++)
    {
      blksize=fread(&page,1,sizeof(page),data);
      for (c=0;c<blksize;c++) crc+=page[c];
    }
    fclose(data);
  } else {
    printf("Error opening %s\n",infile);
    return 0;
  }
  return 1;
}

int add_crc(char *infile,char *outfile)
{
  FILE *datain,*dataout;

  if ((datain=fopen(infile,"rb"))!=NULL)
  {
    if ((dataout=fopen(outfile,"wb"))!=NULL)
    {
      int c,b;
      size_t blksize;
      /* skip smartcard header*/
      if (smartcard) fseek(datain,512,SEEK_SET);
      /* read first page */
      blksize=fread(&page,1,sizeof(page),datain);
      for (c=blksize;c<sizeof(page);c++) page[c]=0;
      page[0x14e]=crc >> 8;
      page[0x14f]=crc & 0xFF;
      fwrite(&page,1,sizeof(page),dataout);
      /* read the rest */
      for (b=1;b<pagenum;b++)
      {
	blksize=fread(&page,1,sizeof(page),datain);
	for (c=blksize;c<sizeof(page);c++) page[c]=0;
	fwrite(&page,1,sizeof(page),dataout);
      }
      fclose(datain);
    } else {
      printf("Error opening %s\n",outfile);
      return 0;
    }
  } else {
    printf("Error opening %s\n",infile);
    return 0;
  }
  return 1;
}

int main(int argc,char *argv[])
{
  if (argc<2)
  {
    printf("calc_crc <infile> [<outfile>]\n");
  } else {
    if (calc_crc(argv[1]))
    {
      printf("new CRC:%.4X Complement:%.2X\nold CRC:%.4X Complement:%.2X\n",crc,comp,oldcrc,oldcomp);
      if (argc>2)
	if (stricmp(argv[1],argv[2])!=0)
	{
	  if (add_crc(argv[1],argv[2]))
	    printf("CRC patched !\n",argv[2]);
	} else printf("Files MUST be different !\n");
    }
  }
  return(0);
}
