/* Convert a gif-picture into GB-data */

/* gif decoder by Jens Ch. Restemeier. Maybe foreign users have problems */
/* with this, because the compression-algorithm is patented by somebody. */
/* I have no problems, because here in germany a published algorithm     */
/* becomes a "good of public education"  and I can use it for free.      */

/* This code looks awful, because I converted it from a very old TP6.0   */
/* code.                                                                 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef UNIX
#define strnicmp strncasecmp
#endif

#define MAXPATH 256

char *gifname,picname[MAXPATH],mapname[MAXPATH],fontname[MAXPATH];

unsigned char *gifstuff;

typedef struct _SCR {
  unsigned int width,height,resolution,bpp,gcm,background;
} SCR;

typedef struct _IMG {
  unsigned int posx,posy,width,height,icm,interlace,pixel;
} IMG;

SCR scr;
IMG img;

FILE *giffile;

unsigned long int clearcode,eofcode,maxcode,firstfree,freecode,
		  gifptr,rasterptr,xc,yc,pindex,readmask,codesize;
unsigned char initcodesize,finchar,pass,bitmask;
unsigned int prefix[4096];
unsigned char suffix[4096];
unsigned char outcode[1025];

/* GB-stuff */
unsigned char *gbscreen,*gbfont,*gbmap;
int gbwidth,gbheight,gbfontsize,gbmapsize;
unsigned int gbsize;

/* gif decoder */

void put_pixel(int x,int y,unsigned char c)
{
  /* Filter out color<4 & invisible stuff ! */
  if ((c<4)&&(x<gbwidth)&&(y<gbheight))
  {
    if (c&1) *(gbscreen+(y<<1)+((x>>3)*(gbheight<<1)))|=0x80>>(x&7);
    if (c&2) *(gbscreen+(y<<1)+((x>>3)*(gbheight<<1))+1)|=0x80>>(x&7);
  }
}

void draw_data (unsigned char Index)
{
  if ((xc<img.width)&&(yc<img.height))
    put_pixel((xc++)+img.posx,yc+img.posy,Index);
  if (xc==img.width) {
     xc=0;
     if (!img.interlace)
       yc++;
     else {
       yc+=(pass>0)?(16>>pass):(8);
       if (yc>=img.height) yc=4>>(pass++);
     }
  }
}

int read_screendesc(SCR *sd)
{
  unsigned char buffer[13];
  unsigned int cms;

  fread(buffer,1,13,giffile);
  if (strnicmp(buffer,"GIF",3)!=0) return 0;
  sd->width=buffer[6]|(buffer[7]<<8);
  sd->height=buffer[8]|(buffer[9]<<8);
  sd->gcm=(buffer[10] & 0x80);
  sd->resolution=((buffer[10] & 0x70) >> 5) +1;
  sd->bpp=(buffer[10] & 7) +1;
  sd->background=buffer[11];
  cms=1 << sd->bpp;
  bitmask=cms-1;

  /* Skip colomap, if it exists ... */
  if (sd->gcm) fseek(giffile,cms*3,SEEK_CUR);
  return 1; /* Ok. */
}

void read_imagedesc(IMG *id)
{
  unsigned char buffer[10];
  int A;

  fread(buffer,1,10,giffile);
  id->posx=buffer[0]|(buffer[1]<<8);;
  id->posy=buffer[2]|(buffer[3]<<8);
  id->width=buffer[4]|(buffer[5]<<8);
  id->height=buffer[6]|(buffer[7]<<8);;
  id->interlace=(buffer[8] & 0x40);
  codesize=buffer[9];
  clearcode=1<<codesize;
  eofcode=clearcode+1;
  firstfree=clearcode+2;
  freecode=firstfree;
  codesize++;
  initcodesize=codesize;
  maxcode=1<<codesize;
  readmask=maxcode-1;
}

unsigned int get_code(unsigned long *bitoffset)   /* Read a code from bitpos */
{
  unsigned long rawcode;
  unsigned int byteoffset;

  byteoffset=*bitoffset >> 3;
  rawcode=(((unsigned long) (((long)*(gifstuff+byteoffset))|
			     ((long)*(gifstuff+byteoffset+1)<<8)|
			     ((long)*(gifstuff+byteoffset+2)<<16)))
			     >> (*bitoffset & 7)) & readmask;
  *bitoffset+=codesize;
  return rawcode;
}

void read_image()
{
  unsigned long gifpos,gifsize;
  unsigned char c,*gifread;
  unsigned long code,curcode,oldcode,incode;
  unsigned long bitoffset;

  read_imagedesc(&img);

  /* read compressed gif-datastream into RAM */
  gifpos=ftell(giffile);gifsize=0;
  while ((c=getc(giffile))!=0) {
    fseek(giffile,c,SEEK_CUR);
    gifsize+=c;
  }
  fseek(giffile,gifpos,SEEK_SET);
  gifstuff=(char *)malloc(gifsize);
  gifread=gifstuff;
  while ((c=getc(giffile))!=0) {
    fread(gifread,c,1,giffile);
    gifread+=c;
  }
  /* decompress gif-datastream */
  bitoffset=0;xc=0;yc=0;pass=0;
  while ((code=get_code(&bitoffset)) != eofcode) {
    if (code == clearcode) {
       codesize=initcodesize;
       maxcode=1 << codesize;
       freecode=firstfree;
       readmask=(1 << codesize)-1;
       code=get_code(&bitoffset);
       curcode=code;
       oldcode=code;
       finchar=code & bitmask;
       draw_data (finchar);
    } else {
       int i,outcount;
       outcount=0;
       curcode=code;
       incode=code;
       if (code>=freecode) {
	  curcode=oldcode;
	  outcode[outcount++]=finchar;
       }
       while (curcode>bitmask) {
	  outcode [outcount++]=suffix [curcode];
	  curcode=prefix [curcode];
       }
       finchar=curcode & bitmask;
       outcode [outcount++]=finchar;
       for (i=outcount;i>0;i--)
	  draw_data(outcode [i-1]);
       prefix [freecode]=oldcode;
       suffix [freecode]=finchar;
       oldcode=incode;
       freecode++;
       if (freecode>=maxcode) {
	  if (codesize<12) {
	    codesize++;
	    maxcode<<=1;
	    readmask=maxcode-1;
	 }
       }
    }
  }
  free (gifstuff);
}

void skip_extension()
{
  unsigned char c;
  getc(giffile); /* Skip "type" */
  while ((c=getc(giffile))!=0)
    fseek(giffile,c,SEEK_CUR);
}

int optimize_map()
{
  unsigned int xx,yy,cc;
  for (xx=0;xx<(gbwidth>>3);xx++)
    for (yy=0;yy<(gbheight>>3);yy++)
    {
      cc=0;
      while ((cc<gbfontsize)&&(memcmp(gbfont+cc,gbscreen+(yy<<4)+(xx*(gbheight<<1)),16)!=0)) cc+=16;
      if (cc==gbfontsize) {
	if (gbfontsize<(16*256)) {
	  memcpy(gbfont+cc,gbscreen+(yy<<4)+(xx*(gbheight<<1)),16);
	  gbfontsize+=16;
	} else return 0;
      }
      *(gbmap+xx+(yy*(gbwidth>>3)))=cc>>4;
    }
  return 1;
}

void data_dump(char *name,unsigned char *pos,unsigned long len)
{
  FILE *gbfile;
  if ((gbfile=fopen(name,"wb"))!=NULL)
  {
    fwrite(pos,len,1,gbfile);
    fclose(gbfile);
  } else
    printf("error writing %s !\n",name);
}

int checkparam(char *param)
{
  char *point;
  if ((*param=='-')||(*param=='/'))
  {
    param++;
    switch (tolower(*param)) {
      case 'p' : param++;
		 if (*(param++)=='=')
		   strcpy(picname,param);
		 else {
		   strcpy(picname,gifname);
		   if ((point=strrchr(picname,'.'))!=NULL)
		      *point=0;
		   strcat(picname,".p");
		 }
		 break;
      case 'm' : param++;
		 if (*(param++)=='=')
		   strcpy(mapname,param);
		 else {
		   strcpy(mapname,gifname);
		   if ((point=strrchr(mapname,'.'))!=NULL)
		      *point=0;
		   strcat(mapname,".m");
		 }
		 break;
      case 'f' : param++;
		 if (*(param++)=='=')
		   strcpy(fontname,param);
		 else {
		   strcpy(fontname,gifname);
		   if ((point=strrchr(fontname,'.'))!=NULL)
		      *point=0;
		   strcat(fontname,".f");
		 }
		 break;
      case 's' : param++;
		 if (sscanf(param,"=%u,%u",&gbwidth,&gbheight)!=2) return 0;
		 break;
    }
  } else return 0;
  return 1;
}

int main(int argc,char *argv[])
{
  if (argc>1) {
    gifname=argv[1];
    if ((giffile=fopen(gifname,"rb"))!=NULL) {
      char code;
      int c;
      if (read_screendesc(&scr)) {
	gbwidth=(scr.width+7) & 0xfff8;
	gbheight=(scr.height+7) & 0xfff8;
	picname[0]=mapname[0]=fontname[0]=0;
	for (c=2;c<argc;c++)
	  if (!checkparam(argv[c]))
	    printf("syntax error \"%s\"\n",argv[c]);
	printf("converting gif %s with the size %u*%u\n",gifname,gbwidth,gbheight);
	gbsize=((gbwidth*gbheight)>>3)<<1;
	gbscreen=malloc(gbsize);
	memset(gbscreen,0,gbsize);
	do {
	  code=getc(giffile);
	  switch (code) {
	    case ',': read_image();
		      break;
	    case '!': skip_extension();
		      break;
	  }
	} while (code!=';');

	fclose (giffile);

	/* dump screen to disk */
	if (picname[0]!=0) {
	  printf("writing screen %s ...\n",picname);
	  data_dump(picname,gbscreen,4096);
	}

	if ((fontname[0]!=0)||(mapname[0]!=0)) {

	  /* optimize map+font */
	  gbmapsize=(gbwidth>>3)*(gbheight>>3);
	  gbmap=malloc(gbmapsize);
	  gbfontsize=0;
	  gbfont=malloc(256*16);

	  if (optimize_map()) {
	    printf("optimized using %u chars\n",gbfontsize/16);

	    /* dump map to disk */
	    if (mapname[0]!=0) {
	      printf("writing map %s ...\n",mapname);
	      data_dump(mapname,gbmap,gbmapsize);
	    }
	    /* dump font to disk */
	    if (fontname[0]!=0) {
	      printf("writing font %s ...\n",fontname);
	      data_dump(fontname,gbfont,gbfontsize);
	    }
	  } else
	    printf("gif too komplex to optimize it !\n");
	  free(gbfont);free(gbmap);
	}
	free(gbscreen);
      } else
	  printf("%s not a gif-file !\n",gifname);
    } else
	printf("Error opening %s !\n",gifname);
  } else
      printf("GIF2GB <file> [-s=w,h][-p[=<name>]][-m[=<name>]][-f[=<name>]]\n");
  return 0;
}
