/* Convert TASM Symbols to GBSIM Symbols             (C) Jens Ch. Restemeier */

#include <stdlib.h>
#include <stdio.h>

int main(int argc,char *argv[])
{
  if (argc!=3)
  {
    printf("SYM2L <infile> <outfile>\n");
    return 1;
  } else {
    FILE *sym,*l;
    if ((sym=fopen(argv[1],"rt"))!=NULL)
    {
      if ((l=fopen(argv[2],"wt"))!=NULL)
      {
	char symbol[34],adress[6];
	fprintf(l,"; ============================================================================\n");
	fprintf(l,";  Symbols\n");
	fprintf(l,"; ============================================================================\n\n");
	while (!feof(sym))
	{
	  fscanf(sym,"%s %s",symbol,adress);
	  fprintf(l,"%-16s EQU 0%sh\n",symbol,adress);
	}
	fprintf(l,"\n; ============================================================================\n");
	fclose(l);
      } else {
         printf("Error opening %s !",argv[2]);
	 return 1;
      }
      fclose(sym);
    } else {
       printf("Error reading %s !",argv[1]);
       return 1;
    }
    return 0;
  }
}