#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <alloc.h>
#include <dos.h>

#define TRUE 1
#define FALSE 0

void EndIt(void);

FILE *handle;
FILE *handle2;
FILE *handle3;
char filename1[13];
char filename2[13];
char filename3[13];
char far *planeptr;
char far *tmpptr;
char far *bufferptr;
int StartSprite;
int SpriteValid;
int Width;
int Height;
long filelength;
struct spriteheader
{
    int  Version;
    char SpriteFile[13];
    char Palette[768];
    int  NumSprites;
};

spriteheader SpriteHeader;

int main(){

    clrscr();
    printf("WGT Sprite to Sega Sprite converter.\n");
EnterName:
    printf("\nEnter the name of sprite file (include extension)> ");
    scanf("%s",&filename1);
    if (filename1=="")
    {
        printf("Please enter a sprite file name.\n");
        goto  EnterName;
    }
EnterData:
    printf("\nEnter the name of data file to save (include extension)> ");
    scanf("%s",&filename2);

    if (filename2=="")
    {
        printf("Please enter a data file name.\n");
        goto  EnterData;
    }

EnterPal:
    printf("\nEnter the name of palette file to save (include extension)> ");
    scanf("%s",&filename3);

    if (filename3=="")
    {
        printf("Please enter a data file name.\n");
        goto  EnterPal;
    }

    handle=fopen(filename1,"rb");
    if (handle==NULL)
    {
        printf("%s does not exist. Please enter another sprite file name.\n",filename1);
        goto  EnterName;
    }

    handle2=fopen(filename2,"wb");

    if (handle2==NULL)
    {
        printf("Could not create %s. Please enter another data file name.\n",filename2);
        fclose(handle);
        goto  EnterData;
    }

    handle3=fopen(filename3,"wb");

    if (handle3==NULL)
    {
        printf("Could not create %s. Please enter another palette file name.\n",filename3);
        fclose(handle);
        fclose(handle2);
        goto  EnterPal;
    }

    planeptr=(char *)farmalloc(64000);
    tmpptr=planeptr;

    bufferptr=(char *)farmalloc(300);

    fread(&SpriteHeader,sizeof(spriteheader),1,handle);

    for (int palloop = 0; palloop <16; palloop++)
    {
        unsigned char red   = (SpriteHeader.Palette[palloop * 3] + 2) >> 2;
        unsigned char green = (SpriteHeader.Palette[palloop * 3 + 1] + 2) >> 2;
        unsigned char blue  = (SpriteHeader.Palette[palloop * 3 + 2] + 2) >> 2;
        unsigned short color =  blue | ((unsigned short)green << 12) | ((unsigned short)red << 8);
        fwrite(&color, 1, 2, handle3);
    }

    fclose(handle3);

    if (SpriteHeader.Version==4) StartSprite=0;
    else StartSprite=1;

    fseek(handle,0,SEEK_END);
    filelength=ftell(handle)-sizeof(spriteheader);
    rewind(handle);

    if (filelength>65536)
    {
        printf("Invalid Sprite File.\n");
        EndIt();
    }

    fseek(handle, sizeof(spriteheader), SEEK_SET);
    fread(tmpptr, 1, filelength, handle);
    fclose(handle);

    for (int outerloop=StartSprite;outerloop<SpriteHeader.NumSprites+1;outerloop++)
    {
        SpriteValid=*tmpptr;
        tmpptr+=2;
        if (SpriteValid==1)
        {
            Width=*tmpptr;
            tmpptr+=2;
            Height=*tmpptr;
            tmpptr+=2;
            if ((Width==0) || (Height==0)) continue;

            for (int col = 0; col < (Width/8); col++)
            {
                char far *ptr  = tmpptr + (col * 8);
                char far *bptr = bufferptr;

                for (int row = 0; row < (Height/8); row++)
                {
                    for (int line = 0; line < 8; line++)
                    {
                        for (int pixel = 0; pixel < 8; pixel += 2)
                        {
                            *bptr = (*(ptr++) & 15) << 4;
                            *bptr |= *(ptr++) & 15;

                            bptr++;
                        }
                        ptr += (Width - 8);
                    }
                }

                fwrite(bufferptr, 1, (32 * Height / 8), handle2);
            }
            tmpptr += Width * Height;
        }
    }
  fclose(handle2);

    EndIt();
    return 1;
}

void EndIt(void)
{
    fclose(handle);
    fclose(handle2);
    farfree(planeptr);
    farfree(bufferptr);
    exit(0);
}
