/*rotation, translation stuff...
				--Pin Fei Sun
*/
#include<stdlib.h>
#include<conio.h>

#include "define.h"
#include "screen.h"
#include  "3d.h"
#include  "bsp.h"
#include  "math.h"
#include  "draw.h"


//add one more vertex to the object vertex list.
short OBJ3D::add_vertex(POINT new_p)
  {
   if (total_vertex==0)
     o_ver=(VERTEX *)malloc(sizeof(VERTEX));
   else
     o_ver=(VERTEX *)realloc(o_ver, (total_vertex+1)*sizeof(VERTEX));
     
   o_ver[total_vertex].l=new_p;
   o_ver[total_vertex].l.t=1;
   total_vertex++;
   return (total_vertex-1);
  }     
     

//split polygon according to array of vertices.
short OBJ3D::poly_split(short *front, short f_num, short *back, 
				short b_num, short cur)
  {
  free(o_poly[cur].p_ver);
  //change original polygon.
  o_poly[cur].p_ver=(short *)malloc(f_num*sizeof(short));
  memcpy(o_poly[cur].p_ver, front, f_num*sizeof(short));
  o_poly[cur].num_of_vertex=f_num;
  
  //add another polygon.
  o_poly=(POLYGON *)realloc(o_poly, (total_poly+1)*sizeof(POLYGON));
  memcpy(&o_poly[total_poly], &o_poly[cur], sizeof(POLYGON));
  o_poly[total_poly].p_ver=(short *)malloc(b_num*sizeof(short));
  memcpy(o_poly[total_poly].p_ver, back, b_num*sizeof(short));
  o_poly[total_poly].num_of_vertex=b_num;
  
  total_poly++;
  
  //return the added polygon.
  return (total_poly-1);
  }
  				
     

//set up coordinates in world space by multiplying the matrix with all
//vertices in local space.
void obj3d::setworld()
{
int i;

//set vertices in the world.  
  for (i=0; i<total_vertex; i++)
    o_ver[i].w=mul_point_matrix(o_ver[i].l, matrix, 1);
   
//set normals(needs better ways to minimize calculation).
  for (i=0; i<total_poly; i++)
    {
    o_poly[i].normal_w=mul_point_matrix(o_poly[i].normal_l, matrix, 0);  
    o_poly[i].normal_w.t=get_D(o_ver[o_poly[i].p_ver[0]].w, o_poly[i].normal_w);
    }

}


//setup the view space by
// dividing x, y in world space by z in world space.
void obj3d::setview()
{
  int i;
  VAR z_diff;
  for (i=0; i<total_vertex; i++)
    {
    z_diff = o_ver[i].w.z-CAMERA.z;
    if (z_diff==0) z_diff=1;
    
    o_ver[i].v.x=(short)((o_ver[i].w.x-CAMERA.x)*VIEW/z_diff)+CENTERX;
    o_ver[i].v.y=(short)((o_ver[i].w.y-CAMERA.y)*VIEW/z_diff)+CENTERY;
    }
}


//draw object to 'screen'
void obj3d::draw(BYTE	*screen)
{
    short i, start=0;
    ELETYPE *list= new ELETYPE[total_poly];
    //retrieve polygon list.
    bsp->traversal(this, list, start);    
    //draw them
    for (i=0; i<start; i++)
  	 {
         draw_poly(o_ver, &o_poly[list[i]], screen);
	 
	 if (C.debug==1)	//draw one poly at a time
	   {
	   getch();
	   PAINT_SCREEN(0, 0, 320, 200, screen);
	   }
	 }
}


void obj3d::id_matrix()
{
  int i, j;

  for (i=0;i<4;i++)
   for (j=0; j<4; j++)
       if(i==j)
       matrix[i][j]=X2O(1);
       else
       matrix[i][j]=0;
}


void obj3d::scale(VAR ratio)
{
int i,j;

for (i=0;i<3;i++)
  for (j=0;j<3;j++)
  matrix[i][j]=O2X(matrix[i][j]*ratio);
}


//xan, yan, zan must < 639
void obj3d::rotate(short xan, short yan, short zan)
{
  VAR s1, s2, s3, c1, c2, c3;

  s1=SIN[yan]; s2=SIN[xan]; s3=SIN[zan];
  c1=COS[yan]; c2=COS[xan]; c3=COS[zan];

  VAR s2s3=O2X(s2*s3);
  VAR c1c3=O2X(c1*c3);
  VAR c3s1=O2X(c3*s1);

  VAR tmp[4][4];
  VAR copy[4][4];

  tmp[0][0]=c1c3+O2X(s1*s2s3);
  tmp[1][0]=O2X(c2*s3);
  tmp[2][0]=-c3s1+O2X(c1*s2s3);
  tmp[3][0]=0;
  tmp[0][1]=O2X(-c1*s3+c3s1*s2);
  tmp[1][1]=O2X(c2*c3);
  tmp[2][1]=O2X(s1*s3+c1c3*s2);
  tmp[3][1]=0;
  tmp[0][2]=O2X(c2*s1);
  tmp[1][2]=(-s2);
  tmp[2][2]=O2X(c1*c2);
  tmp[3][2]=0; tmp[0][3]=0; tmp[1][3]=0; tmp[2][3]=0; tmp[3][3]=O2X(1);

  mul_matrix(copy, tmp, matrix);
  dup_matrix(matrix, copy);
}


void OBJ3D::moveto(VAR view_x,VAR view_y,VAR view_z)
{
  matrix[0][3]=view_x;
  matrix[1][3]=view_y;
  matrix[2][3]=view_z;
}

