/*
	BSPNODE.cc
        All the bsp operation here
                --programmed by Pin Fei Sun
*/
#include <stdio.h>
#include <stdlib.h>

#include "define.h"
#include "3d.h"
#include "bsp.h"
#include "list.h"
#include "math.h"

void BSPNODE::build_bsp(OBJTYPE * obj, ELETYPE *list, short num_element)
{
	ELETYPE *Front=NULL, *Back=NULL;
	num_bsp_ele=0; elist=NULL;
	short num_front=0, num_back=0;
	
	//get the partition plane.
	ELETYPE *Root =find_root(obj, list, num_element);
        
        void *ppl=get_partition(obj, Root);
	
        add_element(Root);
	
	//get current element from the list to test according to Root.        
        ELETYPE *cur = list_front(list, num_element);
	
	while( cur)
	{
	  short status=classify(obj, ppl, cur);
	  
	  switch (status) {
	    case COINCIDENT:
	    //add to the bspnode.   
	        add_element(cur); break;
	    case FRONT:
	    //add to the list.
	        list_add(Front, num_front, cur); break;
	    case BACK:
	        list_add(Back, num_back, cur); break;
	    case SPAN:
	        //split polygon.
	        ELETYPE new_e = split(obj, ppl, cur);
		short flag=classify(obj, ppl, cur);
		if (flag==FRONT)   
		   list_add(Front, num_front, cur);
		else if (flag==BACK)
		   list_add(Back, num_back, cur);
                else printf("Error ");
                
                flag=classify(obj, ppl, &new_e);
                if (flag==BACK)		   
		   list_add(Back, num_back, &new_e);
		else if (flag==FRONT)
		   list_add(Front, num_front, &new_e);
		else printf("Error ");
		
		break;
	    }
	    
	//go to the next element.
	cur=list_front(list, num_element);
	}
	
	//recursively build front and back tree.
	if (num_front>0)
	  {
	  front_node=(BSPNODE *)malloc(sizeof(BSPNODE));
	  front_node->build_bsp(obj, Front, num_front);
          free(Front);
          }	
	else
	  front_node=NULL;
	  
	if (num_back>0)
	  {
	  back_node=(BSPNODE *)malloc(sizeof(BSPNODE));
	  back_node->build_bsp(obj, Back, num_back);
	  free(Back);
	  }
	else
	  back_node=NULL;
	
}



void BSPNODE::add_element(ELETYPE *src)
    {
     WORD size=(num_bsp_ele+11)*sizeof(ELETYPE);
      //allocate necessary memory.
     if (elist==NULL)
         elist=(ELETYPE *)malloc(size);
     else if (num_bsp_ele%10==0)
       elist=(ELETYPE *)realloc(elist, size);

     //copy the element to the location.
     memcpy(&elist[num_bsp_ele], src, sizeof(ELETYPE));
     num_bsp_ele++;
   }        
    


ELETYPE *BSPNODE::find_root(OBJTYPE * obj, ELETYPE * &list, short &num)
// Returns node which splits the least other nodes
{
	short best_count = 0x7fff;
	short index=-1;
	ELETYPE *best_root=new ELETYPE;
	ELETYPE *cur_root;
        short total_test=num;
        if (total_test>50) total_test=50;
	
	short i;

	for (i=0; i<total_test; i++)
	   {
		short count = 0;
		//select root.
		cur_root=&list[i];

		//get partition plane.
		void *plane=get_partition(obj, cur_root);		

		
		//count spanning.
		for (short j=0; j<num; j++)
		   if(classify(obj, plane, &list[j])==SPAN)
				count++;
		
		//update best solution.
		if( count < best_count )
		{		             
		 	best_count = count;
		        memcpy(best_root, cur_root, sizeof(ELETYPE));
		        index=i;
		        //if no splitting, that's the best root.
		        if (count==0)
		          {
		          list_rem(list, num, index);
		          return best_root;
		          }
		}
	    }
	
	list_rem(list, num, index);
        return best_root;
}				



void *BSPNODE::get_partition(OBJTYPE *obj, ELETYPE *root)
    {     
      //return the polygon's normal.
      return &obj->o_poly[*root].normal_w;   
    }

//find out distance from a point to a plane.
VAR BSPNODE::classify_point(VECTOR *plane, POINT x)
    {
        VAR value=dot_product(*plane, x);
        VAR cur=value+plane->t;
	return cur;
    }
        

//identify the position of one polygon from a plane.
short BSPNODE::classify(OBJTYPE *obj, void *plane, ELETYPE *x)
    {
      short front=0, back=0;
      VECTOR *tmp=(VECTOR *)plane;
      VERTEX *ver=obj->o_ver;
      POLYGON *poly=&obj->o_poly[*x];
      
      for (short i=0; i<poly->num_of_vertex; i++)
        {
        //classify the distance of each point to the plane.
        VAR cur=classify_point((VECTOR *)plane, ver[poly->p_ver[i]].l);
        //count numbers of them in front or back.
        if (cur>X2O(1)) front++;
        else if(cur<-X2O(1)) back++;
	}
      //return status.
      if ((back>0) && (front>0))
	return SPAN; 
      else if (back>0)
	return BACK;
      else if (front>0)
	return FRONT;

      return COINCIDENT;
     }
      
//split the polygon, originally coded in BSP FAQ, modified to suit the 
//3d data structure.
ELETYPE BSPNODE::split(OBJTYPE *obj, void *p_src, ELETYPE *cur)

     {
   	VERTEX *ver=obj->o_ver;     
        POLYGON *poly=&obj->o_poly[*cur];
        
        int   count = poly->num_of_vertex;
        short out_c = 0, in_c = 0;
        POINT ptA, ptB;
        short outpts[MAXPTS], inpts[MAXPTS];
        VAR sideA, sideB;
        ptA = ver[poly->p_ver[count - 1]].l;
        sideA = classify_point((VECTOR *)p_src, ptA);
        
        //for each line, find its intersection with the plane.
        for (short i = -1; ++i < count;)
        {
           ptB = ver[poly->p_ver[i]].l;
           sideB = classify_point((VECTOR *)p_src, ptB);
           //if two point lies at different side of the plane,
           //this line intersect with the plane.
           if (sideB <0)
           {
              if (sideA >0)
              {
                 VECTOR v = ptB - ptA;
                 POINT ext=ptA+(v*(-sideA)/dot_product(*(VECTOR *)p_src, v));
		 //find the position of the intersection vertex.
		 //add it to the list.                 
                 short cur_ver=obj->add_vertex(ext);
                 outpts[out_c++] = inpts[in_c++] = cur_ver;
              }
              outpts[out_c++] = poly->p_ver[i];
           }
           
           else if (sideB > 0)
           {
              if (sideA < 0)
              {
                 VECTOR v = ptB - ptA;
                 POINT ext=ptA+(v*(-sideA)/dot_product(*(VECTOR *)p_src, v));
              
                 short cur_ver=obj->add_vertex(ext);
                 outpts[out_c++] = inpts[in_c++] = cur_ver;
           	 short temp;      
		}
              inpts[in_c++] = poly->p_ver[i];
           }
           else
              outpts[out_c++] = inpts[in_c++] = poly->p_ver[i];
           
           ptA = ptB;
           sideA = sideB;
        }
        //split the polygon according to vertices added.
        ELETYPE new_e = obj->poly_split(inpts, in_c, outpts, out_c, *cur);
        return new_e;
     }



void BSPNODE::traversal(OBJTYPE *obj, ELETYPE *list, short &start)
   {
   //get the partition plane for current node
   void *part=get_partition(obj, &elist[0]);
   //classify camera position according to the partition plane.
   VAR dist=classify_point((VECTOR *)part, CAMERA);
   
   //go to the back nodes accroding to Camera position status.
   if(dist>0)  
     { 
     if (back_node!=NULL)
     back_node->traversal(obj, list, start);
     }
    else if (front_node!=NULL)
     front_node->traversal(obj, list, start);

   //retrieve elements in current node.    
   short size=sizeof(ELETYPE)*num_bsp_ele;
   memcpy(&list[start], elist, size);
   //update start position of the next polygon
   start+=num_bsp_ele;
   
   //go to nodes in the front
   if(dist>0)
     {
      if(front_node!=NULL)
      front_node->traversal(obj, list, start);
     }
   else if (back_node!=NULL)
      back_node->traversal(obj, list, start);
  }
   
