/*texture mapping, polygon filling, draw polygons
				--Pin Fei Sun
*/

#include<unistd.h>
#include<stdio.h>
#include<fcntl.h>
#include<string.h>

#include "define.h"
#include "screen.h"
#include "3d.h"
#include "draw.h"
#define UNIT_SH 8

SCN_HOR TRACE_LINE[SCREEN_HEIGHT];
char TL_IND[SCREEN_HEIGHT];

int LOWER_B, UPPER_B;


/*setup TRACE_LINE information in the path from (x1, y1) to (x2, y2):
  (x1, y1) start coordinates on screen.
  (x2, y2) end coordinates on screen.
  (mx1, my1) start coordinates on picture for texture mapping.
  (mx2, my2) end coordinates on picture for texture mapping.*/
//global array of variables TL_IND is 0, then current point is
// the starting point, otherwise it's the end point.
void polysetup(short x1, short y1, short x2, short y2, short mx1, short my1,
			short mx2, short my2)
{
 int i;
 long step, mxstep, mystep; //unit to move.
 short tmp;
 long j, mxj, myj;

 //not a horizonal line.
 if(y2!=y1)
    {
    step=((x2-x1)<<UNIT_SH)/(y2-y1);      //unit to add for x in screen
    mxstep=((mx2-mx1)<<UNIT_SH)/(y2-y1);  //unit to add for x in pic.
    mystep=((my2-my1)<<UNIT_SH)/(y2-y1);  //unit to add for y in pic


   if (y2 < y1)   //make sure y2 >= y1;
    {
    y1--;
    j = x2<<UNIT_SH;
    mxj = mx2<<UNIT_SH;
    myj = my2<<UNIT_SH;

    tmp = y1; y1 = y2; y2 = tmp;
    }
   else
    {
    y1++;
    j = (x1<<UNIT_SH)+step; mxj = (mx1<<UNIT_SH)+mxstep; myj=(my1<<UNIT_SH)+mystep;
    }

  if ((y1 > MAXY) || (y2 < 0))
    return;


    //verticle clipping.
    if (y1<0)
      {
       tmp = 0-y1;
       j+=step*tmp; mxj+=mxstep*tmp;
       myj+=mystep*tmp; y1=0;
      }

    if (y2>MAXY)
      y2=MAXY ;

 //set verticle range of current polygon.
    if (y1 < LOWER_B)   LOWER_B = y1;
    if (y2 > UPPER_B)   UPPER_B = y2;

    //ASSIGN values at each horizontal line.
    for(i=y1;i<=y2;i++)
      {
       //it's the start point.
       if (!TL_IND[i])
	 {
	  TRACE_LINE[i].x1=(j>>UNIT_SH);
	  TRACE_LINE[i].mx1=(mxj>>UNIT_SH);
	  TRACE_LINE[i].my1=(myj>>UNIT_SH);
	 }
       //it's the end point.
       else
	 {
	  TRACE_LINE[i].x2=(j>>UNIT_SH);
	  TRACE_LINE[i].mx2=(mxj>>UNIT_SH);
	  TRACE_LINE[i].my2=(myj>>UNIT_SH);
	 }

       mxj+=mxstep; myj+=mystep; j+=step;
       TL_IND[i]++;
      }
    }

  //if it's a horizontal line.
  else if ((y2<=MAXY) && (y2>=0))
      {
      if (!TL_IND[y2])
	{
	TRACE_LINE[y2].x1 = x2;
	TRACE_LINE[y1].mx1=mx2;
	TRACE_LINE[y1].my1=my2;
	}
      else
	{
	TRACE_LINE[y2].x2 = x2;
	TRACE_LINE[y1].mx1=mx2;
	TRACE_LINE[y1].my1=my2;
	}

      TL_IND[y2]++;
      }
}

//setup polygons has no texture mapping.
void poly_set_no_tex(short x1, short y1, short x2, short y2)
  {
  short i;
  long step; //unit to move.
  short tmp;
  long j;

  if(y2!=y1)
    {
    step=((x2-x1)<<UNIT_SH)/(y2-y1);      //unit to add for x in screen

    if (y2 < y1)   //make sure y2 >= y1;
       {
	y1--;		//skip first point
	j=(x2<<UNIT_SH);        //set j.
	tmp = y1; y1 = y2; y2 = tmp;
       }
    else
       {
       y1++; j=(x1<<UNIT_SH)+step; }  //skip first point, set j.

    if ((y1 > MAXY) || (y2 < 0))
      return;

    //verticle clipping.
    if (y1<0)
      {
       tmp = 0-y1;
       j+=step*tmp; y1=0;
      }

    if (y2>MAXY) y2=MAXY ;



 //set verticle range of current polygon.
    if (y1 < LOWER_B)   LOWER_B = y1;
    if (y2 > UPPER_B)   UPPER_B = y2;
    
    //assign value for each horizontal line.
    for(i=y1;i<=y2;i++)
      {
       if (!TL_IND[i])
	  TRACE_LINE[i].x1=(j>>UNIT_SH);
	else
	  TRACE_LINE[i].x2=(j>>UNIT_SH);

       TL_IND[i]++;
       j+=step;
      }

    }

   else if ((y2<=MAXY) && (y2>=0))
      {
      if (!TL_IND[y2])
      TRACE_LINE[y2].x1 = x2;
      else
      TRACE_LINE[y2].x2 = x2;
      TL_IND[y2]++;
      }

 }


//texture mapping polygon according to value in TRACE_LINE, and
//picture index 'ti'.  polysetup must had previously called.
void texture_map(int ti, BYTE	*screen)
{
  int i, j, x1, x2;
  int tmp;
  unsigned offs;

  register long mxj;  		//keep track of x position in picture
  register long myj;                 //keep track of y position in picture
  long txstep;                   //unit x to add after every pixel drawn.
  long tystep;
  long diff;
  BYTE	* ptr = GRAPH[ti];

  if (TL_IND[LOWER_B]==1)
	LOWER_B++;

  if (TL_IND[UPPER_B]==1)
       UPPER_B--;


  for (i=LOWER_B; i<= UPPER_B; i++)
    {
     x1=TRACE_LINE[i].x1; x2=TRACE_LINE[i].x2;

			   //make sure x2 is greater than x1.
     if(x1 !=x2)
	{
	 if (x1 > x2)
	    {
		tmp = x1;
		x1 = x2;
		x2 = tmp;

		tmp = TRACE_LINE[i].mx1;
		TRACE_LINE[i].mx1 = TRACE_LINE[i].mx2;
		TRACE_LINE[i].mx2 = tmp;

		tmp = TRACE_LINE[i].my1;
		TRACE_LINE[i].my1 = TRACE_LINE[i].my2;
		TRACE_LINE[i].my2 = tmp;
	    }

      //visible line.
	if ((x1 < MAXX) && (x2 > 0))

	    {
		//calculate units to add for each advanced pixel.
		mxj = (TRACE_LINE[i].mx1<<UNIT_SH);
		myj = (TRACE_LINE[i].my1<<UNIT_SH);

		txstep = ((TRACE_LINE[i].mx2-TRACE_LINE[i].mx1)<<UNIT_SH)/ (x2-x1);
		tystep = ((TRACE_LINE[i].my2-TRACE_LINE[i].my1)<<UNIT_SH)/ (x2-x1);

		 //clip left boundary.
		 if (x1 < 0)
		   {
		    tmp = 0-x1;
		    x1=0; mxj += txstep*tmp; myj+= tystep*tmp;
		   }

		    //clip right boundary.
		 if (x2 > MAXX)  x2 = MAXX;

		 offs = SCR_TBL[i]+x1;

		 diff = x2-x1+1;

		 
		 for (long q=0; q<diff; q++)
		   {
		   screen[offs++]=ptr[M_TEX_BPL(myj>>UNIT_SH)+(mxj>>UNIT_SH)];
		   myj+=tystep;
		   mxj+=txstep;
		   }
	      }
	  }
      }
}


void fill_poly(int color, BYTE	*screen)
  {
  int i, j, x1, x2;
  short tmp;
  BYTE col=(BYTE)color;

  
  BYTE * offs;
  int diff;

  //the upper and lower line might only contain start point.(skip it if it do).
  if (TL_IND[LOWER_B]==1)
	LOWER_B++;

  if (TL_IND[UPPER_B]==1)
       UPPER_B--;

  for (i=LOWER_B; i<= UPPER_B; i++)
    {
     x1=TRACE_LINE[i].x1; x2=TRACE_LINE[i].x2;
			   //make sure x2 is greater than x1.
         if (x1 > x2)
	    {
		tmp = x1;
		x1 = x2;
		x2 = tmp;
	    }

      //visible line.
	if ((x1 <= MAXX) && (x2 >= 0))

	    {

		 //clip left boundary.
		 if (x1 < 0) x1=0;


		 //clip right boundary.
		 if (x2 > MAXX)  x2 = MAXX;

		 offs = screen+SCR_TBL[i]+x1;

		 diff = x2-x1;
		 diff++;
		
                 memset(offs++, col, diff); 
	      }
	  }
}


//draw polygons according to array of vertices in 'ver'
//and array of polygons in 'poly' to 'screen.
void draw_poly(VERTEX * ver, POLYGON * poly, BYTE   *screen)
{
  long i, j;
  long size=SCREEN_HEIGHT;
  int rv=poly->num_of_vertex;  //total number of vertex in the polygon.

  COORD *tmp, *tmp2;
  COORD *tmp_tex, *tmp_tex2;

  //setup initial boundary according to the screen.
  UPPER_B = 0;
  LOWER_B = MAXY;

  //initial TL_IND, used for TRACE_LINE setup.
  memset(TL_IND, 0, size); 
 
  if (poly->texture_index>=0)
     {
     //setup poly boundary by updating TRACE_LINE.
     for (i=0; i<rv; i++)
       {
       j = (i+1) % rv;
       tmp = &(ver[poly->p_ver[i]].v);
       tmp2 = &(ver[poly->p_ver[j]].v);
       tmp_tex = &(poly->texture_ver[i]);
       tmp_tex2 = &(poly->texture_ver[j]);

       polysetup(tmp->x, tmp->y, tmp2->x, tmp2->y,
		 tmp_tex->x, tmp_tex->y, tmp_tex2->x, tmp_tex2->y);
       }

       texture_map (poly->texture_index, screen);
     }
  else
     {
      for (i=0; i<rv; i++)
	 {
	 j = (i+1) % rv;
	 tmp = &(ver[poly->p_ver[i]].v);
	 tmp2 = &(ver[poly->p_ver[j]].v);
	 poly_set_no_tex(tmp->x, tmp->y, tmp2->x, tmp2->y);
         }
	 fill_poly(poly->color, screen);
     }
}

//open file with name 'name', put image data in ptr, palette data in pal.
int getraw(char *name, BYTE   *ptr, BYTE   *pal)
{
int handle;
WORD fileWidth;
WORD fileHeight;

if((handle=open(name, O_RDONLY|O_BINARY))==-1)     //open source file.
  {
  perror(name);
  return 0;
  }

read(handle, &fileWidth, sizeof(WORD));
read(handle, &fileHeight, sizeof(WORD));

read(handle, pal, 256*3);
read(handle, ptr, fileWidth*fileHeight);
return 1;
}

