#include <math.h>
#include <conio.h> 
#include <alloc.h>
#include <mem.h>
#include "graphics.h"
#include <stdlib.h>
#include <time.h>
#include "poly.h"

#define r2d(rd)         ((rd)*3.141592654/128)
#define DISTX           256     /* 256 or 277 */
#define DISTY           256     /* 256 or 173 */
#define DISTPERSPECTIVE(screen,degrees) (((screen)/2)/(tan((deg)/2)))
#define POINTS          256

void main()
{
        float   Tcos[256],Tsin[256],scale=1;
        int     xnews[POINTS],ynews[POINTS];
        long    xp[POINTS],yp[POINTS],zp[POINTS],     
                bx,by,bz,                     
                rx,ry,rz,            
                rrx,rry,rrz,
                xnew,ynew,znew,
                point,point2,
                xo,yo,rot=7,frames=0;

        unsigned
                time1,time2;
        unsigned char
                xang,yang,zang,        
                done=0,
                color,colors,demo=1,polyon=1;

        for(point=0;point<256;point++)
        {
                Tcos[point]=(float)cos(r2d(point));
                Tsin[point]=(float)sin(r2d(point));
        }

        point=0;
        xang=0;
        for(yo=-8;yo<8;yo++)
        {
                for(xo=-8;xo<8;xo++)
                {
                        xp[point]=xo*20;
                        yp[point]=-15;
                        zp[point]=yo*20;
                        point++;
                }
        }
        srand((unsigned)time(NULL));
        yp[rand()%POINTS]=rand()%20;
        yp[rand()%POINTS]=rand()%30;


        printf("3D Plane Rotation Demo\n");             
        printf("By Dhonn Lushine 1996 Ludhonn@aol,com: compiled on %s %s\n\n",__TIME__,__DATE__);
        printf("Turn Numlock on\nNote: All numlock keys have functions\nArrow keys\tRotate\n");
        printf("Press enter to quit\n\nPress any key to continue...\n");
        if(getch()=='\r') return;


        if((double_buffer=farmalloc(0xffff))==NULL)
        {
                printf("Memory allocation error");
                getch();
                return;
        }

        asm{
        mov ax,13h
        int 10h
        }

        /* outportb(0x3c2, 0xe3); */
             
	xang=0;
	yang=0;
        zang=0;

        xo=0;
        yo=0;

        colors=78;

        time1=time(NULL);

        while(!done)
        {
                for(point=0;point<POINTS;point++)
		{
                        bx=xp[point]*scale;
                        by=yp[point]*scale;
                        bz=zp[point]*scale; 


                        /* Rotate y */
                        rx = Tcos[yang] * bx + Tsin[yang] * bz;
                        rz = -Tsin[yang] * bx + Tcos[yang] * bz;

                                    
                      
                        /* Rotate x */
                        ry = Tcos[xang] * by - Tsin[xang] * rz;
                        rrz = Tsin[xang] * by + Tcos[xang] * rz;


                        /* Rotate z */  
                        rrx = Tcos[zang] * rx - Tsin[zang] * ry;
                        rry = Tsin[zang] * rx + Tcos[zang] * ry;

                        rrz+=DISTX;
                        if(0>=rrz)
                        {
                         rrz=1;
                         }
                                xnew=(rrx+xo)*DISTX/(rrz)+160;
                                ynew=-(rry+yo)*DISTY/(rrz)+100;
                         
                        xnews[point]=xnew;
                        ynews[point]=ynew;
		}

                color=colors;
                if(polyon==1)
                {
                        int a,b;
                        for(b=0;b<240;b+=16)
                        for(a=b;a<15+b;a++)
                        {
                                color=colors;
                                Triangle(xnews[a],ynews[a],xnews[a+1],ynews[a+1],xnews[a+16],ynews[a+16],color++);
                                Triangle(xnews[a+16],ynews[a+16],xnews[a+17],ynews[a+17],xnews[a+1],ynews[a+1],color++);
                                
                        }

                }
                else if(polyon==2)
                {

                        int a,b;
                        for(b=0;b<240;b+=16)
                        for(a=b;a<15+b;a++)
                        {
                                color=colors;
                                Triwire(xnews[a],ynews[a],xnews[a+1],ynews[a+1],xnews[a+16],ynews[a+16],color++);
                                Triwire(xnews[a+16],ynews[a+16],xnews[a+17],ynews[a+17],xnews[a+1],ynews[a+1],color++);
                                
                        }

                }
                else 
                {
                        for(point=0;point<POINTS;point++)
                        {
                                int a,b;
                                a=xnews[point];
                                b=ynews[point];
                                PutPixel_DB(a,b,point%16+color);
                        }

                }
                        

                VertRetrace();
                _fmemcpy(video_buffer,double_buffer,64000);
                _fmemset(double_buffer,0,64000);
                frames++;


                if(kbhit())
                {
                        switch(getch())
			{
                                case 0:
                                switch(getch())
                                {
                                        case 0x50:      xang-=rot;
                                                        break;
                                        case 0x48:      xang+=rot;
                                                        break;
                                        case 0x4b:      yang+=rot;
                                                        break;
                                        case 0x4d:      yang-=rot;
                                                        break;
                                }               break;
                                case '3':       zang+=rot;
                                                break;
                                case '1':       zang-=rot;
                                                break;
                                case '8':       yo+=rot;
                                                break;
                                case '2':       yo-=rot;
                                                break;
                                case '4':       xo-=rot;
                                                break;
                                case '6':       xo+=rot;
                                                break;
                                case '7':       scale-=.02;
                                                break;
                                case '9':       scale+=.02;
                                                break;
                                case '5':       colors++;
                                                break;
                                case '0':       xang=0;
                                                yang=0;
                                                zang=0;
                                                scale=1;
                                                xo=0;
                                                yo=0;
                                                rot=7;
                                                break;
                                case '+':       rot++;
                                                break;
                                case '-':       rot--;
                                                break;
                                case '.':       demo=!demo;
                                                break;
                                case '*':       polyon++;
                                                if(polyon==4)
                                                polyon=1;
                                                break;
                                case '/':       yp[rand()%POINTS]=rand()%35;
                                                break;
                                case '\r':     done=1;
                                                break;

                        }
                }

                if(demo)
                {
                        xang++;
                        yang++;
                }
	}
        time2=time(NULL);

        asm{
        mov ax,03h
        int 10h
        }

        farfree(double_buffer);

        printf("Frames: %.f\n",(float)frames);
        printf("Seconds: %u\n",time2-time1);
        if(time2-time1)
        printf("Frames per sec: %f\n",(float)frames/(time2-time1));
        getch();
}

