                     ALIGN 4
Flat_Triangle_Filler PROC NEAR

                     call       Sort_Y              ;sort y coordinates
                     call       Clip_Y_All

                     sal        [X1],16
                     sal        [X2],16
                     sal        [X3],16
                     ;calc right edge - longer edge - p1 <-> p3
                     mov        eax,[X3]            ;calculate longer edge -
                     sub        eax,[X1]            ;right edge
                     mov        esi,[Y3]
                     sub        esi,[Y1]
                     or         esi,esi
                     jz         @@No_Flat_Triangle
                     cdq
                     idiv       esi
                     mov        ebp,eax             ;(x3 - x1) / (y3 - y1)
                     ;calc screen offset
                     mov        eax,[Y1]            ;calculate offset on
                     lea        eax,[eax+eax*4]     ;screen to draw
                     shl        eax,6               ;NOTE: only Y position
                     lea        edi,[Virtual_Screen];we add X in procedure
                     add        edi,eax             ;Draw_Flat_Segment
                     ;calc shorter edge - left edge - p1 <-> p2
                     mov        eax,[X2]            ;calculate shorter edge -
                     sub        eax,[X1]            ;left edge
                     mov        esi,[Y2]
                     sub        esi,[Y1]
                     or         esi,esi
                     jz         @@No_Upper_Flat_Triangle
                     cdq
                     idiv       esi
                     mov        [X_Adder_Left],eax  ;(x2 - x1) / (y2 - y1)
                     ;setup starting values
                     mov        ebx,[X1]
                     mov        edx,ebx
                     ;cmp both adders
                     cmp        eax,ebp             ;to see which procedure
                     jg         @@Flat_1            ;we have to call.
                     call       Draw_Flat_Segment   ;if X_Adder_Left <
                     jmp        @@Flat_2            ;X_Adder_Right then
                     @@Flat_1:                      ;we draw from ebx to edx
                     call       Draw_Flat_Segment1  ;otherwise from edx to ebx
                     @@Flat_2:
                     ;update left edge - shorter edge - p2 <-> p3
                     mov        esi,[Y3]       ;if y2 = y3 we just return back
                     sub        esi,[Y2]       ;otherwise we have to draw
                     or         esi,esi        ;lower segment of triangle
                     jnz        @@Draw_Lower_Flat_Segment
                     RET                            ;return
                     @@Draw_Lower_Flat_Segment:
                     push       edx                 ;IDIV suxx cause it destroy EDX ;-)
                     mov        eax,[X3]            ;we have to update
                     sub        eax,[X2]            ;left edge
                     cdq
                     idiv       esi
                     mov        [X_Adder_Left],eax  ;(x3 - x2) / (y3 - y2)
                     ;update starting values
                     mov        ebx,[X2]
                     pop        edx                 ;oh not, again IDIV
                     ;cmp both x positions
                     cmp        ebx,edx             ;compare both x positions
                     jg         @@Flat_3            ;to see which procedure
                     call       Draw_Flat_Segment   ;we have to call
                     RET                            ;if ebx < edx then we
                     @@Flat_3:                      ;draw from ebx to edx
                     call       Draw_Flat_Segment1  ;otherwise from edx to ebx
                     RET                            ;return
                     ;no upper triangle...
                     @@No_Upper_Flat_Triangle:      ;y1 = y2
                     ;calc edge from p2 <-> p3
                     mov        [X_Adder_Left],ebp  ;(x3 - x1) / (y3 - y1)
                     mov        eax,[X3]            ;right edge
                     sub        eax,[X2]
                     mov        esi,[Y3]
                     sub        esi,[Y2]
                     cdq
                     idiv       esi
                     mov        ebp,eax             ;(x3 - x2) / (y3 - y2)
                     ;calc screen offset
                     mov        eax,[Y1]            ;calculate offset on
                     lea        eax,[eax+eax*4]     ;screen to draw
                     shl        eax,6               ;NOTE: only Y position
                     lea        edi,[Virtual_Screen];we add X in procedure
                     add        edi,eax             ;Draw_Flat_Segment
                     ;setup starting values
                     mov        ebx,[X1]            ;setup starting values
                     mov        edx,[X2]
                     ;cmp both x positions
                     cmp        ebx,edx             ;compare both x positions
                     jg         @@Flat_4            ;to see which procedure
                     call       Draw_Flat_Segment   ;we have to call
                     RET                            ;if ebx < edx then we
                     @@Flat_4:                      ;draw from ebx to edx
                     call       Draw_Flat_Segment1  ;otherwise from edx to ebx
                     @@No_Flat_Triangle:

                     RET                            ;return

Flat_Triangle_Filler ENDP



;;
;                                                                          ;
; Name       : Draw_Flat_Segment                                           ;
; Description: Draw one segment of flat triangle                           ;
; Input      : EDI = screen offset (row number)                            ;
;              ESI = height of triangle                                    ;
;              EBP = x adder right                                         ;
;              EBX = start x position                                      ;
;              EDX = end x position                                        ;
; Output     : /                                                           ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
                  ALIGN 4
Draw_Flat_Segment PROC NEAR

                  @@Draw_Flat_Segment_Loop:
                                                    ;interpolating...
                  add           ebx,[X_Adder_Left]  ;left edge
                  add           edx,ebp             ;right edge

                  mov           eax,ebx
                  call          Clip_X
                  mov           ebx,eax
                  mov           eax,edx
                  call          Clip_X
                  mov           edx,eax

                  mov           ecx,edx      ;calculating lenght of hline here
                  mov           cx,0ffffh    ;DO NOT REMOVE THAT LINE!
                  sub           ecx,ebx      ;kalms's advice
                  sar           ecx,16       ;it makes shapes better looking
                  inc           ecx
                  push          edi

                  mov           eax,ebx
                  sar           eax,16        ;get x position of current hline
                  add           edi,eax       ;calculate offset on screen

                  mov           al,[Flat_Color]
                  mov           ah,al
                  push          ax
                  push          ax
                  pop           eax

                  sar           ecx,1
                  jnc           @@Flat_Byte
                  mov           [edi],al
                  inc           edi
                  @@Flat_Byte:
                  sar           ecx,1
                  jnc           @@Flat_Word
                  mov           [edi],ax
                  add           edi,2
                  @@Flat_Word:
                  sal           ecx,2
                  neg           ecx
                  sub           edi,ecx
                  @@Flat_Inner_Loop:
                  mov           [edi+ecx],eax
                  add           ecx,4
                  cmp           ecx,0
                  jle           @@Flat_Inner_Loop


                  pop           edi
                  add           edi,320

                  dec           esi
                  jnz           @@Draw_Flat_Segment_Loop

                  RET                               ;return

Draw_Flat_Segment ENDP


;;
;                                                                          ;
; Name       : Draw_Flat_Segment1                                          ;
; Description: Draw one segment of flat triangle                           ;
; Input      : EDI = screen offset (row number)                            ;
;              ESI = height of triangle                                    ;
;              EBP = x adder right                                         ;
;              EDX = start x position                                      ;
;              EBX = end x position                                        ;
; Output     : /                                                           ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
                   ALIGN 4
Draw_Flat_Segment1 PROC NEAR

                   @@Draw_Flat_Segment_Loop1:
                                                     ;interpolating...
                   add           ebx,[X_Adder_Left]  ;left edge
                   add           edx,ebp             ;right edge

                   mov           eax,ebx
                   call          Clip_X
                   mov           ebx,eax
                   mov           eax,edx
                   call          Clip_X
                   mov           edx,eax

                   mov           ecx,ebx     ;calculating lenght of hline here
                   mov           cx,0ffffh   ;DO NOT REMOVE THAT LINE!
                   sub           ecx,edx     ;kalms's advice
                   sar           ecx,16      ;it makes shapes better looking
                   inc           ecx
                   push          edi

                   mov           eax,edx
                   sar           eax,16       ;get x position of current hline
                   add           edi,eax      ;calculate offset on screen

                   mov           al,[Flat_Color]
                   mov           ah,al
                   push          ax
                   push          ax
                   pop           eax

                   sar           ecx,1
                   jnc           @@Flat_Byte1
                   mov           [edi],al
                   inc           edi
                   @@Flat_Byte1:
                   sar           ecx,1
                   jnc           @@Flat_Word1
                   mov           [edi],ax
                   add           edi,2
                   @@Flat_Word1:
                   sal           ecx,2
                   neg           ecx
                   sub           edi,ecx
                   @@Flat_Inner_Loop1:
                   mov           [edi+ecx],eax
                   add           ecx,4
                   cmp           ecx,0
                   jle           @@Flat_Inner_Loop1

                   pop           edi
                   add           edi,320

                   dec           esi
                   jnz           @@Draw_Flat_Segment_Loop1

                   RET                               ;return

Draw_Flat_Segment1 ENDP



