CODE SEGMENT DWORD PUBLIC 'CODE'
ASSUME cs:CODE,ds:DATA

;;
;                                                                          ;
; Name       : setMode13h                                                  ;
; Description: setup graphics mode 320x200x256, allocate memory for        ;
;              virtaul page and clear virtaul page and screen              ;
; Input      : /                                                           ;
; Output     : vPage, vPage_Tmp                                            ;
; Uses       : AX,EDX,EDI                                                  ;
;                                                                          ;
;;
setMode13h PROC NEAR
           ;this is really hard... :)
           mov      ax,0013h
           int      10h
           ;allocate some memory for virtual pages...
           ;first for main vPage...
           mov      ax,0ee42h
           mov      edx,0ffffh
           int      31h
           mov      [vPage],edx
           ;then for vPage_Tmp
           mov      ax,0ee42h
           mov      edx,0ffffh
           int      31h
           mov      [vPage_Tmp],edx
           ;clear screen
           xor      eax,eax
           mov      edi,vSegment
           mov      ecx,16000
           rep      stosd
           ;clear main virtual page
           mov      edi,[vPage]
           mov      ecx,16000
           rep      stosd
           ;clear tmp virtual page
           mov      edi,[vPage_Tmp]
           mov      ecx,16000
           rep      stosd
           ;set active page to screen
           mov      [activePage],pPhysical
           call     setActivePage
           RET
setMode13h ENDP

;;
;                                                                          ;
; Name       : textMode                                                    ;
; Description: setup text mode 80x24                                       ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : AX                                                          ;
;                                                                          ;
;;
textMode PROC NEAR
         ;again some complex code coming below :)
         mov      ax,0003h
         int      10h
         RET
textMode ENDP

;;
;                                                                          ;
; Name       : setActivePage                                               ;
; Description: setup active page                                           ;
; Input      : ActivePage = page we want to select                         ;
; Output     : aPage = current active page                                 ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
setActivePage PROC NEAR
              ;check if some of virtual pages is selected
              cmp      [activePage],1
              je       @@setActivePage1

              cmp      [activePage],2
              je       @@setActivePage2

              ;default value is vSegment
              mov      eax,[vSegment]
              jmp      @@setActivePage3

              @@setActivePage1:
              mov      eax,[vPage]
              jmp      @@setActivePage3

              @@setActivePage2:
              mov      eax,[vPage_Tmp]
              ;copy value to aPage variable
              @@setActivePage3:
              mov      [aPage],eax

              RET
setActivePage ENDP


;;
;                                                                          ;
; Name       : clear_vPage                                                 ;
; Description: clear virtual page or even screen                           ;
; Input      : EAX = color index                                           ;
; Output     : /                                                           ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
clear_vPage PROC NEAR
            mov      eax,[Color]
            mov      edi,[aPage]
            mov      ecx,16000
            rep      stosd
            RET
clear_vPage ENDP

;;
;                                                                          ;
; Name       : flip_vPage                                                  ;
; Description: flip virtual page to visible screen                         ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : ESI,EDI                                                     ;
;                                                                          ;
;;
flip_vPage PROC NEAR
           mov      esi,[aPage]
           mov      edi,vSegment
           mov      ecx,16000
           rep      movsd
           RET
flip_vPage ENDP

;;
;                                                                          ;
; Name       : setColor                                                    ;
; Description: set variable Color                                          ;
; Input      : EAX                                                         ;
; Output     : [Color]                                                     ;
; Uses       : /                                                           ;
;                                                                          ;
;;
setColor PROC NEAR
         mov      [Color],eax
         RET
setColor ENDP

;;
;                                                                          ;
; Name       : setPixel                                                    ;
; Description: put pixel to current selected page                          ;
; Input      : EBX = x, ECX = y                                            ;
; Output     : /                                                           ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
setPixel PROC NEAR
         mov      edi,aPage
         lea      ecx,[ecx+ecx*4]
         shl      ecx,6
         add      ecx,ebx
         add      edi,ecx
         mov      eax,[Color]
         mov      [edi],al
         RET
setPixel ENDP

;;
;                                                                          ;
; Name       : getPixel                                                    ;
; Description: get pixel to current selected page                          ;
; Input      : EBX = x, ECX = y                                            ;
; Output     : AL = color index                                            ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
getPixel PROC NEAR
         mov      edi,aPage
         lea      ecx,[ecx+ecx*4]
         shl      ecx,6
         add      ecx,ebx
         add      edi,ecx
         mov      al,[edi]
         RET
getPixel ENDP

;;
;                                                                          ;
; Name       : hLine                                                       ;
; Description: draw horizontal line to current selected page               ;
; Input      : EBX = start x, EDX = end x, ECX = y                         ;
; Output     : /                                                           ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
hLine PROC NEAR
      mov      eax,[Color]
      ;compare x positions
      cmp      ebx,edx
      je       @@hLine1
      jl       @@hLine2
      ;if start x > end x swap
      xchg     ebx,edx
      @@hLine2:
      ;set active page
      mov      edi,aPage
      ;calc page offset
      lea      ecx,[ecx+ecx*4]
      shl      ecx,6
      add      ecx,ebx
      add      edi,ecx
      mov      ecx,edx
      ;calc length of horizontal line
      sub      ecx,ebx
      sar      ecx,1
      jnc      @@hLine3
      mov      [edi],al
      inc      edi
      @@hLine3:
      sar       ecx,1
      jnc       @@hLine4
      mov       [edi],ax
      add       edi,2
      ;draw 4 bytes at same time - faster than 1 byte :)
      or        ecx,ecx
      jz        @@hLine1
      @@hLine4:
      mov       [edi],eax
      add       edi,4
      dec       ecx
      cmp       ecx,0
      jg        @@hLine4
      @@hLine1:
      RET
hLine ENDP

;;
;                                                                          ;
; Name       : vLine                                                       ;
; Description: draw vertical line to current selected page                 ;
; Input      : EBX = start y, EDX = end y, ECX = x                         ;
; Output     : /                                                           ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
vLine PROC NEAR
      mov      eax,[Color]
      ;compare y positions
      cmp      ebx,edx
      je       @@vLine1
      jl       @@vLine2
      ;if start y > end y swap
      xchg     ebx,edx
      @@vLine2:
      ;set active page
      mov      edi,aPage
      add      edi,ecx
      ;calc length of vertical line
      mov      ecx,edx
      sub      ecx,ebx
      ;calc page offset
      lea      ebx,[ebx+ebx*4]
      shl      ebx,6
      add      edi,ebx
      ;draw line... this time only with bytes :(
      @@vLine3:
      mov      [edi],al
      add      edi,320
      dec      ecx
      jnz      @@vLine3
      @@vLine1:
      RET
vLine ENDP

;;
;                                                                          ;
; Name       : nLine                                                       ;
; Description: draw normal line to current selected page                   ;
; Input      : EBX = start x, EAX = end x, EDX = start y, ECX = end y      ;
; Output     : /                                                           ;
; Uses       : EDI                                                         ;
;                                                                          ;
;;
nLine PROC NEAR
      RET
nLine ENDP

;;
;                                                                          ;
; Name       : Load_RAW                                                    ;
; Description: load .RAW picture to active page                            ;
; Input      : EDX = filename                                              ;
; Output     : /                                                           ;
; Uses       : AX,ECX,EDX                                                  ;
;                                                                          ;
;;
load_RAW PROC NEAR
         ;open .RAW file
         mov        ax,3d00h
         int        21h
         mov        [File_Handle],ax
         ;read from .RAW file
         mov        ax,3f00h
         mov        bx,[File_Handle]
         mov        ecx,[RAWsize]
         mov        edx,[aPage]
         int        21h
         ;close .RAW file
         mov        ax,3e00h
         mov        bx,[File_Handle]
         int        21h
         RET
         load_RAW_error:
load_RAW ENDP

;;
;                                                                          ;
; Name       : Load_PCX                                                    ;
; Description: load .PCX picture to active page                            ;
; Input      : EDX = filename                                              ;
; Output     : /                                                           ;
; Uses       : AX,ECX,EDX                                                  ;
;                                                                          ;
;;
load_PCX PROC NEAR
         ;open .PCX file
         mov      ax,3d00h
         int      21h
         mov      [File_Handle],ax
         ;get .PCX file size
         mov      ax,4202h
         mov      bx,[File_Handle]
         xor      ecx,ecx
         xor      edx,edx
         int      21h
         mov      [PCXsize],eax
         ;seek back to beginning of file
         mov      ax,4200h
         int      21h
         ;allocate memory for .PCX file to decompress
         mov      ax,0ee42h
         mov      edx,[PCXsize]
         int      31h
         mov      [PCXpage],edx
         ;read .PCX file to PCXpage
         mov      ax,3f00h
         mov      bx,[File_Handle]
         mov      ecx,[PCXsize]
         mov      edx,[PCXpage]
         int      21h
         ;close .PCX file
         mov      ax,3e00h
         mov      bx,[File_Handle]
         int      21h
         ;read some important values
         mov      esi,[PCXpage]
         mov      al,[esi+1]
         mov      [header.version],al
         mov      ax,[esi+4]
         mov      [header.sX],ax
         mov      ax,[esi+6]
         mov      [header.sY],ax
         mov      ax,[esi+8]
         inc      ax
         mov      [header.width],ax
         mov      ax,[esi+10]
         inc      ax
         mov      [header.height],ax
         ;read palette
         mov      edi,OFFSET [palette]
         add      esi,[PCXsize]
         sub      esi,768
         mov      ecx,768
         @@PCX_palette:
         mov      al,[esi+ecx]
         shr      al,2
         mov      [edi+ecx],al
         dec      ecx
         jnz      @@PCX_palette
         ;set PCX palette
         mov      esi,OFFSET palette
         mov      ecx,768
         call     setPalette
         ;skip 128 bytes long header
         mov      esi,[PCXpage]
         add      esi,128
         ;decompress .PCX picture to active page
         mov      edi,[aPage]
         xor      ebx,ebx
         ;calc size of picture (not compressed) = width x height
         movzx    eax,[header.width]
         movzx    edx,[header.height]
         imul     edx
         mov      edx,eax
         ;let's decompress picture
         @@PCX_decode:
         mov      al,[esi]
         inc      esi
         mov      ah,al
         ;check if byte is compressed
         and      ah,0c0h
         cmp      ah,0c0h
         jne      @@PCX_not_compressed
         ;byte is compressed... decompress it
         and      al,03fh
         mov      cl,al
         mov      al,byte ptr [esi]
         inc      esi
         jmp      @@PCX_draw
         ;byte is not compressed
         @@PCX_not_compressed:
         mov     cl,1
         ;draw pcx packet
         @@PCX_draw:
         mov     [edi],al
         inc     edi
         inc     ebx
         dec     cl
         jnz     @@PCX_draw
         cmp     ebx,edx
         jbe     @@PCX_decode
         RET
         load_PCX_error:
load_PCX ENDP

CODE ENDS

DATA SEGMENT DWORD PUBLIC 'DATA'

PCXheader STRUC
          version           db ?
          sX                dw ?
          sY                dw ?
          width             dw ?
          height            dw ?
PCXheader ENDS

vSegment      equ       0a0000h
RAWsize       equ       0ffffh
pPhysical     equ       0
pVirtual      equ       1
pVirtual_Tmp  equ       2
header        PCXheader ?
activePage    db        ?
Color         dd        ?
PCXsize       dd        ?
vPage         dd        ?;virtaul page, mainly used for screen manipulations
vPage_Tmp     dd        ?;second virtaul page used for some temporary stuff
aPage         dd        ?
PCXpage       dd        ?

DATA ENDS
