;;
;                                                                          ;
; Name       : Set_Palette                                                 ;
; Description: Set palette                                                 ;
; Input      : ESI offset to 768 long palette structure                    ;
;            : ECX number of colors to set                                 ;
; Output     : /                                                           ;
; Uses       :                                                             ;
;                                                                          ;
;;
            align 4
Set_Palette proc near
            mov         dx,3c8h
            xor         al,al
            out         dx,al
            inc         dx
            @@Set_Palette_Loop:
            mov         al,[esi]
            out         dx,al
            inc         esi
            dec         ecx
            jnz         @@Set_Palette_Loop
            ret
Set_Palette endp

;;
;                                                                          ;
; Name       : Wait_Retrace                                                ;
; Description: Wait retrace                                                ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : (E)AX,(E)DX                                                 ;
;                                                                          ;
;;
             align 4
Wait_Retrace proc near
             mov        dx,3dah
             @@Wait_Retrace_1:
             in         al,dx
             and        al,8
             jnz        @@Wait_Retrace_1

             mov        eax,[VERTICAL_RETRACE]
             or         eax,eax
             jz         @@No_Vertical_Retrace

             @@Wait_Retrace_2:
             in         al,dx
             and        al,8
             jz         @@Wait_Retrace_2

             @@No_Vertical_Retrace:

             ret

Wait_Retrace endp

