;;
;                                                                          ;
; Name       : Multiply_Matrix                                             ;
; Description: Multiply matrix for rotating                                ;
; Input      : X,Y,Z angle                                                 ;
; Output     : M11-M33 (M41,M42,M43)                                       ;
; Uses       : EAX,EBX,ECX,EDX,ESI,EDI                                     ;
;                                                                          ;
;;
Multiply_Matrix PROC NEAR

                mov     esi,[VAngle_X]
                mov     edi,[VAngle_Y]
                mov     ecx,[VAngle_Z]

                ;M11=cy*cz
                mov     eax,[Cos+edi];cy
                mov     ebx,[Cos+ecx];cz
                imul    ebx
                shrd    eax,edx,16
                mov     [M11],eax

                ;M12=cy*sz
                mov     eax,[Cos+edi];cy
                neg     eax
                mov     ebx,[Sin+ecx];sz
                imul    ebx
                shrd    eax,edx,16
                mov     [M12],eax

                ;M13=sy
                mov     eax,[Sin+edi];sy
                mov     [M13],eax

                ;M21=cx*sz+sx*sy*cz
                mov     eax,[Cos+esi];cx
                mov     ebx,[Sin+ecx];sz
                imul    ebx
                shrd    eax,edx,16
                mov     [M21],eax
                mov     eax,[Sin+esi];sx
                mov     ebx,[Sin+edi];sy
                imul    ebx
                shrd    eax,edx,16
                mov     ebx,[Cos+ecx];cz
                imul    ebx
                shrd    eax,edx,16
                add     [M21],eax

                ;M22=cx*cz-sx*sy*sz
                mov     eax,[Cos+esi];cx
                mov     ebx,[Cos+ecx];cz
                imul    ebx
                shrd    eax,edx,16
                mov     [M22],eax
                mov     eax,[Sin+esi];sx
                mov     ebx,[Sin+edi];sy
                imul    ebx
                shrd    eax,edx,16
                mov     ebx,[Sin+ecx];sz
                imul    ebx
                shrd    eax,edx,16
                sub     [M22],eax

                ;M23=-sx*cy
                mov     eax,[Sin+esi];sx
                neg     eax
                mov     ebx,[Cos+edi];cy
                imul    ebx
                shrd    eax,edx,16
                mov     [M23],eax

                ;M31=sx*sz-cx*cz*sy
                mov     eax,[Sin+esi];sx
                mov     ebx,[Sin+ecx];sz
                imul    ebx
                shrd    eax,edx,16
                mov     [M31],eax
                mov     eax,[Cos+esi];cx
                mov     ebx,[Cos+ecx];cz
                imul    ebx
                shrd    eax,edx,16
                mov     ebx,[Sin+edi];sy
                imul    ebx
                shrd    eax,edx,16
                sub     [M31],eax

                ;M32=sx*cz+cx*sz*sy
                mov     eax,[Sin+esi];sx
                mov     ebx,[Cos+ecx];cz
                imul    ebx
                shrd    eax,edx,16
                mov     [M32],eax
                mov     eax,[Cos+esi];cx
                mov     ebx,[Sin+ecx];sz
                imul    ebx
                shrd    eax,edx,16
                mov     ebx,[Sin+edi];sy
                imul    ebx
                shrd    eax,edx,16
                add     [M32],eax

                ;M33=cx*cy
                mov     eax,[Cos+esi];cx
                mov     ebx,[Cos+edi];cy
                imul    ebx
                shrd    eax,edx,16
                mov     [M33],eax

                mov     eax,[ROTATE_7MULS_ALGO] ;if we are using 7 muls version
                or      eax,eax                 ;we have to make some extra
                jz      @@Multiply_Matrix_End   ;calculations

                ;M41 = M11 * M12
                mov     eax,[M11]
                imul    [M12]
                shrd    eax,edx,16
                mov     [M41],eax

                ;M42 = M21 * M22
                mov     eax,[M21]
                imul    [M22]
                shrd    eax,edx,16
                mov     [M42],eax

                ;M43 = M31 * M32
                mov     eax,[M31]
                imul    [M32]
                shrd    eax,edx,16
                mov     [M43],eax

                @@Multiply_Matrix_End:

                RET

Multiply_Matrix ENDP


;;
;                                                                          ;
; Name       : Rotate_VArray                                               ;
; Description: Rotate vertices, normals, face naormals                     ;
; Input      : Offset of vertices, normals, face normals                   ;
; Output     : Rotated vertices, normals, face normals                     ;
; Uses       : EAX,EBX,ECX,EDX                                             ;
;                                                                          ;
;;
Rotate_VArray PROC NEAR
              ;=== ROTATE VERTICES ===
              mov       eax,[ROTATE_VERTICES]
              or        eax,eax
              jz        @@Rotate_NArray

              mov       esi,Object_3D.OffSet_VArray
              mov       edi,Object_3D.OffSet_VArray_Rotated
              movzx     ecx,[Object_3D.Number_Of_Vertices]

              mov       eax,[ROTATE_9MULS_ALGO]
              or        eax,eax
              jz        @@VArray_9MULS_Not

              call      Rotate_9MULS

              @@VArray_9MULS_Not:

              mov       eax,[ROTATE_7MULS_ALGO]
              or        eax,eax
              jz        @@VArray_7MULS_Not

              call      Rotate_7MULS

              @@VArray_7MULS_Not:
              ;=== ROTATE VERTEX NORMALS ===
              @@Rotate_NArray:

              mov       eax,[ROTATE_VERTEX_NORMALS]
              or        eax,eax
              jz        @@Rotate_Face_Normals

              mov       esi,Object_3D.OffSet_NArray
              mov       edi,Object_3D.OffSet_NArray_Rotated
              movzx     ecx,[Object_3D.Number_Of_Vertices]

              mov       eax,[ROTATE_9MULS_ALGO]
              or        eax,eax
              jz        @@NArray_9MULS_Not

              call      Rotate_9MULS

              @@NArray_9MULS_Not:

              mov       eax,[ROTATE_7MULS_ALGO]
              or        eax,eax
              jz        @@NArray_7MULS_Not

              call      Rotate_7MULS

              @@NArray_7MULS_Not:

              ;=== ROTATE FACE NORMALS ===
              @@Rotate_Face_Normals:

              mov       eax,[ROTATE_FACE_NORMALS]
              or        eax,eax
              jz        @@Rotate_End

              movzx     ecx,[Object_3D.Number_Of_Faces]
              mov       esi,Object_3D.OffSet_FNormals
              mov       edi,Object_3D.OffSet_FNormals_Rotated

              mov       eax,[ROTATE_9MULS_ALGO]
              or        eax,eax
              jz        @@FNormals_9MULS_Not

              call      Rotate_9MULS

              @@FNormals_9MULS_Not:

              mov       eax,[ROTATE_7MULS_ALGO]
              or        eax,eax
              jz        @@FNormals_7MULS_Not

              call      Rotate_7MULS

              @@FNormals_7MULS_Not:

              @@Rotate_End:

              RET

Rotate_VArray ENDP

;;
;                                                                          ;
; Name       : Rotate_9MULS                                                ;
; Description: Rotate vertices using 9 muls algorithm                      ;
; Input      : ECX = number of times to loop                               ;
;              ESI = source array                                          ;
;              EDI = destination array (rotated array)                     ;
; Output     : Rotated vertices or normals or face normals                 ;
; Uses       : EAX,EBX,ECX,EDX                                             ;
;                                                                          ;
;;
Rotate_9MULS proc near

             @@Rotate_Loop_9MULS:
             ;X' = X * M11 + Y * M12 + Z * M13
             mov       eax,[esi]
             imul      [M11]
             shrd      eax,edx,16
             mov       ebx,eax

             mov       eax,[esi+4]
             imul      [M12]
             shrd      eax,edx,16
             add       ebx,eax

             mov       eax,[esi+8]
             imul      [M13]
             shrd      eax,edx,16
             add       eax,ebx
             mov       [edi],eax

             ;Y' = X * M21 + Y * M22 + Z * M23
             mov       eax,[esi]
             imul      [M21]
             shrd      eax,edx,16
             mov       ebx,eax

             mov       eax,[esi+4]
             imul      [M22]
             shrd      eax,edx,16
             add       ebx,eax

             mov       eax,[esi+8]
             imul      [M23]
             shrd      eax,edx,16
             add       eax,ebx
             mov       [edi+4],eax

             ;Z' = X * M31 + Y * M32 + Z * M33
             mov       eax,[esi]
             imul      [M31]
             shrd      eax,edx,16
             mov       ebx,eax

             mov       eax,[esi+4]
             imul      [M32]
             shrd      eax,edx,16
             add       ebx,eax

             mov       eax,[esi+8]
             imul      [M33]
             shrd      eax,edx,16
             add       eax,ebx
             mov       [edi+8],eax

             add       esi,12
             add       edi,12

             dec       ecx
             jnz       @@Rotate_Loop_9MULS

             ret
Rotate_9MULS endp


;;
;                                                                          ;
; Name       : Rotate_7MULS                                                ;
; Description: Rotate vertices using 7 muls algorithm                      ;
; Input      : ECX = number of times to loop                               ;
;              ESI = source array                                          ;
;              EDI = destination array (rotated array)                     ;
; Output     : Rotated vertices or normals or face normals                 ;
; Uses       : EAX,EBX,ECX,EDX                                             ;
;                                                                          ;
;;
             ALIGN 4
Rotate_7MULS PROC NEAR

             @@Rotate_Loop:
             ;make fixed points
             mov       eax,[esi]
             sal       eax,16
             mov       [X],eax

             mov       eax,[esi+4]
             sal       eax,16
             mov       [Y],eax

             mov       eax,[esi+8]
             sal       eax,16
             mov       [Z],eax

             ;XY = X * Y
             mov       eax,[X]
             imul      [Y]
             shrd      eax,edx,16
             mov       [XY],eax

             ;X' = (M11 + Y) * (M12 + X) - M41 - XY + M13 * Z
             mov       eax,[Y]
             add       eax,[M11]
             mov       ebx,[X]
             add       ebx,[M12]
             imul      ebx
             shrd      eax,edx,16

             sub       eax,[M41]
             sub       eax,[XY]
             mov       ebx,eax

             mov       eax,[Z]
             imul      [M13]
             shrd      eax,edx,16
             add       eax,ebx
             shrd      eax,edx,16
             mov       [edi],eax

             ;Y' = (M21 + Y) * (M22 + X) - M42 - XY + M23 * Z
             mov       eax,[Y]
             add       eax,[M21]
             mov       ebx,[X]
             add       ebx,[M22]
             imul      ebx
             shrd      eax,edx,16

             sub       eax,[M42]
             sub       eax,[XY]
             mov       ebx,eax

             mov       eax,[Z]
             imul      [M23]
             shrd      eax,edx,16
             add       eax,ebx
             shrd      eax,edx,16
             mov       [edi+4],eax

             ;Z' = (M31 + Y) * (M32 + X) - M43 - XY + M33 * Z
             mov       eax,[Y]
             add       eax,[M31]
             mov       ebx,[X]
             add       ebx,[M32]
             imul      ebx
             shrd      eax,edx,16

             sub       eax,[M43]
             sub       eax,[XY]
             mov       ebx,eax

             mov       eax,[Z]
             imul      [M33]
             shrd      eax,edx,16
             add       eax,ebx
             shrd      eax,edx,16
             mov       [edi+8],eax

             add       esi,12
             add       edi,12

             dec       ecx
             jnz       @@Rotate_Loop

             RET
Rotate_7MULS ENDP




;;
;                                                                          ;
; Name       : Project_VArray                                              ;
; Description: Make projection -> Transform vertices from 3D -> 2D         ;
; Input      : Offset of vertices                                          ;
; Output     : Projected vertices                                          ;
; Uses       :                                                             ;
;                                                                          ;
;;
               align 4
Project_VArray proc near

               mov      esi,Object_3D.OffSet_VArray_Rotated
               mov      edi,Object_3D.OffSet_VArray_Projected
               movzx    ecx,[Object_3D.Number_Of_Vertices]

               @@Project_VArray:
               ;X_2D = (X_3D * EYE_DISTANCE) / (Z_3D + Z_OFFSET)
               mov      eax,[esi]
               imul     [Object_3D.Eye_Distance]
               mov      ebx,[esi+8]
               add      ebx,[Object_3D.Z_OffSet]
               or       ebx,ebx
               jz       @@Project_Zero_X
               cdq
               idiv     ebx
               @@Project_Zero_X:
               add      eax,[SCREEN_HALF_WIDTH]
               mov      [edi],eax
               ;Y_2D = (Y_3D * EYE_DISTANCE) / (Z_3D + Z_OFFSET)
               mov      eax,[esi+4]
               imul     [Object_3D.Eye_Distance]
               or       ebx,ebx
               jz       @@Project_Zero_Y
               cdq
               idiv     ebx
               @@Project_Zero_Y:
               add      eax,[SCREEN_HALF_HEIGHT]
               mov      [edi+4],eax

               add      esi,12
               add      edi,8

               dec      ecx
               jnz      @@Project_VArray

               ret

Project_VArray endp






X dd ?
Y dd ?
Z dd ?