;;
;                                                                          ;
; Name       : Sort_Y                                                      ;
; Description: Sort Y coordinates of triangle                              ;
; Input      : Y1,Y2,Y3 (C1,C2,C3,MX1,MX2,MX3,MY1,MY2,MY3)                 ;
; Output     : Y1,Y2,Y3 sorted (Y1=min,y3=max)                             ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
        align 4
Sort_Y proc near

       mov       eax,[LIMIT_FLAT]       ;check if we need to sort
       or        eax,eax
       jz        @@Sort_Y3              ;no sort at all

       mov       eax,[Y1]               ;check Y1 <--> Y2
       cmp       eax,[Y2]
       jle       @@Sort_Y1
       xchg      eax,[Y2]               ;swap X and Y positions
       mov       [Y1],eax
       mov       eax,[X1]
       xchg      eax,[X2]
       mov       [X1],eax

       mov       eax,[Z_BUFFER]         ;if we used z-buffer sorting algo
       or        eax,eax                ;we have to swap Z values too
       jz        @@SortY_Gouraud1
       mov       eax,[Z1]
       xchg      eax,[Z2]
       mov       [Z1],eax

       @@SortY_Gouraud1:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture1
       mov       eax,[C1]
       xchg      eax,[C2]
       mov       [C1],eax

       @@SortY_Texture1:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jz        @@Sort_Y1
       mov       eax,[MX1]
       xchg      eax,[MX2]
       mov       [MX1],eax
       mov       eax,[MY1]
       xchg      eax,[MY2]
       mov       [MY1],eax

       @@Sort_Y1:

       mov       eax,[Y1]               ;check Y1 <--> Y3
       cmp       eax,[Y3]
       jle       @@Sort_Y2
       xchg      eax,[Y3]               ;swap X and Y positions
       mov       [Y1],eax
       mov       eax,[X1]
       xchg      eax,[X3]
       mov       [X1],eax

       mov       eax,[Z_BUFFER]         ;if we used z-buffer sorting algo
       or        eax,eax                ;we have to swap Z values too
       jz        @@SortY_Gouraud2
       mov       eax,[Z1]
       xchg      eax,[Z3]
       mov       [Z1],eax

       @@SortY_Gouraud2:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture2
       mov       eax,[C1]
       xchg      eax,[C3]
       mov       [C1],eax

       @@SortY_Texture2:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jz        @@Sort_Y2
       mov       eax,[MX1]
       xchg      eax,[MX3]
       mov       [MX1],eax
       mov       eax,[MY1]
       xchg      eax,[MY3]
       mov       [MY1],eax


       @@Sort_Y2:

       mov       eax,[Y2]               ;check Y2 <--> Y3
       cmp       eax,[Y3]
       jle       @@Sort_Y3
       xchg      eax,[Y3]               ;swap X and Y positions
       mov       [Y2],eax
       mov       eax,[X2]
       xchg      eax,[X3]
       mov       [X2],eax

       mov       eax,[Z_BUFFER]         ;if we used z-buffer sorting algo
       or        eax,eax                ;we have to swap Z values too
       jz        @@SortY_Gouraud3
       mov       eax,[Z2]
       xchg      eax,[Z3]
       mov       [Z2],eax

       @@SortY_Gouraud3:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture3
       mov       eax,[C2]
       xchg      eax,[C3]
       mov       [C2],eax

       @@SortY_Texture3:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jz        @@Sort_Y3
       mov       eax,[MX2]
       xchg      eax,[MX3]
       mov       [MX2],eax
       mov       eax,[MY2]
       xchg      eax,[MY3]
       mov       [MY2],eax

       @@Sort_Y3:

       ret

Sort_Y endp


;;
;                                                                          ;
; Name       : Sort_CW                                                     ;
; Description: Sort Y coordinates of triangle in clockwise order           ;
; Input      : Y1,Y2,Y3                                                    ;
; Output     : Y1,Y2,Y3 sorted in clockwise order                          ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
;*Kalms* If p1 is uppermost, then   p1 p2 p3
;*Kalms* if p2 is uppermost, then p2 p3 p1
;*Kalms* if p3 is uppermost, then p3 p1 p2
;*Kalms* As you can see, the vertices are "rotated" instead of "swapped".
;-> *Kalms* ohh.. ok
;*Kalms* when you compare the vertices, do this: <no, I won't write code this
;        time :)>
;*Kalms* if (y1 < y2)  y1 less
;*Kalms* if (y1 > y2) y2 less
;-> *Kalms* ok.. it's easy from now on.. :)
;*Kalms* if (y1 == y2   and   (x1 < x2))  y1 less
;*Kalms* if (y1 == y2    and   (x1 > x2)) y2 less
;*Kalms* That's it I think.
;*Kalms* :)
;-> *Kalms* oh.. u r dealing with x's also..
Sort_CW proc near

        ret

Sort_CW endp

;;
;                                                                          ;
; Name       : Sort_CCW                                                    ;
; Description: Sort Y coordinates of triangle in counter clockwise order   ;
; Input      : Y1,Y2,Y3                                                    ;
; Output     : Y1,Y2,Y3 sorted in counter clockwise order                  ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
Sort_CCW proc near

        ret

Sort_CCW endp


