                        align 4
Texture_Triangle_Filler proc near

                        call       Sort_Y               ;sort y coordinates
                        call       Clip_Y_All

                        sal        [X1],16              ;make 16:16 fixed points
                        sal        [X2],16
                        sal        [X3],16
                        sal        [MX1],8              ;make 8:8 fixed points
                        sal        [MX2],8
                        sal        [MX3],8
                        sal        [MY1],8
                        sal        [MY2],8
                        sal        [MY3],8
                        mov        eax,[Y2]
                        sub        eax,[Y1]
                        or         eax,eax
                        jz         @@No_Upper_Texture_Triangle
                        ;=== RIGHT X ADDER ===
                        mov        eax,[X3]             ;calculate longer edge -
                        sub        eax,[X1]             ;right edge
                        mov        esi,[Y3]             ;x adder
                        sub        esi,[Y1]
                        or         esi,esi
                        jz         @@No_Texture_Triangle
                        cdq
                        idiv       esi
                        mov        [X_Adder_Right],eax  ;(x3 - x1) / (y3 - y1)
                        ;=== RIGHT MAPPING X ADDER ===
                        mov        eax,[MX3]            ;calculate longer edge -
                        sub        eax,[MX1]            ;right edge
                        cdq                             ;mapping x adder
                        idiv       esi
                        mov        [T_Adder_Right_X],eax;(mx3 - mx1) / (y3 - y1)
                        ;=== RIGHT MAPPING Y ADDER ===
                        mov        eax,[MY3]            ;calculate longer edge -
                        sub        eax,[MY1]            ;right edge
                        cdq                             ;mapping y adder
                        idiv       esi
                        mov        [T_Adder_Right_Y],eax;(my3 - my1) / (y3 - y1)
                        ;=== LEFT X ADDER ===
                        mov        eax,[X2]             ;calculate shorter edge -
                        sub        eax,[X1]             ;left edge
                        mov        esi,[Y2]
                        sub        esi,[Y1]
                        cdq                             ;x adder
                        idiv       esi
                        mov        [X_Adder_Left],eax   ;(x2 - x1) / (y2 - y1)
                        ;=== LEFT MAPPING X ADDER ===
                        mov        eax,[MX2]            ;calculate shorter edge -
                        sub        eax,[MX1]            ;left edge
                        cdq                             ;mapping x adder
                        idiv       esi
                        mov        [T_Adder_Left_X],eax ;(mx2 - mx1) / (y2 - y1)
                        ;=== LEFT MAPPING Y ADDER ===
                        mov        eax,[MY2]            ;calculate shorter edge -
                        sub        eax,[MY1]            ;left edge
                        cdq                             ;mapping y adder
                        idiv       esi
                        mov        [T_Adder_Left_Y],eax ;(my2 - my1) / (y2 - y1)
                        ;=== CALC. SCREEN OFFSET ===
                        mov        ebp,[Y1]             ;calculate offset on
                        lea        ebp,[ebp+ebp*4]      ;screen to draw
                        shl        ebp,6                ;NOTE: only Y position
                        lea        edi,[Virtual_Screen] ;we add X in procedure
                        add        edi,ebp              ;Draw_Texture_Segment
                        ;=== SETUP STARTING VALUES ===
                        mov        ebx,[X1]             ;starting x values
                        mov        edx,ebx
                        mov        eax,[MX1]            ;mapping positions
                        mov        [Mapping_Left_X],eax
                        mov        [Mapping_Right_X],eax
                        mov        eax,[MY1]
                        mov        [Mapping_Left_Y],eax
                        mov        [Mapping_Right_Y],eax
                        ;=== CALC. U AND V ===
                        push       ebx edx esi          ;save starting values
                        push       [Mapping_Left_X]
                        push       [Mapping_Left_Y]
                        push       [Mapping_Right_X]
                        push       [Mapping_Right_Y]

                        @@Calc_UV:
                        add        ebx,[X_Adder_Left]   ;we have to do it
                        add        edx,[X_Adder_Right]  ;at longest hline
                        mov        eax,[T_Adder_Right_X];the longest line is
                        add        [Mapping_Right_X],eax;at the bottom of
                        mov        eax,[T_Adder_Right_Y];1st triangle so we
                        add        [Mapping_Right_Y],eax;have to 'move' there
                        mov        eax,[T_Adder_Left_X]
                        add        [Mapping_Left_X],eax
                        mov        eax,[T_Adder_Left_Y]
                        add        [Mapping_Left_Y],eax
                        dec        esi
                        jnz        @@Calc_UV

                        mov        ecx,edx              ;lenght of hline
                        mov        cx,0ffffh            ;where we gonna
                        sub        ecx,ebx              ;calc. U and V
                        sar        ecx,16
                        inc        ecx

                        mov        eax,[Mapping_Right_X];calc. U
                        sub        eax,[Mapping_Left_X]
                        or         ecx,ecx
                        jz         @@ZeroU_1
                        cdq
                        idiv       ecx
                        @@ZeroU_1:
                        mov        [U],eax

                        mov        eax,[Mapping_Right_Y];calc. V
                        sub        eax,[Mapping_Left_Y]
                        or         ecx,ecx
                        jz         @@ZeroV_1
                        cdq
                        idiv       ecx
                        @@ZeroV_1:
                        mov        [V],eax

                        pop        [Mapping_Right_Y]    ;pop staring values
                        pop        [Mapping_Right_X]
                        pop        [Mapping_Left_Y]
                        pop        [Mapping_Left_X]
                        pop        esi edx ebx

                        mov        ebp,[X_Adder_Left]   ;compare both adders
                        cmp        ebp,[X_Adder_Right]  ;to see which procedure
                        jg         @@Texture_1          ;we have to call
                        call       Draw_Texture_Segment ;if X_Adder_Left <
                        jmp        @@Texture_2          ;X_Adder_Right then
                        @@Texture_1:                    ;we draw from ebx to edx
                        call       Draw_Texture_Segment1;otherwise from edx to ebx1
                        @@Texture_2:

                        mov        esi,[Y3]             ;check if there is
                        sub        esi,[Y2]             ;2nd semgnet of triangle
                        or         esi,esi
                        jz         @@No_Texture_Triangle;if not then exit proc
                        ;=== UPDATE LEFT X ADDER ===
                        push       edx                  ;idiv destroy edx which
                        mov        eax,[X3]             ;we need for x positions
                        sub        eax,[X2]
                        cdq
                        idiv       esi
                        mov        [X_Adder_Left],eax   ;(x3 - x2) / (y3 - y2)
                        ;=== UPDATE LEFT MAPPING X ADDER ===
                        mov        eax,[MX3]
                        sub        eax,[MX2]
                        cdq
                        idiv       esi
                        mov        [T_Adder_Left_X],eax ;(mx3 - mx2) / (y3 - y2)
                        ;=== UPDATE LEFT MAPPING Y ADDER ===
                        mov        eax,[MY3]
                        sub        eax,[MY2]
                        cdq
                        idiv       esi
                        mov        [T_Adder_Left_Y],eax ;(my3 - my2) / (y3 - y2)

                        pop        edx                  ;pop x position
                        ;=== CALC. SCREEN OFFSET
                        mov        ebp,[Y2]
                        lea        ebp,[ebp+ebp*4]
                        shl        ebp,6
                        lea        edi,[Virtual_Screen]
                        add        edi,ebp
                        ;=== UPDATE STARTING VALUES
                        mov        ebx,[X2]             ;x position
                        mov        eax,[MX2]
                        mov        [Mapping_Left_X],eax ;mapping x
                        mov        eax,[MY2]
                        mov        [Mapping_Left_Y],eax ;mapping y

                        cmp        ebx,edx              ;compare both x positions
                        jg         @@Texture_3          ;to see which procedure
                                                        ;we have to call
                        call       Draw_Texture_Segment ;if ebx < edx then we
                        jmp        @@Texture_4          ;draw from ebx to edx
                        @@Texture_3:                    ;otherwise from edx to ebx
                        call       Draw_Texture_Segment1
                        @@Texture_4:

                        ret

                        @@No_Upper_Texture_Triangle:    ;y1 = y2
                        ;=== X LEFT ADDER ===
                        mov        eax,[X3]             ;left edge
                        sub        eax,[X1]             ;x adder
                        mov        esi,[Y3]             ;since y1=y2 we need
                        sub        esi,[Y1]             ;to calc this only once
                        or         esi,esi
                        jz         @@No_Texture_Triangle
                        cdq
                        idiv       esi
                        mov        [X_Adder_Left],eax   ;(x3 - x1) / (y3 - y1)
                        ;=== MAPPING X LEFT ADDER ===
                        mov        eax,[MX3]            ;left edge
                        sub        eax,[MX1]            ;mapping x adder
                        cdq
                        idiv       esi
                        mov        [T_Adder_Left_X],eax ;(mx3 - mx1) / (y3 - y1)
                        ;=== MAPPING Y LEFT ADDER ===
                        mov        eax,[MY3]            ;left edge
                        sub        eax,[MY1]            ;mapping y adder
                        cdq
                        idiv       esi
                        mov        [T_Adder_Left_Y],eax ;(my3 - my1) / (y3 - y1)
                        ;=== X RIGHT ADDER ===
                        mov        eax,[X3]             ;right edge
                        sub        eax,[X2]             ;x adder
                        cdq
                        idiv       esi
                        mov        [X_Adder_Right],eax  ;(x3 - x2) / (y3 - y2)
                        ;=== MAPPING X LEFT ADDER
                        mov        eax,[MX3]            ;right edge
                        sub        eax,[MX2]            ;mapping x adder
                        cdq
                        idiv       esi
                        mov        [T_Adder_Right_X],eax;(mx3 - mx2) / (y3 - y2)
                        ;=== MAPPING Y LEFT ADDER
                        mov        eax,[MY3]            ;right edge
                        sub        eax,[MY2]            ;mapping y adder
                        cdq
                        idiv       esi
                        mov        [T_Adder_Right_Y],eax;(my3 - my2) / (y3 - y2)
                        ;=== CALC OFFSET ON SCREEN ===
                        mov        ebp,[Y1]             ;calculate offset on
                        lea        ebp,[ebp+ebp*4]      ;screen to draw
                        shl        ebp,6                ;NOTE: only Y position
                        lea        edi,[Virtual_Screen] ;we add X in procedure
                        add        edi,ebp              ;Draw_Texture_Segment
                        ;=== SETUP STARTING VALUES ===
                        mov        ebx,[X1]             ;setup starting values
                        mov        edx,[X2]             ;x positions
                        mov        eax,[MX2]            ;and
                        mov        [Mapping_Right_X],eax;mapping positions
                        mov        eax,[MY2]
                        mov        [Mapping_Right_Y],eax
                        mov        eax,[MX1]
                        mov        [Mapping_Left_X],eax
                        mov        eax,[MY1]
                        mov        [Mapping_Left_Y],eax
                        ;=== CALC U AND V ===
                        push       edx                  ;idiv suxx.. and

                        mov        ecx,edx              ;lenght of hline
                        mov        cx,0ffffh
                        sub        ecx,ebx
                        sar        ecx,16
                        inc        ecx

                        mov        eax,[Mapping_Right_X];calc. U
                        sub        eax,[Mapping_Left_X]
                        or         ecx,ecx
                        jz         @@ZeroU_2
                        cdq
                        idiv       ecx
                        @@ZeroU_2:
                        mov        [U],eax

                        mov        eax,[Mapping_Right_Y];calc. V
                        sub        eax,[Mapping_Left_Y]
                        or         ecx,ecx
                        jz         @@ZeroV_2
                        cdq
                        idiv       ecx
                        @@ZeroV_2:
                        mov        [V],eax

                        pop        edx                  ;idiv suxx

                        cmp        ebx,edx              ;compare both x positions
                        jg         @@Texture_5          ;to see which procedure we have to call
                        call       Draw_Texture_Segment ;if ebx < edx then we
                        jmp        @@Texture_6          ;draw from ebx to edx
                        @@Texture_5:                    ;otherwise from edx to ebx
                        call       Draw_Texture_Segment1
                        @@Texture_6:

                        @@No_Texture_Triangle:

                        ret                             ;return

Texture_Triangle_Filler endp



;;
;                                                                          ;
; Name       : Draw_Texture_Segment                                        ;
; Description: Draw one segment of Texture triangle                        ;
; Input      : EDI = screen offset (row number)                            ;
;              EBX = start x position                                      ;
;              EDX = end x position                                        ;
;              ESI = height of triangle                                    ;
;              Mapping_Left_X,Mapping_Left_Y                               ;
;              Mapping_Right_X,Mapping_Right_Y                             ;
; Output     : /                                                           ;
; Uses       :                                                             ;
;                                                                          ;
;;
                     align 4
Draw_Texture_Segment proc near
                      mov        ebp,Object_3D.OffSet_Texture

                      @@Draw_Texture_Segment_Loop:

                      add        ebx,[X_Adder_Left]
                      add        edx,[X_Adder_Right]

                      mov        eax,[T_Adder_Left_X]
                      add        [Mapping_Left_X],eax
                      mov        eax,[T_Adder_Left_Y]
                      add        [Mapping_Left_Y],eax

                      mov        eax,[T_Adder_Right_X]
                      add        [Mapping_Right_X],eax
                      mov        eax,[T_Adder_Right_Y]
                      add        [Mapping_Right_Y],eax

                      push       ebx edx esi edi

                      mov        eax,ebx
                      call       Clip_X
                      mov        ebx,eax
                      mov        eax,edx
                      call       Clip_X
                      mov        edx,eax
                      mov        ecx,ebx
                      sar        ecx,16
                      add        edi,ecx                ;starting x position

                      mov        ecx,edx
                      mov        cx,0ffffh
                      sub        ecx,ebx
                      sar        ecx,16
                      inc        ecx                    ;length of hline

                      mov        ebx,[Mapping_Left_X]   ;starting mapping
                      mov        edx,[Mapping_Left_Y]   ;positions
                      or         ecx,ecx
                      jz         @@No_Texture_HLine

                      neg        ecx
                      sub        edi,ecx
                      mov        esi,[V]

                      @@Texture_Inner_Loop:             ;texture inner loop
                      add        ebx,[U]
                      add        edx,esi
                      xor        eax,eax
                      mov        ah,dh                  ;calc. offset in
                      mov        al,bh                  ;texture
                      mov        al,[ebp+eax]
                      mov        [edi+ecx],al
                      inc        ecx
                      jnz        @@Texture_Inner_Loop

                      @@No_Texture_HLine:
                      pop        edi esi edx ebx

                      add        edi,320

                      dec        esi
                      jnz        @@Draw_Texture_Segment_Loop

                      ret                               ;return

Draw_Texture_Segment endp






;;
;                                                                          ;
; Name       : Draw_Texture_Segment1                                       ;
; Description: Draw one segment of Texture triangle                        ;
; Input      : EDI = screen offset (row number)                            ;
;              EDX = start x position                                      ;
;              EBX = end x position                                        ;
;              ESI = height of triangle                                    ;
;              Mapping_Left_X,Mapping_Left_Y                               ;
;              Mapping_Right_X,Mapping_Right_Y                             ;
; Output     : /                                                           ;
; Uses       :                                                             ;
;                                                                          ;
;;
                      align 4
Draw_Texture_Segment1 proc near
                      mov        ebp,Object_3D.OffSet_Texture
                      @@Draw_Texture_Segment_Loop1:

                      add        ebx,[X_Adder_Left]
                      add        edx,[X_Adder_Right]

                      mov        eax,[T_Adder_Left_X]
                      add        [Mapping_Left_X],eax
                      mov        eax,[T_Adder_Left_Y]
                      add        [Mapping_Left_Y],eax

                      mov        eax,[T_Adder_Right_X]
                      add        [Mapping_Right_X],eax
                      mov        eax,[T_Adder_Right_Y]
                      add        [Mapping_Right_Y],eax

                      push       ebx edx esi edi

                      mov        eax,ebx
                      call       Clip_X
                      mov        ebx,eax
                      mov        eax,edx
                      call       Clip_X
                      mov        edx,eax

                      mov        ecx,edx
                      sar        ecx,16
                      add        edi,ecx                ;starting x position

                      mov        ecx,ebx
                      mov        cx,0ffffh
                      sub        ecx,edx
                      sar        ecx,16
                      inc        ecx                    ;length of hline

                      mov        ebx,[Mapping_Right_X]  ;starting mapping
                      mov        edx,[Mapping_Right_Y]  ;positions

                      or         ecx,ecx
                      jz         @@No_Texture_HLine1

                      neg        ecx
                      sub        edi,ecx
                      mov        esi,[V]
                      @@Texture_Inner_Loop1:            ;texture inner loop
                      add        ebx,[U]
                      add        edx,esi
                      xor        eax,eax
                      mov        ah,dh                  ;calc. offset in
                      mov        al,bh                  ;texture
                      mov        al,[ebp+eax]
                      mov        [edi+ecx],al
                      inc        ecx
                      jnz        @@Texture_Inner_Loop1

                      @@No_Texture_HLine1:

                      pop        edi esi edx ebx

                      add        edi,320

                      dec        esi
                      jnz        @@Draw_Texture_Segment_Loop1

                      ret                               ;return

Draw_Texture_Segment1 endp




