;============================ CODE = CODE = CODE ============================;

CODE SEGMENT DWORD PUBLIC 'CODE'
ASSUME cs:CODE,ds:DATA

;;
;                                                                          ;
; Name       : draw_fTriangle                                              ;
; Description: draw flat triangle using 2 or 3 divs                        ;
; Input      : X1,Y1,X2,Y2,X3,Y3                                           ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fTriangle PROC NEAR
               ;sory y positions y1<y2<y3
               call     Sort_Y              ;sort y coordinates
               ;clip y positions
               call     Clip_Y_All
               ;make 16.16 fixed points
               sal      [X1],16
               sal      [X2],16
               sal      [X3],16
               ;calc right edge - longer edge - p1 <-> p3
               mov      eax,[X3]            ;calculate longer edge -
               sub      eax,[X1]            ;right edge
               mov      esi,[Y3]
               sub      esi,[Y1]
               or       esi,esi
               jz       @@NO_fTriangle
               cdq
               idiv     esi
               mov      ebp,eax             ;(x3 - x1) / (y3 - y1)
               ;calc screen offset
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_fSegment
               ;calc shorter edge - left edge - p1 <-> p2
               mov      eax,[X2]            ;calculate shorter edge -
               sub      eax,[X1]            ;left edge
               mov      esi,[Y2]
               sub      esi,[Y1]
               or       esi,esi
               jz       @@NO_upper_fTriangle
               cdq
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x2 - x1) / (y2 - y1)
               ;setup starting values
               mov      ebx,[X1]
               mov      edx,ebx
               ;cmp both adders
               cmp      eax,ebp             ;to see which procedure
               jg       @@flat_1            ;we have to call.
               call     draw_fSegment       ;if X_Adder_Left <
               jmp      @@flat_2            ;X_Adder_Right then
               @@flat_1:                    ;we draw from ebx to edx
               call     draw_fSegment1      ;otherwise from edx to ebx
               @@flat_2:
               ;well, upper segment was successfully drawn.. at least i hope so :)
               ;check if we have to draw lower segment too
               mov      esi,[Y3]            ;if y2 = y3 we just return back
               sub      esi,[Y2]            ;otherwise we have to draw
               or       esi,esi             ;lower segment of triangle
               jnz      @@draw_lower_fSegment
               RET                          ;return
               ;we have to draw lower part of triangle too.. this take some
               ;extra time, arghhhhhhh :)
               @@draw_lower_fSegment:
               push     edx                 ;IDIV suxx cause it destroy EDX ;-)
               ;update left edge - shorter edge - p2 <-> p3
               mov      eax,[X3]            ;we have to update
               sub      eax,[X2]            ;left edge
               cdq
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x3 - x2) / (y3 - y2)
               ;update starting values
               mov      ebx,[X2]
               pop      edx                 ;oh not, again IDIV
               ;cmp both x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@flat_3            ;to see which procedure
               call     draw_fSegment       ;we have to call
               RET                          ;if ebx < edx then we
               @@flat_3:                    ;draw from ebx to edx
               call     draw_fSegment1      ;otherwise from edx to ebx
               RET                          ;return
               ;no upper triangle...
               @@NO_upper_fTriangle:        ;y1 = y2
               ;calc edge from p2 <-> p3
               mov      [X_Adder_Left],ebp  ;(x3 - x1) / (y3 - y1)
               mov      eax,[X3]            ;right edge
               sub      eax,[X2]
               mov      esi,[Y3]
               sub      esi,[Y2]
               cdq
               idiv     esi
               mov      ebp,eax             ;(x3 - x2) / (y3 - y2)
               ;calc screen offset
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_fSegment
               ;setup starting values
               mov      ebx,[X1]            ;setup starting values
               mov      edx,[X2]
               ;cmp both x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@flat_4            ;to see which procedure
               call     draw_fSegment       ;we have to call
               RET                          ;if ebx < edx then we
               @@flat_4:                    ;draw from ebx to edx
               call     draw_fSegment1      ;otherwise from edx to ebx
               @@NO_fTriangle:
               RET                          ;return
draw_fTriangle ENDP

;;
;                                                                          ;
; Name       : draw_fSegment                                               ;
; Description: draw one segment of flat triangle                           ;
; Input      : EDI = screen offset (row number)                            ;
;              ESI = height of triangle, EBP = x adder right               ;
;              EBX = start x position, EDX = end x position                ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fSegment PROC NEAR
              @@draw_fSegment_Loop:
              add      ebx,[X_Adder_Left]   ;interpolating...
              add      edx,ebp              ;x positions
              ;some simple clipping goes here
              ;clip left x position first
              cmp      ebx,[CLIP_LEFT_LIMIT]
              jge      @@fTriangle_clipX_MIN1
              mov      ebx,[CLIP_LEFT_LIMIT]
              @@fTriangle_clipX_MIN1:
              cmp      ebx,[CLIP_RIGHT_LIMIT]
              jl       @@fTriangle_clipX_MAX1
              mov      ebx,[CLIP_RIGHT_LIMIT]
              @@fTriangle_clipX_MAX1:
              ;clip also right x position
              cmp      edx,[CLIP_LEFT_LIMIT]
              jge      @@fTriangle_clipX_MIN2
              mov      edx,[CLIP_LEFT_LIMIT]
              @@fTriangle_clipX_MIN2:
              cmp      edx,[CLIP_RIGHT_LIMIT]
              jl       @@fTriangle_clipX_MAX2
              mov      edx,[CLIP_RIGHT_LIMIT]
              @@fTriangle_clipX_MAX2:
              ;calc hline length... as always :)
              mov      ecx,edx              ;calculating lenght of hline here
              mov      cx,0ffffh            ;DO NOT REMOVE THAT LINE!
              sub      ecx,ebx              ;kalms's advice
              sar      ecx,16               ;it makes shapes better looking
              inc      ecx
              push     edi
              ;add x to screen offset
              mov      eax,ebx
              sar      eax,16               ;get x position of current hline
              add      edi,eax              ;calculate offset on screen
              ;fill eax with color
              mov      al,[Flat_Color]
              mov      ah,al
              push     ax
              push     ax
              pop      eax
              ;GO!!!! fill it as fast as possible :)
              sar      ecx,1
              ;check if we have to write single byte
              jnc      @@fSegment1
              mov      [edi],al
              inc      edi
              @@fSegment1:
              or       ecx,ecx
              jz       @@fSegment2
              sar      ecx,1
              ;check if we have to write single word
              jnc      @@fSegment3
              mov      [edi],ax
              add      edi,2
              ;draw 4 bytes at same time - faster than 1 byte :)
              ;...even faster than 2 bytes :))
              or       ecx,ecx
              jz       @@fSegment2
              @@fSegment3:
              mov      [edi],eax
              add      edi,4
              dec      ecx
              jnz      @@fSegment3
              @@fSegment2:
              pop      edi
              add      edi,320
              dec      esi
              jnz      @@draw_fSegment_Loop
              RET                           ;return
draw_fSegment ENDP

;;
;                                                                          ;
; Name       : draw_fSegment1                                              ;
; Description: draw one segment of flat triangle                           ;
; Input      : EDI = screen offset (row number)                            ;
;              ESI = height of triangle, EBP = x adder right               ;
;              EDX = start x position, EBX = end x position                ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fSegment1 PROC NEAR
               @@draw_fSegment_Loop1:
               add      ebx,[X_Adder_Left]  ;interpolating...
               add      edx,ebp             ;x positions
               ;some simple clipping goes here
               ;clip left x position first
               cmp      ebx,[CLIP_LEFT_LIMIT]
               jge      @@fTriangle_clipX_MIN3
               mov      ebx,[CLIP_LEFT_LIMIT]
               @@fTriangle_clipX_MIN3:
               cmp      ebx,[CLIP_RIGHT_LIMIT]
               jl       @@fTriangle_clipX_MAX3
               mov      ebx,[CLIP_RIGHT_LIMIT]
               @@fTriangle_clipX_MAX3:
               ;clip also right x position
               cmp      edx,[CLIP_LEFT_LIMIT]
               jge      @@fTriangle_clipX_MIN4
               mov      edx,[CLIP_LEFT_LIMIT]
               @@fTriangle_clipX_MIN4:
               cmp      edx,[CLIP_RIGHT_LIMIT]
               jl       @@fTriangle_clipX_MAX4
               mov      edx,[CLIP_RIGHT_LIMIT]
               @@fTriangle_clipX_MAX4:
               ;calc hline length... as always :)
               mov      ecx,ebx             ;calculating lenght of hline here
               mov      cx,0ffffh           ;DO NOT REMOVE THAT LINE!
               sub      ecx,edx             ;kalms's advice
               sar      ecx,16              ;it makes shapes better looking
               inc      ecx
               push     edi
               ;add x to screen offset
               mov      eax,edx
               sar      eax,16              ;get x position of current hline
               add      edi,eax             ;calculate offset on screen
               ;fill eax with color
               mov      al,[Flat_Color]
               mov      ah,al
               push     ax
               push     ax
               pop      eax
               ;GO!!!! fill it as fast as possible :)
               sar      ecx,1
               ;check if we have to write single byte
               jnc      @@fSegment4
               mov      [edi],al
               inc      edi
               @@fSegment4:
               or       ecx,ecx
               jz       @@fSegment5
               sar      ecx,1
               ;check if we have to write single word
               jnc      @@fSegment6
               mov      [edi],ax
               add      edi,2
               ;draw 4 bytes at same time - faster than 1 byte :)
               ;...even faster than 2 bytes :))
               or       ecx,ecx
               jz       @@fsegment5
               @@fSegment6:
               mov      [edi],eax
               add      edi,4
               dec      ecx
               jnz      @@fSegment6
               @@fSegment5:
               pop      edi
               add      edi,320
               dec      esi
               jnz      @@draw_fSegment_Loop1
               RET                          ;return
draw_fSegment1 ENDP

;;
;                                                                          ;
; Name       : draw_gTriangle                                              ;
; Description: draw gouraud triangle using 5 or 7 divs                     ;
; Input      : X1,Y1,C1,X2,Y2,C2,X3,Y3,C3                                  ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_gTriangle PROC NEAR
               ;sort all y coordinates of triangle... y1 < y2 < y3
               call     Sort_Y              ;sort y coordinates
               call     Clip_Y_All
               ;make 16.16 fixed points
               sal      [X1],16             ;make fixed points
               sal      [X2],16
               sal      [X3],16
               sal      [C1],16
               sal      [C2],16
               sal      [C3],16
               ;longer edge - right edge - p1 <-> p3 - x adder
               mov      eax,[X3]            ;calculate longer edge -
               sub      eax,[X1]            ;right edge
               mov      esi,[Y3]            ;x adder
               sub      esi,[Y1]
               or       esi,esi
               jz       @@NO_gTriangle
               cdq
               idiv     esi
               mov      ebp,eax             ;(x3 - x1) / (y3 - y1)
               ;longer edge - right edge - p1 <-> p3 - color adder
               mov      eax,[C3]            ;calculate longer edge -
               sub      eax,[C1]            ;right edge
               cdq                          ;color adder
               idiv     esi
               mov      [C_Adder_Right],eax ;(c3 - c1) / (y3 - y1)
               ;shorter edge - left edge - p1 <-> p2 - x adder
               mov      eax,[X2]            ;calculate shorter edge -
               sub      eax,[X1]            ;left edge
               mov      esi,[Y2]            ;check if there's
               sub      esi,[Y1]            ;no upper gouraud
               or       esi,esi             ;triangle at all
               jz       @@NO_upper_gTriangle
               cdq                          ;x adder
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x2 - x1) / (y2 - y1)
               ;shorter edge - left edge - p1 <-> p2 - color adder
               mov      eax,[C2]            ;calculate shorter edge -
               sub      eax,[C1]            ;left edge
               cdq                          ;color adder
               idiv     esi
               mov      [C_Adder_Left],eax  ;(c2 - c1) / (y2 - y1)
               ;calc screen offset
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_gSegment
               ;setup starting values
               mov      ebx,[X1]            ;starting x values
               mov      edx,ebx
               mov      eax,[C1]            ;starting color values
               mov      ecx,eax
               ;calc gouraud interpolating value
               push     esi                 ;calculate G
               @@calc_G:
               add      ebx,[X_Adder_Left]  ;we have to do it
               add      edx,ebp             ;at longest hline
               add      eax,[C_Adder_Left]  ;and that's at the
               add      ecx,[C_Adder_Right] ;bottom of firt
               dec      esi                 ;segment of triangle
               jnz      @@calc_G
               sub      eax,ecx             ;c_end - c_start
               mov      ecx,ebx             ;calc hline here
               mov      cx,0ffffh
               sub      ecx,edx             ;x_end - x_start
               sar      ecx,16
               inc      ecx
               or       ecx,ecx
               jz       @@zeroG
               cdq
               idiv     ecx
               @@zeroG:
               rol      eax,16
               mov      [G],eax             ;save G
               ;restore starting values
               pop      esi
               ;we destroyed starting values during calculating G
               ;so we have to get them back.. it's faster than push/pop
               mov      ebx,[X1]            ;starting x values
               mov      edx,ebx
               mov      eax,[C1]            ;starting color values
               mov      ecx,eax
               ;cmp both x positions        ;compare both adders
               cmp      [X_Adder_Left],ebp  ;to see which procedure
               jg       @@gouraud_1         ;we have to call
               call     draw_gSegment       ;if X_Adder_Left <
               jmp      @@gouraud_2         ;X_Adder_Right then
               @@gouraud_1:                 ;we draw from ebx to edx
               call     draw_gSegment1      ;otherwise from edx to ebx1
               @@gouraud_2:
               ;well, upper segment was successfully drawn.. at least i hope so :)
               ;check if we have to draw lower segment too
               mov      esi,[Y3]            ;if y2 = y3 we just return back
               sub      esi,[Y2]            ;otherwise we have to draw
               or       esi,esi             ;lower segment of triangle
               jnz      @@draw_lower_gSegment
               RET                          ;return
               @@draw_lower_gSegment:
               ;update left edge - p2 <-> p3 - x adder
               push     edx                 ;idiv suxx - EDX destroyed ;-)
               mov      eax,[X3]            ;we have to update
               sub      eax,[X2]            ;left edge
               cdq                          ;x adder
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x3 - x2) / (y3 - y2)
               ;update left edge - p2 <-> p3 - color adder
               mov      eax,[C3]            ;we have to update
               sub      eax,[C2]            ;left edge
               cdq                          ;color adder
               idiv     esi
               mov      [C_Adder_Left],eax  ;(c3 - c2) / (y3 - y2)
               ;also update current x and color values
               mov      ebx,[X2]            ;update x position
               mov      eax,[C2]            ;and color value
               pop      edx                 ;oh not, idiv again
               ;cmp current x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@gouraud_3         ;to see which procedure
               call     draw_gSegment       ;we have to call
               RET                          ;if ebx < edx then we
               @@gouraud_3:                 ;draw from ebx to edx
               call     draw_gSegment1      ;otherwise from edx to ebx
               RET                          ;return
               ;no upper gTriangle... we have saved some cycles ;)
               @@NO_upper_gTriangle:        ;y1 = y2
               ;left edge - p1 <-> p3...
               ;well, if u r smart as i'm then u know this values have already
               ;been calculated so u dont need to calculate them again :)
               mov      [X_Adder_Left],ebp  ;(x3 - x1) / (y3 - y1)
               mov      eax,[C_Adder_Right]
               mov      [C_Adder_Left],eax  ;(c3 - c1) / (y3 - y1)
               ;right edge - p2 <-> p3 - x adder
               mov      eax,[X3]            ;right edge
               sub      eax,[X2]            ;x adder
               mov      esi,[Y3]            ;since y1=y2 we need
               sub      esi,[Y2]            ;to calc this only once
               or       esi,esi
               jz       @@NO_gTriangle
               cdq
               idiv     esi
               mov      ebp,eax             ;(x3 - x2) / (y3 - y2)
               ;right edge - p2 <-> p3 - color adder
               mov      eax,[C3]            ;right edge
               sub      eax,[C2]            ;color adder
               cdq
               idiv     esi
               mov      [C_Adder_Right],eax ;(c3 - c2) / (y3 - y2)
               ;calc screen offset
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_gSegment
               ;setup strting values
               mov      ebx,[X1]            ;setup starting values
               mov      edx,[X2]            ;x positions
               mov      eax,[C1]            ;and
               mov      ecx,[C2]            ;color values
               ;calc G
               sub      eax,ecx             ;c_end - c_start
               mov      ecx,ebx             ;calc hline here
               mov      cx,0ffffh
               sub      ecx,edx             ;x_end - x_start
               sar      ecx,16
               inc      ecx
               or       ecx,ecx
               jz       @@zeroG1
               cdq
               idiv     ecx
               @@zeroG1:
               rol      eax,16
               mov      [G],eax             ;save G
               ;we destroyed starting values during calculating G
               ;so we have to get them back.. it's faster than push/pop
               mov      ebx,[X1]            ;setup starting values
               mov      edx,[X2]            ;x positions
               mov      eax,[C1]            ;and
               mov      ecx,[C2]            ;color values
               ;cmp both x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@gouraud_4         ;to see which procedure we have to call
               call     draw_gSegment       ;if ebx < edx then we
               RET                          ;draw from ebx to edx
               @@gouraud_4:                 ;otherwise from edx to ebx
               call     draw_gSegment1
               @@NO_gTriangle:
               RET                          ;return
draw_gTriangle ENDP

;;
;                                                                          ;
; Name       : draw_gSegment                                               ;
; Description: draw one segment of gouraud triangle                        ;
; Input      : EDI = screen offset (row number), EBP = x adder right       ;
;              EBX = start x position, EDX = end x position                ;
;              EAX = start color value, ECX = end color value              ;
;              ESI = height of triangle, G = hline interpolating value     ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_gSegment PROC NEAR
              @@draw_gSegment_Loop:
              add      ebx,[X_Adder_Left]   ;interpolating...
              add      edx,ebp              ;x positions
              add      eax,[C_Adder_Left]   ;color values
              add      ecx,[C_Adder_Right]  ;we dont need to do this but do it anyway
              ;well... intel should add some more registers :)
              push     eax ebx ecx edx edi
              ;some simple clipping goes here
              ;clip left x position first
              cmp      ebx,[CLIP_LEFT_LIMIT]
              jge      @@gTriangle_clipX_MIN1
              mov      ebx,[CLIP_LEFT_LIMIT]
              @@gTriangle_clipX_MIN1:
              cmp      ebx,[CLIP_RIGHT_LIMIT]
              jl       @@gTriangle_clipX_MAX1
              mov      ebx,[CLIP_RIGHT_LIMIT]
              @@gTriangle_clipX_MAX1:
              ;clip also right x position
              cmp      edx,[CLIP_LEFT_LIMIT]
              jge      @@gTriangle_clipX_MIN2
              mov      edx,[CLIP_LEFT_LIMIT]
              @@gTriangle_clipX_MIN2:
              cmp      edx,[CLIP_RIGHT_LIMIT]
              jl       @@gTriangle_clipX_MAX2
              mov      edx,[CLIP_RIGHT_LIMIT]
              @@gTriangle_clipX_MAX2:
              ;calc hline length
              mov      ecx,edx              ;calculating lenght of hline here
              mov      cx,0ffffh            ;DO NOT REMOVE THAT LINE!
              sub      ecx,ebx              ;kalms's advice
              sar      ecx,16               ;it makes shapes better looking
              inc      ecx
              or       ecx,ecx
              jz       @@NO_gLine
              ;calc screen offset.. x only
              sar      ebx,16               ;get x position of current hline
              add      edi,ebx              ;calculate offset on screen
              ;setup starting colro value of hline
              rol      eax,16               ;start color
              mov      ebx,[G]              ;G
              ;P5 optimized inner loop
              neg      ecx
              sub      edi,ecx
              @@gInner_Loop:                ;inner loop
              adc      eax,ebx
              mov      [edi+ecx],al
              inc      ecx
              jnz      @@gInner_Loop
              @@NO_gLine:
              pop      edi edx ecx ebx eax
              ;next row
              add      edi,320
              ;we have to finish once :)
              dec      esi
              jnz      @@draw_gSegment_Loop
              RET                           ;return
draw_gSegment ENDP

;;
;                                                                          ;
; Name       : draw_gSegment1                                              ;
; Description: draw one segment of gouraud triangle                        ;
; Input      : EDI = screen offset (row number), EBP = x adder right       ;
;              EDX = start x position, EBX = end x position                ;
;              ECX = start color value, EAX = end color value              ;
;              ESI = height of triangle, G = hline interpolating value     ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_gSegment1 PROC NEAR
               @@draw_gSegment_Loop1:
               add      ebx,[X_Adder_Left]  ;interpolating...
               add      edx,ebp             ;x positions
               add      eax,[C_Adder_Left]  ;color values
               add      ecx,[C_Adder_Right]
               ;well... intel should add some more registers :)
               push     eax ebx ecx edx edi
               ;some simple clipping goes here
               ;clip left x position first
               cmp      ebx,[CLIP_LEFT_LIMIT]
               jge      @@gTriangle_clipX_MIN3
               mov      ebx,[CLIP_LEFT_LIMIT]
               @@gTriangle_clipX_MIN3:
               cmp      ebx,[CLIP_RIGHT_LIMIT]
               jl       @@gTriangle_clipX_MAX3
               mov      ebx,[CLIP_RIGHT_LIMIT]
               @@gTriangle_clipX_MAX3:
               ;clip also right x position
               cmp      edx,[CLIP_LEFT_LIMIT]
               jge      @@gTriangle_clipX_MIN4
               mov      edx,[CLIP_LEFT_LIMIT]
               @@gTriangle_clipX_MIN4:
               cmp      edx,[CLIP_RIGHT_LIMIT]
               jl       @@gTriangle_clipX_MAX4
               mov      edx,[CLIP_RIGHT_LIMIT]
               @@gTriangle_clipX_MAX4:
               ;everything is so reveresed.. reverse back
               xchg     ebx,edx
               mov      eax,ecx
               ;calc hline length
               mov      ecx,edx             ;calculating lenght of hline here
               mov      cx,0ffffh           ;DO NOT REMOVE THAT LINE!
               sub      ecx,ebx             ;kalms's advice
               sar      ecx,16              ;it makes shapes better looking
               inc      ecx
               or       ecx,ecx
               jz       @@NO_gLine1
               ;calc screen offset.. x only
               sar      ebx,16              ;get x position of current hline
               add      edi,ebx             ;calculate offset on screen
               ;setup starting colro value of hline
               rol      eax,16              ;start color
               mov      ebx,[G]             ;G
               ;P5 optimized inner loop
               neg      ecx
               sub      edi,ecx
               @@gInner_Loop1:              ;inner loop
               adc      eax,ebx
               mov      [edi+ecx],al
               inc      ecx
               jnz      @@gInner_Loop1
               @@NO_gLine1:
               pop      edi edx ecx ebx eax
               ;next row
               add      edi,320
               ;we have to finish once :)
               dec      esi
               jnz      @@draw_gSegment_Loop1
               RET                          ;return
draw_gSegment1 ENDP

;;
;                                                                          ;
; Name       : draw_tTriangle                                              ;
; Description: draw texture triangle using 9 or 11 divs                    ;
; Input      : X1,Y1,MX1,MY1,X2,Y2,MX2,MY2,X3,Y3,MX3,MY3                   ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_tTriangle PROC NEAR
               ;sort y positions
               call     Sort_Y              ;sort y coordinates
               ;clip y positions
               call     Clip_Y_All
               ;make fixed points
               sal      [X1],16             ;make 16:16 fixed points
               sal      [X2],16
               sal      [X3],16
               sal      [MX1],8             ;make 8:8 fixed points
               sal      [MX2],8
               sal      [MX3],8
               sal      [MY1],8
               sal      [MY2],8
               sal      [MY3],8
               ;=== RIGHT X ADDER ===
               ;right edge - longer edge - p1 <-> p3
               mov      eax,[X3]            ;calculate longer edge -
               sub      eax,[X1]            ;right edge
               mov      esi,[Y3]            ;x adder
               sub      esi,[Y1]
               or       esi,esi
               jz       @@NO_tTriangle
               cdq
               idiv     esi
               mov      [X_Adder_Right],eax ;(x3 - x1) / (y3 - y1)
               ;=== RIGHT MAPPING X ADDER ===
               mov      eax,[MX3]           ;calculate longer edge -
               sub      eax,[MX1]           ;right edge
               cdq                          ;mapping x adder
               idiv     esi
               mov      [T_Adder_Right_X],eax;(mx3 - mx1) / (y3 - y1)
               ;=== RIGHT MAPPING Y ADDER ===
               mov      eax,[MY3]           ;calculate longer edge -
               sub      eax,[MY1]           ;right edge
               cdq                          ;mapping y adder
               idiv     esi
               mov      [T_Adder_Right_Y],eax;(my3 - my1) / (y3 - y1)
               ;=== LEFT X ADDER ===
               ;left edge - shorter edge - p1 <-> p2
               mov      eax,[X2]            ;calculate shorter edge -
               sub      eax,[X1]            ;left edge
               mov      esi,[Y2]
               sub      esi,[Y1]
               or       esi,esi
               jz       @@NO_upper_tTriangle
               cdq                          ;x adder
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x2 - x1) / (y2 - y1)
               ;=== LEFT MAPPING X ADDER ===
               mov      eax,[MX2]           ;calculate shorter edge -
               sub      eax,[MX1]           ;left edge
               cdq                          ;mapping x adder
               idiv     esi
               mov      [T_Adder_Left_X],eax;(mx2 - mx1) / (y2 - y1)
               ;=== LEFT MAPPING Y ADDER ===
               mov      eax,[MY2]           ;calculate shorter edge -
               sub      eax,[MY1]           ;left edge
               cdq                          ;mapping y adder
               idiv     esi
               mov      [T_Adder_Left_Y],eax;(my2 - my1) / (y2 - y1)
               ;=== CALC. SCREEN OFFSET ===
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_tSegment
               ;=== SETUP STARTING VALUES ===
               mov      ebx,[X1]            ;starting x values
               mov      edx,ebx
               mov      eax,[MX1]           ;mapping positions
               mov      [mLeft_X],eax
               mov      [mRight_X],eax
               mov      eax,[MY1]
               mov      [mLeft_Y],eax
               mov      [mRight_Y],eax
               ;=== CALC. U AND V ===
               push     esi                 ;save height of triangle
               @@calc_UV:
               add      ebx,[X_Adder_Left]  ;we have to do it
               add      edx,[X_Adder_Right] ;at longest hline
               mov      eax,[T_Adder_Right_X];the longest line is
               add      [mRight_X],eax      ;at the bottom of
               mov      eax,[T_Adder_Right_Y];1st triangle so we
               add      [mRight_Y],eax      ;have to 'move' there
               mov      eax,[T_Adder_Left_X]
               add      [mLeft_X],eax
               mov      ebp,[T_Adder_Left_Y]
               add      [mLeft_Y],ebp
               dec      esi
               jnz      @@calc_UV
               ;calc length of hline
               mov      ecx,edx             ;lenght of hline
               mov      cx,0ffffh           ;where we gonna
               sub      ecx,ebx             ;calc. U and V
               sar      ecx,16
               inc      ecx
               ;calc U
               mov      eax,[mRight_X]      ;calc. U
               sub      eax,[mLeft_X]
               or       ecx,ecx
               jz       @@zeroU
               cdq
               idiv     ecx
               @@zeroU:
               mov      [U],eax
               ;calc V
               mov      eax,[mRight_Y]      ;calc. V
               sub      eax,[mLeft_Y]
               or       ecx,ecx
               jz       @@zeroV
               cdq
               idiv     ecx
               @@zeroV:
               mov      [V],eax
               pop      esi                 ;pop height of triangle
               ;we destroyed starting values during calculating U and V
               ;so we have to get them back.. it's faster than push/pop
               mov      ebx,[X1]            ;starting x values
               mov      edx,ebx
               mov      eax,[MX1]           ;mapping positions
               mov      [mLeft_X],eax
               mov      [mRight_X],eax
               mov      eax,[MY1]
               mov      [mLeft_Y],eax
               mov      [mRight_Y],eax
               ;cmp both x adders
               mov      eax,[X_Adder_Left]  ;compare both adders
               cmp      eax,[X_Adder_Right] ;to see which procedure
               jg       @@texture_1         ;we have to call
               call     draw_tSegment       ;if X_Adder_Left <
               jmp      @@texture_2         ;X_Adder_Right then
               @@texture_1:                 ;we draw from ebx to edx
               call     draw_tSegment1      ;otherwise from edx to ebx1
               @@texture_2:
               ;upper segment was (hopefully:) successfully drawn...
               ;check out for lower segment of triangle
               mov      esi,[Y3]            ;check if there is
               sub      esi,[Y2]            ;2nd semgnet of triangle
               or       esi,esi
               jz       @@NO_tTriangle      ;if not then exit proc
               ;=== UPDATE LEFT X ADDER ===
               push     edx                 ;idiv destroy edx which
               mov      eax,[X3]            ;we need for x positions
               sub      eax,[X2]
               cdq
               idiv     esi
               mov      [X_Adder_Left],eax  ;(x3 - x2) / (y3 - y2)
               ;=== UPDATE LEFT MAPPING X ADDER ===
               mov      eax,[MX3]
               sub      eax,[MX2]
               cdq
               idiv     esi
               mov      [T_Adder_Left_X],eax;(mx3 - mx2) / (y3 - y2)
               ;=== UPDATE LEFT MAPPING Y ADDER ===
               mov      eax,[MY3]
               sub      eax,[MY2]
               cdq
               idiv     esi
               mov      [T_Adder_Left_Y],eax;(my3 - my2) / (y3 - y2)
               pop      edx                 ;pop x position
               ;=== UPDATE STARTING VALUES
               mov      ebx,[X2]            ;x position
               mov      eax,[MX2]
               mov      [mLeft_X],eax       ;mapping x
               mov      eax,[MY2]
               mov      [mLeft_Y],eax       ;mapping y
               ;cmp both x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@texture_3         ;to see which procedure
               call     draw_tSegment       ;we have to call
               RET                          ;if ebx < edx then we
               @@texture_3:                 ;draw from ebx to edx
               call     draw_tSegment1      ;otherwise from edx to ebx
               RET
               @@NO_upper_tTriangle:        ;y1 = y2
               ;=== NO UPPER TMAPPED TRIANGLE ===
               mov      esi,[Y3]
               sub      esi,[Y2]
               or       esi,esi
               jz       @@NO_tTriangle
               ;=== X LEFT ADDER ===
               ;be smart and use some values u have already caluclated and
               ;not calc them again like this do lammahz :)
               mov      eax,[X_Adder_Right]
               mov      [X_Adder_Left],eax  ;(x3 - x1) / (y3 - y1)
               ;=== MAPPING X LEFT ADDER ===
               mov      eax,[T_Adder_Right_X]
               mov      [T_Adder_Left_X],eax;(mx3 - mx1) / (y3 - y1)
               ;=== MAPPING Y LEFT ADDER ===
               mov      eax,[T_Adder_Right_Y]
               mov      [T_Adder_Left_Y],eax;(my3 - my1) / (y3 - y1)
               ;=== X RIGHT ADDER ===
               mov      eax,[X3]            ;right edge
               sub      eax,[X2]            ;x adder
               cdq
               idiv     esi
               mov      [X_Adder_Right],eax ;(x3 - x2) / (y3 - y2)
               ;=== MAPPING X LEFT ADDER
               mov      eax,[MX3]           ;right edge
               sub      eax,[MX2]           ;mapping x adder
               cdq
               idiv     esi
               mov      [T_Adder_Right_X],eax;(mx3 - mx2) / (y3 - y2)
               ;=== MAPPING Y LEFT ADDER
               mov      eax,[MY3]           ;right edge
               sub      eax,[MY2]           ;mapping y adder
               cdq
               idiv     esi
               mov      [T_Adder_Right_Y],eax;(my3 - my2) / (y3 - y2)
               ;=== CALC OFFSET ON SCREEN ===
               mov      edi,[Y1]            ;calculate offset on
               lea      edi,[edi+edi*4]     ;screen to draw
               shl      edi,6               ;NOTE: only Y position
               add      edi,[aPage]         ;we add X in procedure draw_tSegment
               ;=== SETUP STARTING VALUES ===
               mov      ebx,[X1]            ;setup starting values
               mov      edx,[X2]            ;x positions
               mov      eax,[MX2]           ;and
               mov      [mRight_X],eax      ;mapping positions
               mov      eax,[MY2]
               mov      [mRight_Y],eax
               mov      eax,[MX1]
               mov      [mLeft_X],eax
               mov      eax,[MY1]
               mov      [mLeft_Y],eax
               ;=== CALC U AND V ===
               mov      ecx,edx             ;lenght of hline
               mov      cx,0ffffh
               sub      ecx,ebx
               sar      ecx,16
               inc      ecx
               ;calc U
               mov      eax,[mRight_X]      ;calc. U
               sub      eax,[mLeft_X]
               or       ecx,ecx
               jz       @@zeroU1
               cdq
               idiv     ecx
               @@zeroU1:
               mov      [U],eax
               ;calc V
               mov      eax,[mRight_Y]      ;calc. V
               sub      eax,[mLeft_Y]
               or       ecx,ecx
               jz       @@zeroV1
               cdq
               idiv     ecx
               @@zeroV1:
               mov      [V],eax
               mov      edx,[X2]            ;idiv destroys edx... another bad thing of intel
               ;cmp both x positions
               cmp      ebx,edx             ;compare both x positions
               jg       @@texture_4         ;to see which procedure we have to call
               call     draw_tSegment       ;if ebx < edx then we
               RET                          ;draw from ebx to edx
               @@texture_4:                 ;otherwise from edx to ebx
               call     draw_tSegment1
               @@NO_tTriangle:
               RET                          ;return
draw_tTriangle ENDP

;;
;                                                                          ;
; Name       : draw_tSegment                                               ;
; Description: draw one segment of texture mapped triangle                 ;
; Input      : EDI = screen offset (row number), ESI = height of triangle  ;
;              EBX = start x position, EDX = end x position                ;
;              mLeft_X, mRight_X = mapping x coordinates                   ;
;              mLeft_Y, mRight_Y = mapping y coordinates                   ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_tSegment PROC NEAR
              mov      ebp,offsetTexture
              @@draw_tSegment_Loop:
              ;interpolate x positions...
              add      ebx,[X_Adder_Left]
              add      edx,[X_Adder_Right]
              ;and ONLY mapping coords on left edge
              mov      eax,[T_Adder_Left_X]
              add      [mLeft_X],eax
              mov      eax,[T_Adder_Left_Y]
              add      [mLeft_Y],eax
              ;be smart and figure out this on your onw:
              ;don't need to interpolate mapping coords on right edge :)
              ;save some important register as always
              push     ebx edx esi edi
              ;simple clipping goes here... it's really simple
              ;if (x > max_x) x = max_x and so on.. stupid! :)
              ;clip left x position first
              cmp      ebx,[CLIP_LEFT_LIMIT]
              jge      @@tTriangle_clipX_MIN1
              mov      ebx,[CLIP_LEFT_LIMIT]
              @@tTriangle_clipX_MIN1:
              cmp      ebx,[CLIP_RIGHT_LIMIT]
              jl       @@tTriangle_clipX_MAX1
              mov      ebx,[CLIP_RIGHT_LIMIT]
              @@tTriangle_clipX_MAX1:
              ;clip also right x position
              cmp      edx,[CLIP_LEFT_LIMIT]
              jge      @@tTriangle_clipX_MIN2
              mov      edx,[CLIP_LEFT_LIMIT]
              @@tTriangle_clipX_MIN2:
              cmp      edx,[CLIP_RIGHT_LIMIT]
              jl       @@tTriangle_clipX_MAX2
              mov      edx,[CLIP_RIGHT_LIMIT]
              @@tTriangle_clipX_MAX2:
              ;i guess we are calculating length of hline here
              mov      ecx,edx
              mov      cx,0ffffh
              sub      ecx,ebx
              sar      ecx,16
              inc      ecx                  ;length of hline
              or       ecx,ecx
              jz       @@NO_tLine
              ;add x position to screen offset
              sar      ebx,16
              add      edi,ebx              ;starting x position
              ;setup starting mapping values
              mov      ebx,[mLeft_X]        ;starting mapping
              mov      edx,[mLeft_Y]        ;positions
              ;P5 can makes imposible posible :)
              neg      ecx
              sub      edi,ecx
              mov      esi,[V]
              xor      eax,eax              ;safety
              @@tInner_Loop:                ;texture inner loop
              ;INTEL!!!! gimme one more register!!! :)
              add      ebx,[U]
              add      edx,esi
              mov      ah,dh                ;calc. offset in
              mov      al,bh                ;texture
              mov      al,[ebp+eax]
              mov      [edi+ecx],al
              inc      ecx
              jnz      @@tInner_Loop
              @@NO_tLine:
              ;if we push we have to pop too
              pop      edi esi edx ebx
              add      edi,320
              ;well, we have to finish this filling once
              dec        esi
              jnz        @@draw_tSegment_Loop
              RET                           ;return
draw_tSegment ENDP

;;
;                                                                          ;
; Name       : draw_tSegment                                               ;
; Description: draw one segment of texture mapped triangle                 ;
; Input      : EDI = screen offset (row number), ESI = height of triangle  ;
;              EDX = start x position, EBX = end x position                ;
;              mLeft_X, mRight_X = mapping x coordinates                   ;
;              mLeft_Y, mRight_Y = mapping y coordinates                   ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_tSegment1 PROC NEAR
               mov      ebp,offsetTexture
               @@draw_tSegment_Loop1:
               ;interpolate x positions...
               add      ebx,[X_Adder_Left]
               add      edx,[X_Adder_Right]
               ;and ONLY mapping coords on right edge
               mov      eax,[T_Adder_Right_X]
               add      [mRight_X],eax
               mov      eax,[T_Adder_Right_Y]
               add      [mRight_Y],eax
               ;dont need to interpolate mapping coords on left edge
               push     ebx edx esi edi
               ;very very simple clipping goes here... but we dont need more complex
               ;clip left x position first
               cmp      ebx,[CLIP_LEFT_LIMIT]
               jge      @@tTriangle_clipX_MIN3
               mov      ebx,[CLIP_LEFT_LIMIT]
               @@tTriangle_clipX_MIN3:
               cmp      ebx,[CLIP_RIGHT_LIMIT]
               jl       @@tTriangle_clipX_MAX3
               mov      ebx,[CLIP_RIGHT_LIMIT]
               @@tTriangle_clipX_MAX3:
               ;clip also right x position
               cmp      edx,[CLIP_LEFT_LIMIT]
               jge      @@tTriangle_clipX_MIN4
               mov      edx,[CLIP_LEFT_LIMIT]
               @@tTriangle_clipX_MIN4:
               cmp      edx,[CLIP_RIGHT_LIMIT]
               jl       @@tTriangle_clipX_MAX4
               mov      edx,[CLIP_RIGHT_LIMIT]
               @@tTriangle_clipX_MAX4:
               ;guess what we r calculating here?! :)
               mov      ecx,ebx
               mov      cx,0ffffh
               sub      ecx,edx
               sar      ecx,16
               inc      ecx                 ;length of hline
               or       ecx,ecx
               jz       @@NO_tLine1
               ;add x position to screen offset
               sar      edx,16
               add      edi,edx             ;starting x position
               ;setup starting mapping values
               mov      ebx,[mRight_X]      ;starting mapping
               mov      edx,[mRight_Y]      ;positions
               ;P5 can makes imposible posible :)
               neg      ecx
               sub      edi,ecx
               mov      esi,[V]
               xor      eax,eax             ;safety
               @@tInner_Loop1:              ;texture inner loop
               ;INTEL!!!! gimme one more register!!! :)
               add      ebx,[U]
               add      edx,esi
               mov      ah,dh               ;calc. offset in
               mov      al,bh               ;texture
               mov      al,[ebp+eax]
               mov      [edi+ecx],al
               inc      ecx
               jnz      @@tInner_Loop1
               @@NO_tLine1:
               ;we did push we have to do pop
               pop      edi esi edx ebx
               add      edi,320
               ;lets finish this boring filling once
               dec      esi
               jnz      @@draw_tSegment_Loop1
               RET                          ;return
draw_tSegment1 ENDP

;============================= Z-BUFFERED TRIANGLES =========================;

;;
;                                                                          ;
; Name       : init_zBuffer                                                ;
; Description: allocate memory for zbuffer and clear it                    ;
; Input      : /                                                           ;
; Output     : zBuffer                                                     ;
; Uses       : AX,ECX,EDX,EDI                                              ;
;                                                                          ;
;;
init_zBuffer PROC NEAR
             ;allocate memory for zbuffer
             mov      ax,0ee42h
             mov      edx,0ffffh
             shl      edx,1                 ;we need 128.000 bytes for zbuffer
             int      31h
             mov      [zBuffer],edx
             ;clear it
             mov      edi,[zBuffer]
             mov      ecx,32000
             mov      eax,07fff7fffh         ;setup to imposible value
             rep      stosd
             RET
init_zBuffer ENDP

;;
;                                                                          ;
; Name       : Clear_zBuffer                                               ;
; Description: clear memory for zbuffer, set it up to imposible value      ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : EAX,ECX,EDI                                                 ;
;                                                                          ;
;;
Clear_zBuffer PROC NEAR
              mov      edi,[zBuffer]
              mov      ecx,32000
              mov      eax,08fff8fffh         ;setup to imposible value
              rep      stosd
              RET
Clear_zBuffer ENDP

;;
;                                                                          ;
; Name       : draw_fTriangle_Z                                            ;
; Description: draw flat zbuffered triangle                                ;
; Input      : X1,Y1,C1,X2,Y2,C2,X3,Y3,C3                                  ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fTriangle_Z PROC NEAR
                 ;sort all y coordinates of triangle... y1 < y2 < y3
                 call     Sort_Y            ;sort y coordinates
                 call     Clip_Y_All
                 ;make 16.16 fixed points
                 sal      [X1],16           ;make fixed points
                 sal      [X2],16
                 sal      [X3],16
                 sal      [Z1],16
                 sal      [Z2],16
                 sal      [Z3],16
                 ;longer edge - right edge - p1 <-> p3 - x adder
                 mov      eax,[X3]          ;calculate longer edge -
                 sub      eax,[X1]          ;right edge
                 mov      esi,[Y3]          ;x adder
                 sub      esi,[Y1]
                 or       esi,esi
                 jz       @@NO_fTriangle_Z
                 cdq
                 idiv     esi
                 mov      ebp,eax           ;(x3 - x1) / (y3 - y1)
                 ;longer edge - right edge - p1 <-> p3 - z adder
                 mov      eax,[Z3]          ;calculate longer edge -
                 sub      eax,[Z1]          ;right edge
                 cdq                        ;z adder
                 idiv     esi
                 mov      [Z_Adder_Right],eax;(z3 - z1) / (y3 - y1)
                 ;shorter edge - left edge - p1 <-> p2 - x adder
                 mov      eax,[X2]          ;calculate shorter edge -
                 sub      eax,[X1]          ;left edge
                 mov      esi,[Y2]          ;check if there's
                 sub      esi,[Y1]          ;no upper zbuffered flat
                 or       esi,esi           ;triangle at all
                 jz       @@NO_upper_fTriangle_Z
                 cdq                        ;x adder
                 idiv     esi
                 mov      [X_Adder_Left],eax;(x2 - x1) / (y2 - y1)
                 ;shorter edge - left edge - p1 <-> p2 - z adder
                 mov      eax,[Z2]          ;calculate shorter edge -
                 sub      eax,[Z1]          ;left edge
                 cdq                        ;z adder
                 idiv     esi
                 mov      [Z_Adder_Left],eax;(z2 - z1) / (y2 - y1)
                 ;calc screen offset
                 mov      edi,[Y1]          ;calculate offset on
                 lea      edi,[edi+edi*4]   ;screen to draw
                 shl      edi,6             ;NOTE: only Y position
                 add      edi,[aPage]       ;we add X in procedure draw_fSegment_Z
                 ;setup starting values
                 mov      ebx,[X1]          ;starting x values
                 mov      edx,ebx
                 mov      eax,[Z1]          ;starting z values
                 mov      ecx,eax
                 ;calc zbuffer interpolating value
                 push     esi               ;calculate Z
                 @@calc_Z:
                 add      ebx,[X_Adder_Left];we have to do it
                 add      edx,ebp           ;at longest hline
                 add      eax,[Z_Adder_Left];and that's at the
                 add      ecx,[Z_Adder_Right];bottom of firt
                 dec      esi               ;segment of triangle
                 jnz      @@calc_Z
                 cmp      ecx,eax
                 jl       d1
                 ;xchg     ecx,eax
                 d1:
                 sub      eax,ecx           ;z_end - z_start
                 mov      ecx,ebx           ;calc hline here
                 cmp      edx,ecx
                 jl       d2
                 ;xchg     ecx,edx
                 d2:
                 mov      cx,0ffffh
                 sub      ecx,edx           ;x_end - x_start
                 sar      ecx,16
                 inc      ecx
                 or       ecx,ecx
                 jz       @@zeroZ
                 cdq
                 idiv     ecx
                 @@zeroZ:
                 ;ror      eax,16
                 mov      [Z],eax           ;save Z
                 ;restore starting values
                 pop      esi
                 ;we destroyed starting values during calculating Z
                 ;so we have to get them back.. it's faster than push/pop
                 mov      ebx,[X1]          ;starting x values
                 mov      edx,ebx
                 mov      eax,[Z1]          ;starting color values
                 mov      ecx,eax
                 ;cmp both x positions      ;compare both adders
                 cmp      [X_Adder_Left],ebp;to see which procedure
                 jg       @@flatZ_1         ;we have to call
                 call     draw_fSegment_Z   ;if X_Adder_Left <
                 jmp      @@flatZ_2         ;X_Adder_Right then
                 @@flatZ_1:                 ;we draw from ebx to edx
                 call     draw_fSegment1_Z  ;otherwise from edx to ebx1
                 @@flatZ_2:
                 ;well, upper segment was successfully drawn.. at least i hope so :)
                 ;check if we have to draw lower segment too
                 mov      esi,[Y3]          ;if y2 = y3 we just return back
                 sub      esi,[Y2]          ;otherwise we have to draw
                 or       esi,esi           ;lower segment of triangle
                 jnz      @@draw_lower_fSegment_Z
                 RET                        ;return
                 @@draw_lower_fSegment_Z:
                 ;update left edge - p2 <-> p3 - x adder
                 push     edx               ;idiv suxx - EDX destroyed ;-)
                 mov      eax,[X3]          ;we have to update
                 sub      eax,[X2]          ;left edge
                 cdq                        ;x adder
                 idiv     esi
                 mov      [X_Adder_Left],eax;(x3 - x2) / (y3 - y2)
                 ;update left edge - p2 <-> p3 - z adder
                 mov      eax,[Z3]          ;we have to update
                 sub      eax,[Z2]          ;left edge
                 cdq                        ;z adder
                 idiv     esi
                 mov      [Z_Adder_Left],eax;(z3 - z2) / (y3 - y2)
                 ;also update current x and color values
                 mov      ebx,[X2]          ;update x position
                 mov      eax,[Z2]          ;and z value
                 pop      edx               ;oh not, idiv again
                 ;cmp current x positions
                 cmp      ebx,edx           ;compare both x positions
                 jg       @@flatZ_3         ;to see which procedure
                 call     draw_fSegment_Z   ;we have to call
                 RET                        ;if ebx < edx then we
                 @@flatZ_3:                 ;draw from ebx to edx
                 call     draw_fSegment1_Z  ;otherwise from edx to ebx
                 RET                        ;return
                 ;no upper fTriangle_Z... we have saved some cycles ;)
                 @@NO_upper_fTriangle_Z:    ;y1 = y2
                 ;left edge - p1 <-> p3...
                 ;well, if u r smart as i'm then u know this values have already
                 ;been calculated so u dont need to calculate them again :)
                 mov      [X_Adder_Left],ebp;(x3 - x1) / (y3 - y1)
                 mov      eax,[Z_Adder_Right]
                 mov      [Z_Adder_Left],eax;(z3 - z1) / (y3 - y1)
                 ;right edge - p2 <-> p3 - x adder
                 mov      eax,[X3]          ;right edge
                 sub      eax,[X2]          ;x adder
                 mov      esi,[Y3]          ;since y1=y2 we need
                 sub      esi,[Y2]          ;to calc this only once
                 or       esi,esi
                 jz       @@NO_fTriangle_Z
                 cdq
                 idiv     esi
                 mov      ebp,eax           ;(x3 - x2) / (y3 - y2)
                 ;right edge - p2 <-> p3 - z adder
                 mov      eax,[Z3]          ;right edge
                 sub      eax,[Z2]          ;z adder
                 cdq
                 idiv     esi
                 mov      [Z_Adder_Right],eax;(z3 - z2) / (y3 - y2)
                 ;calc screen offset
                 mov      edi,[Y1]          ;calculate offset on
                 lea      edi,[edi+edi*4]   ;screen to draw
                 shl      edi,6             ;NOTE: only Y position
                 add      edi,[aPage]       ;we add X in procedure draw_gSegment
                 ;setup strting values
                 mov      ebx,[X1]          ;setup starting values
                 mov      edx,[X2]          ;x positions
                 mov      eax,[Z1]          ;and
                 mov      ecx,[Z2]          ;z values
                 ;calc Z
                 cmp      eax,ecx
                 jl       d3
                 ;xchg     eax,ecx
                 d3:
                 sub      eax,ecx           ;z_end - z_start
                 cmp      ebx,edx
                 jl       d4
                 ;xchg     ebx,edx
                 d4:
                 mov      ecx,ebx           ;calc hline here
                 mov      cx,0ffffh
                 sub      ecx,edx           ;x_end - x_start
                 sar      ecx,16
                 inc      ecx
                 or       ecx,ecx
                 jz       @@zeroZ1
                 cdq
                 idiv     ecx
                 @@zeroZ1:
                 ;ror      eax,16
                 mov      [Z],eax           ;save Z
                 ;we destroyed starting values during calculating Z
                 ;so we have to get them back.. it's faster than push/pop
                 mov      ebx,[X1]          ;setup starting values
                 mov      edx,[X2]          ;x positions
                 mov      eax,[Z1]          ;and
                 mov      ecx,[Z2]          ;z values
                 ;cmp both x positions
                 cmp      ebx,edx           ;compare both x positions
                 jg       @@flatZ_4         ;to see which procedure we have to call
                 call     draw_fSegment_Z   ;if ebx < edx then we
                 RET                        ;draw from ebx to edx
                 @@flatZ_4:                 ;otherwise from edx to ebx
                 call     draw_fSegment1_Z
                 @@NO_fTriangle_Z:
                 RET                        ;return
draw_fTriangle_Z ENDP

;;
;                                                                          ;
; Name       : draw_fSegment_Z                                             ;
; Description: draw one segment of zbuffered flat triangle                 ;
; Input      : EDI = screen offset (row number), EBP = x adder right       ;
;              EBX = start x position, EDX = end x position                ;
;              EAX = z color value, ECX = z color value                    ;
;              ESI = height of triangle, Z = zbuffer interpolating value   ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fSegment_Z PROC NEAR
                mov      [X_Adder_Right],ebp
                mov      ebp,[zBuffer]
                @@draw_fSegment_Z_Loop:
                add      ebx,[X_Adder_Left] ;interpolating...
                add      edx,[X_Adder_Right];x positions
                add      eax,[Z_Adder_Left] ;z values
                add      ecx,[Z_Adder_Right]
                ;well... intel should add some more registers :)
                push     eax ebx ecx edx edi ebp
                ;some simple clipping goes here
                ;clip left x position first
                cmp      ebx,[CLIP_LEFT_LIMIT]
                jge      @@fTriangle_Z_clipX_MIN1
                mov      ebx,[CLIP_LEFT_LIMIT]
                @@fTriangle_Z_clipX_MIN1:
                cmp      ebx,[CLIP_RIGHT_LIMIT]
                jl       @@fTriangle_Z_clipX_MAX1
                mov      ebx,[CLIP_RIGHT_LIMIT]
                sub      ebx,0ffffh
                @@fTriangle_Z_clipX_MAX1:
                ;clip also right x position
                cmp      edx,[CLIP_LEFT_LIMIT]
                jge      @@fTriangle_Z_clipX_MIN2
                mov      edx,[CLIP_LEFT_LIMIT]
                @@fTriangle_Z_clipX_MIN2:
                cmp      edx,[CLIP_RIGHT_LIMIT]
                jl       @@fTriangle_Z_clipX_MAX2
                mov      edx,[CLIP_RIGHT_LIMIT]
                sub      edx,0ffffh
                @@fTriangle_Z_clipX_MAX2:
                ;calc hline length
                mov      ecx,edx            ;calculating lenght of hline here
                mov      cx,0ffffh          ;DO NOT REMOVE THAT LINE!
                sub      ecx,ebx            ;kalms's advice
                sar      ecx,16             ;it makes shapes better looking
                inc      ecx
                or       ecx,ecx
                jz       @@NO_fLine_Z
                ;calc screen offset.. x only
                sar      ebx,16             ;get x position of current hline
                add      edi,ebx            ;calculate offset on screen
                mov      edx,edi
                sub      edx,[aPage]
                shl      edx,1
                add      ebp,edx
                ;setup starting colro value of hline
                ;ror      eax,16             ;start color
                mov      ebx,[Z]            ;Z
                add      edi,ecx
                lea      ebp,[ebp+ecx*2]
                neg      ecx
                @@fInner_Z_Loop:            ;inner loop
                add      eax,ebx
                mov      edx,eax
                sar      edx,16
                cmp      dx,[ebp+ecx*2]
                jle      @@NO_zDraw
                mov      [ebp+ecx*2],dx
                mov      dl,[Flat_Color]
                mov      [edi+ecx],dl
                @@NO_zDraw:
                inc      ecx
                jnz      @@fInner_Z_Loop
                @@NO_fLine_Z:
                pop      ebp edi edx ecx ebx eax
                ;next row
                add      edi,320
                ;we have to finish once :)
                dec      esi
                jnz      @@draw_fSegment_Z_Loop
                mov      ebp,[X_Adder_Right];we used ebp.. store it back
                RET                         ;return
draw_fSegment_Z ENDP

;;
;                                                                          ;
; Name       : draw_fSegment1_Z                                            ;
; Description: draw one segment of zbuffered flat triangle                 ;
; Input      : EDI = screen offset (row number), EBP = x adder right       ;
;              EDX = start x position, EBX = end x position                ;
;              ECX = z color value, EAX = z color value                    ;
;              ESI = height of triangle, Z = zbuffer interpolating value   ;
; Output     : /                                                           ;
; Uses       : all                                                         ;
;                                                                          ;
;;
draw_fSegment1_Z PROC NEAR
                 mov      [X_Adder_Right],ebp
                 mov      ebp,[zBuffer]
                 @@draw_fSegment_Z_Loop1:
                 add      ebx,[X_Adder_Left] ;interpolating...
                 add      edx,[X_Adder_Right];x positions
                 add      eax,[Z_Adder_Left] ;z values
                 add      ecx,[Z_Adder_Right]
                 ;well... intel should add some more registers :)
                 push     eax ebx ecx edx edi ebp
                 ;some simple clipping goes here
                 ;clip left x position first
                 cmp      ebx,[CLIP_LEFT_LIMIT]
                 jge      @@fTriangle_Z_clipX_MIN3
                 mov      ebx,[CLIP_LEFT_LIMIT]
                 @@fTriangle_Z_clipX_MIN3:
                 cmp      ebx,[CLIP_RIGHT_LIMIT]
                 jl       @@fTriangle_Z_clipX_MAX3
                 mov      ebx,[CLIP_RIGHT_LIMIT]
                 sub      ebx,0ffffh
                 @@fTriangle_Z_clipX_MAX3:
                 ;clip also right x position
                 cmp      edx,[CLIP_LEFT_LIMIT]
                 jge      @@fTriangle_Z_clipX_MIN4
                 mov      edx,[CLIP_LEFT_LIMIT]
                 @@fTriangle_Z_clipX_MIN4:
                 cmp      edx,[CLIP_RIGHT_LIMIT]
                 jl       @@fTriangle_Z_clipX_MAX4
                 mov      edx,[CLIP_RIGHT_LIMIT]
                 sub      edx,0ffffh
                 @@fTriangle_Z_clipX_MAX4:
                 ;everything is so reveresed.. reverse back
                 xchg     ebx,edx
                 mov      eax,ecx
                 ;calc hline length
                 mov      ecx,edx            ;calculating lenght of hline here
                 mov      cx,0ffffh          ;DO NOT REMOVE THAT LINE!
                 sub      ecx,ebx            ;kalms's advice
                 sar      ecx,16             ;it makes shapes better looking
                 inc      ecx
                 or       ecx,ecx
                 jz       @@NO_fLine_Z1
                 ;calc screen offset.. x only
                 sar      ebx,16             ;get x position of current hline
                 add      edi,ebx            ;calculate offset on screen
                 mov      edx,edi
                 sub      edx,[aPage]
                 shl      edx,1
                 add      ebp,edx
                 ;setup starting colro value of hline
                 ;ror      eax,16             ;start color
                 mov      ebx,[Z]            ;Z
                 add      edi,ecx
                 lea      ebp,[ebp+ecx*2]
                 neg      ecx
                 @@fInner_Z_Loop1:           ;inner loop
                 add      eax,ebx
                 mov      edx,eax
                 sar      edx,16
                 cmp      dx,[ebp+ecx*2]
                 jle      @@NO_zDraw1
                 mov      [ebp+ecx*2],dx
                 mov      dl,[Flat_Color]
                 mov      [edi+ecx],dl
                 @@NO_zDraw1:
                 inc      ecx
                 jnz      @@fInner_Z_Loop1
                 @@NO_fLine_Z1:
                 pop      ebp edi edx ecx ebx eax
                 ;next row
                 add      edi,320
                 ;we have to finish once :)
                 dec      esi
                 jnz      @@draw_fSegment_Z_Loop1
                 mov      ebp,[X_Adder_Right];we used ebp.. store it back
                 RET                        ;return
draw_fSegment1_Z ENDP

CODE ENDS

;============================ DATA = DATA = DATA ============================;

DATA SEGMENT DWORD PUBLIC 'DATA'

;variables
zLeft                dd  ?         ;holds current left Z
zRight               dd  ?         ;holds current right Z
mLeft_X              dd  ?         ;holds current left X position in texture
mLeft_Y              dd  ?         ;holds current left Y position in texture
mRight_X             dd  ?         ;holds current right X position in texture
mRight_Y             dd  ?         ;holds current right Y position in texture
zBuffer              dd  ?
offsetTexture        dd  ?

DATA ENDS











