CODE SEGMENT DWORD PUBLIC 'CODE'
ASSUME cs:CODE,ds:DATA

;;
;                                                                          ;
; Name       : setPalette                                                  ;
; Description: set palette                                                 ;
; Input      : ESI offset to 768 long palette structure                    ;
;            : ECX number of colors to set                                 ;
; Output     : /                                                           ;
; Uses       : DX,AL                                                       ;
;                                                                          ;
;;
setPalette PROC NEAR
           mov      dx,3c8h
           xor      al,al
           out      dx,al
           inc      dx
           @@setPalette_Loop:
           mov      al,[esi]
           out      dx,al
           inc      esi
           dec      ecx
           jnz      @@setPalette_Loop
           RET
setPalette ENDP

;;
;                                                                          ;
; Name       : load_PAL                                                    ;
; Description: load palette from file                                      ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : EAX,DX                                                      ;
;                                                                          ;
;;
load_PAL PROC NEAR
         mov     ax,3d00h
         int     21h
         mov     [File_Handle],ax
         mov     ax,3f00h
         mov     bx,[File_Handle]
         mov     ecx,[paletteSize]
         mov     edx,OFFSET [palette]
         int     21h
         mov     ax,3e00h
         mov     bx,[File_Handle]
         int     21h
         RET

         load_PAL_error:


load_PAL ENDP

;;
;                                                                          ;
; Name       : Wait_Retrace                                                ;
; Description: Wait retrace                                                ;
; Input      : /                                                           ;
; Output     : /                                                           ;
; Uses       : EAX,DX                                                      ;
;                                                                          ;
;;
wait_vRetrace PROC NEAR
              mov      eax,[vRetrace]
              or       eax,eax
              jz       @@No_vRetrace

              mov      dx,3dah
              ;do nothing, VGA is already in retrace
              @@Wait_vRetrace1:
              in       al,dx
              and      al,8
              jnz      @@Wait_vRetrace1
              ;do nothing, wait for state of retrace
              @@Wait_vRetrace2:
              in       al,dx
              and      al,8
              jz       @@Wait_vRetrace2

              @@No_vRetrace:
              RET
wait_vRetrace ENDP

CODE ENDS

DATA SEGMENT DWORD PUBLIC 'DATA'


;variables
vRetrace         equ 0
paletteSize      equ 768
palette          db  768 dup (?)

DATA ENDS