;;
;                                                                          ;
; Name       : Sort_Y                                                      ;
; Description: Sort Y coordinates of triangle                              ;
; Input      : Y1,Y2,Y3 (C1,C2,C3,MX1,MX2,MX3,MY1,MY2,MY3)                 ;
; Output     : Y1,Y2,Y3 sorted (Y1=min,y3=max)                             ;
; Uses       : EAX                                                         ;
;                                                                          ;
;;
Sort_Y PROC NEAR

       mov       eax,[LIMIT_FLAT]       ;check if we need to sort
       or        eax,eax
       jz        @@Sort_Y3              ;no sort at all

       mov       eax,[Y1]               ;check Y1 <--> Y2
       cmp       eax,[Y2]
       jle       @@Sort_Y1
       xchg      eax,[Y2]               ;swap X and Y positions
       mov       [Y1],eax
       mov       eax,[X1]
       xchg      eax,[X2]
       mov       [X1],eax
       mov       eax,[Z1]               ;swap Z for zbuffer
       xchg      eax,[Z2]
       mov       [Z1],eax

       @@SortY_Gouraud1:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture1
       mov       eax,[C1]
       xchg      eax,[C2]
       mov       [C1],eax

       @@SortY_Texture1:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jnz       @@Sort_Y1
       mov       eax,[MX1]
       xchg      eax,[MX2]
       mov       [MX1],eax
       mov       eax,[MY1]
       xchg      eax,[MY2]
       mov       [MY1],eax

       @@Sort_Y1:

       mov       eax,[Y1]               ;check Y1 <--> Y3
       cmp       eax,[Y3]
       jle       @@Sort_Y2
       xchg      eax,[Y3]               ;swap X and Y positions
       mov       [Y1],eax
       mov       eax,[X1]
       xchg      eax,[X3]
       mov       [X1],eax
       mov       eax,[Z1]               ;swap Z for zbuffer
       xchg      eax,[Z3]
       mov       [Z1],eax

       @@SortY_Gouraud2:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture2
       mov       eax,[C1]
       xchg      eax,[C3]
       mov       [C1],eax

       @@SortY_Texture2:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jz        @@Sort_Y2
       mov       eax,[MX1]
       xchg      eax,[MX3]
       mov       [MX1],eax
       mov       eax,[MY1]
       xchg      eax,[MY3]
       mov       [MY1],eax

       @@Sort_Y2:

       mov       eax,[Y2]               ;check Y2 <--> Y3
       cmp       eax,[Y3]
       jle       @@Sort_Y3
       xchg      eax,[Y3]               ;swap X and Y positions
       mov       [Y2],eax
       mov       eax,[X2]
       xchg      eax,[X3]
       mov       [X2],eax
       mov       eax,[Z2]               ;swap Z for zbuffer
       xchg      eax,[Z3]
       mov       [Z2],eax

       @@SortY_Gouraud3:
       mov       eax,[LIMIT_GOURAUD]    ;if limit is set to gouraud shading
       or        eax,eax                ;we have to swap color values
       jz        @@SortY_Texture3
       mov       eax,[C2]
       xchg      eax,[C3]
       mov       [C2],eax

       @@SortY_Texture3:                ;if limit is set to texture mapping
       mov       eax,[LIMIT_TEXTURE]    ;we have to swap mapping coordinates
       or        eax,eax
       jz        @@Sort_Y3
       mov       eax,[MX2]
       xchg      eax,[MX3]
       mov       [MX2],eax
       mov       eax,[MY2]
       xchg      eax,[MY3]
       mov       [MY2],eax

       @@Sort_Y3:

       RET

Sort_Y ENDP


