#ifndef _BLOCKMAP_
#define _BLOCKMAP_
#include "ray.h"

#define BLOCK_MAP_Y_SHIFT 7
#define BLOCK_MAP_X_SHIFT 7
#define BLOCK_MAP_X_SIZE 128
#define BLOCK_MAP_Y_SIZE 128
#define BLOCK_MAP_X_AND 0xff80
#define BLOCK_MAP_Y_AND 0xff80
#define MAX_LINES_PER_BLOCK 50

typedef struct LINE_LIST {
  short line_count;
  plinedef * lines;
  } line_list;

typedef line_list * pline_list;

line_list * Get_Block_Line_List(USHORT block_x, USHORT block_y);
pobject_node * Get_Block_Obj_List(USHORT block_x, USHORT block_y);
line_list * Get_Line_List(long x, long y);
void Generate_Block_Map();
void Clear_Block_Map();
short Block_X(long real_x);
short Block_Y(long real_y);
long Block_Left_Line(long base_x);
long Block_Right_Line(long base_x);
long Block_Top_Line(long base_y);
long Block_Bottom_Line(long base_y);
BOOL In_Block_X(long real_x, short block_x);
BOOL In_Block_Y(long real_y, short block_y);

#endif
