#ifndef _MYFIXED_                               
#define _MYFIXED_
#include "types.h"

typedef LONG MYFIXED;

const MYFIXED_ONE=16384;
const MAXMYFIXED=0x7FFFFFFF;
const MYFIXEDSHIFT = 14;
const MYFIXEDCONV = 1 << MYFIXEDSHIFT;

extern long high_32, low_32;
                        
MYFIXED fixedmult(MYFIXED op1, MYFIXED op2);
MYFIXED fixeddiv(MYFIXED op1, MYFIXED op2);
MYFIXED fixedsqr(MYFIXED op1);
MYFIXED fixedsqrt(MYFIXED op1);
MYFIXED fixedmd(MYFIXED mul1, MYFIXED mul2, MYFIXED div1);
MYFIXED fixedsqrtLP(MYFIXED n);  // Low  Precision (8.8)
MYFIXED fixedsqrtHP(MYFIXED n);  // High Precision (8.16)

void fixedmult64(MYFIXED op1, MYFIXED op2);
void fixedma64(MYFIXED op1, MYFIXED op2);
MYFIXED fixeddiv64(MYFIXED divisor);
MYFIXED fixedadd64(MYFIXED op1);
MYFIXED fixedinv20(MYFIXED op1);

inline long longsqrtHP(long op1) {
   return fixedsqrtHP(op1) >> 7;
}

inline long longsqrtLP(long op1) {
   return fixedsqrtLP(op1) >> 7;
}

inline LONG convtoLONG(MYFIXED x)
{
   return x>>MYFIXEDSHIFT;
}

inline MYFIXED convtoMYFIXED(LONG x)
{
   return x<<MYFIXEDSHIFT;
}

#pragma aux fixedmult = \
   "imul edx" \
   "add eax, 2000h" \
   "adc edx, 0" \
   "shrd eax,edx,14" \
   parm caller [eax] [edx] \
   value [eax] \
   modify [eax edx];

#pragma aux fixedmd = \
  "imul edx" \
  "idiv ebx" \
  parm caller [eax] [edx] [ebx] \
  value [eax] \
  modify [eax edx ebx];

#pragma aux fixeddiv = \
   "xor eax,eax" \
   "shrd eax,edx,18" \
   "sar edx, 18" \
   "idiv ecx" \
   parm caller [edx] [ecx] \
   modify [edx ecx eax] \
   value [eax];

#pragma aux fixedsqr =   \
    "imul eax"              \
    "add eax, 2000h"        \
    "adc edx, 0"            \
    "shrd eax, edx, 14"     \
    parm caller [eax]       \
    value [eax]             \
    modify [eax edx];

#pragma aux fixedmult64= \
    "imul edx"          \
    "mov high_32, edx" \
    "mov low_32, eax" \
    parm caller [eax] [edx] \
    modify [eax edx];

#pragma aux fixeddiv64= \
   "mov eax, low_32" \
   "mov edx, high_32" \
   "idiv ecx" \
   parm caller [ecx] \
   modify [eax edx ecx] \
   value [eax];

#pragma aux fixedma64= \
  "imul edx"                    \
  "add low_32, eax"         \
  "adc high_32, edx"        \
  parm caller [eax] [edx] \
  modify [eax edx];

#pragma aux fixedadd64= \
  "xor eax, eax" \
  "shrd eax, edx, 18" \
  "sar edx, 18" \
  "add low_32, eax" \
  "adc high_32, edx" \
  parm caller [edx] \
  modify [eax edx];

#pragma aux fixedinv20= \
  "xor eax, eax" \
  "mov edx, 4h" \
  "idiv ebx" \
  parm caller [ebx] \
  value [eax] \
  modify [eax ebx edx];

#pragma aux fixedsqrtLP =            \
    "         xor eax, eax"          \
    "         mov ebx, 40000000h"    \
    "sqrtLP1: mov edx, ecx"          \
    "         sub edx, ebx"          \
    "         jl  sqrtLP2"           \
    "         sub edx, eax"          \
    "         jl  sqrtLP2"           \
    "         mov ecx,edx"           \
    "         shr eax, 1"            \
    "         or  eax, ebx"          \
    "         shr ebx, 2"            \
    "         jnz sqrtLP1"           \
    "         shl eax, 7"            \
    "         jmp sqrtLP3"           \
    "sqrtLP2: shr eax, 1"            \
    "         shr ebx, 2"            \
    "         jnz sqrtLP1"           \
    "         shl eax, 7"            \
    "sqrtLP3: nop"                   \
    parm caller [ecx]                \
    value [eax]                      \
    modify [eax ebx ecx edx];


#pragma aux fixedsqrtHP =            \
    "         xor eax, eax"          \
    "         mov ebx, 40000000h"    \
    "sqrtHP1: mov edx, ecx"          \
    "         sub edx, ebx"          \
    "         jb  sqrtHP2"           \
    "         sub edx, eax"          \
    "         jb  sqrtHP2"           \
    "         mov ecx,edx"           \
    "         shr eax, 1"            \
    "         or  eax, ebx"          \
    "         shr ebx, 2"            \
    "         jnz sqrtHP1"           \
    "         jz  sqrtHP5"           \
    "sqrtHP2: shr eax, 1"            \
    "         shr ebx, 2"            \
    "         jnz sqrtHP1"           \
    "sqrtHP5: mov ebx, 00004000h"    \
    "         shl eax, 16"           \
    "         shl ecx, 16"           \
    "sqrtHP3: mov edx, ecx"          \
    "         sub edx, ebx"          \
    "         jb  sqrtHP4"           \
    "         sub edx, eax"          \
    "         jb  sqrtHP4"           \
    "         mov ecx, edx"          \
    "         shr eax, 1"            \
    "         or  eax, ebx"          \
    "         shr ebx, 2"            \
    "         jnz sqrtHP3"           \
    "         shr eax, 1"            \
    "         jmp sqrtHP6"           \
    "sqrtHP4: shr eax, 1"            \
    "         shr ebx, 2"            \
    "         jnz sqrtHP3"           \
    "         shr eax, 1"             \
    "sqrtHP6: nop"                   \
    parm caller [ecx]                \
    value [eax]                      \
    modify [eax ebx ecx edx];

#endif
