#include "ray.h"
#include "globals.h"
#include "getangle.h"
#include "fixed.h"
#include "abs.h"
#include <math.h>

#define RADIAN_COUNT 6.28

angle_type * atan_table;

void Init_Get_Angle() {
   atan_table=(angle_type *)NewPtr(ONE * sizeof(angle_type));
   float real_ratio;
   MYFIXED cur_ratio;
   for (cur_ratio=0; cur_ratio<ONE; cur_ratio++) {
      real_ratio=((float)cur_ratio)/ONE;
      atan_table[cur_ratio]=(angle_type)(atan(real_ratio)*ANGLE_360/RADIAN_COUNT);
   }
}

void Close_Get_Angle() {
   delete atan_table;
}

angle_type Get_Angle_Towards(long dx, long dy) {
   angle_type base_angle;

   if (ABS(dx)>ABS(dy)) {
      MYFIXED ratio=ABS(fixeddiv(dy, dx));
      if (ratio>=ONE)
         base_angle=ANGLE_45;
      else base_angle=atan_table[ratio];
   } else {
      if (dy==0) {
         return 0;
      }
      MYFIXED ratio=ABS(fixeddiv(dx, dy));
      if  (ratio>=ONE)
         base_angle=ANGLE_45;
      else base_angle=ANGLE_90-atan_table[ratio];
   }

   if (dy<0) {
      if (dx>0) {
         return (ANGLE_360-base_angle);
      } else {
         return (base_angle+ANGLE_180);
      } /* endif */
   } else {
      if (dx<0) {
         return (ANGLE_180-base_angle);
      } else {
         return (base_angle);
      } /* endif */
   } /* endif */
}
