#ifndef _GLOBALS_
#define _GLOBALS_
#include "ray.h"

#ifdef __cplusplus
#define g_var extern "C"
#else
#define g_var extern
#endif

g_var pobject the_player; // object which holds the numero uno player

g_var short Number_Of_Textures;
g_var wall_entry     *wall; // The wall textures
g_var USHORT Number_Of_FTs;
g_var wall_entry     *floortex; // The floor textures

g_var short WINDOW_HEIGHT; // The screen size constants
g_var short WINDOW_MIDDLE;
g_var short WINDOW_WIDTH; // the width of the window
g_var short WINDOW_MIDDLEW; // the center of the window on the x axis
g_var angle_type HORIZ_VIEW_RANGE;
g_var long SCALE_FACTOR; //used for sprites
g_var short VERTICAL_VIEW_RANGE;
g_var unsigned long VERTICAL_SCALE;
g_var angle_type VERTICAL_VIEW_ANGLE;

g_var Ptr buff;
g_var Byte  *sliver_texture; // pointer to texture being rendered
g_var int sliver_column;        // index into texture i.e. which column of texture
g_var int sliver_top;           // starting Y position to render at
g_var int sliver_scale;         // overall height of sliver
g_var int sliver_ray;           // current ray being cast
g_var int sliver_clip;          // index into texture after clipping
g_var Byte *scale_row;           // row of scale value look up table to use
g_var Byte * sliver_light; // Index to palette with correct level of 
	//light to draw
g_var MYFIXED sliver_inc_y; // incrementer to y pos in bitmap
g_var long sliver_and_x, sliver_and_y; // values to make sure we don't run off texture

g_var long * distance_table; // Stuff for floor drawing

//g_var long * movement_table;

g_var long  *tan_table;              // tangent tables used to compute initial
g_var long  *inv_tan_table;          // intersections with ray

g_var long  *cos_table;              // used to cancel out fishbowl effect

g_var long  *inv_cos_table;          // used to compute distances by calculating
g_var long  *inv_sin_table;          // the hypontenuse

g_var long    *rcos_table;
g_var long    *rsin_table;

g_var Byte * * pal_table; // The light palette array

g_var MYFIXED   *height_table; // scales wall height relative to distance

g_var MYFIXED   *middle_table; // used to correct for looking up + down

g_var MYFIXED y_inv_trans; // variable to help calculate speed at which to move across wall texture

g_var MYFIXED x_inv_trans; // same but for floors

// Globals to hold the world!

g_var USHORT Number_Of_Vectors;
g_var USHORT Number_Of_Sidedefs;
g_var USHORT Number_Of_Linedefs;
g_var USHORT Number_Of_Sectors;
g_var USHORT Number_Of_Segs;
g_var USHORT Number_Of_SSectors;
g_var USHORT Number_Of_Nodes;

g_var vector2 * Vector_List;

g_var sidedef * Sd_List;

g_var linedef * Ld_List;

g_var sector * Sector_List;

g_var seg * Seg_List;

g_var ssector * SS_List; // no, this is not a reference to a Nazi secret police census report.

g_var bsp_node * bsp_tree; // The mother of all data structures- the binary space partition                                // tree
				      // By day, a simple runtime allocated array- but by night, a static
				      // binary tree we will use to render at warp speed

g_var long bsp_start_node; // holds the first node in the bsp, usually 0

g_var tex_mark * tex_mark_table;

g_var wall_entry * sky_texture;

#endif
