#ifndef _KEYINFO_
#define _KEYINFO_
#include "os.h"


// make and break codes for the arrow keys 

#ifdef OS_DOS

#define MAKE_RIGHT      77 
#define MAKE_LEFT       75 
#define MAKE_UP         72 
#define MAKE_DOWN       80 
#define MAKE_CNTL       29 

#define BREAK_RIGHT     205 
#define BREAK_LEFT      203 
#define BREAK_UP        200 
#define BREAK_DOWN      208 
#define BREAK_CNTL      (128+29)

#define MAKE_LUP 82
#define MAKE_LDOWN 83
#define BREAK_LUP 210
#define BREAK_LDOWN 211
// codes for other keys

#define TAB_KEY 143
#define ESC_KEY 1
#define PLUS_KEY 13
#define MINUS_KEY 12
#define RIGHT_BRACKET 26
#define LEFT_BRACKET 27
#define PGUP_KEY 73
#define PGDN_KEY 81
#define INSERT_KEY 82
#define DELETE_KEY 83
#define U_KEY 22
#define D_KEY 32
#define F_KEY 161
#define S_KEY 31
#define F1_KEY 59
#define F2_KEY 60
#define CNTL_KEY 29
#endif

#ifdef OS_WINDOWS
#define MAKE_RIGHT      VK_RIGHT
#define MAKE_LEFT       VK_LEFT
#define MAKE_UP         VK_UP
#define MAKE_DOWN       VK_DOWN

#define BREAK_RIGHT     (VK_RIGHT+128)
#define BREAK_LEFT      (VK_LEFT+128)
#define BREAK_UP        (VK_UP+128)
#define BREAK_DOWN    (VK_DOWN+128)

#define MAKE_LUP VK_INSERT
#define MAKE_LDOWN VK_DELETE
#define BREAK_LUP (VK_INSERT+128)
#define BREAK_LDOWN (VK_DELETE+128)

// codes for other keys

#define TAB_KEY VK_TAB
#define ESC_KEY VK_ESCAPE
#define PLUS_KEY 0x6B
#define MINUS_KEY VK_SUBTRACT
#define RIGHT_BRACKET VK_F3
#define LEFT_BRACKET VK_F4
#define PGUP_KEY VK_PRIOR
#define PGDN_KEY VK_NEXT
#define INSERT_KEY VK_INSERT
#define DELETE_KEY VK_DELETE
#define U_KEY 0x55
#define D_KEY 0x44
#define F_KEY 0x46
#define S_KEY 0x53
#define F1_KEY VK_F1
#define F2_KEY VK_F2
#endif

// indices into arrow key state table 
 
#define INDEX_UP        0 
#define INDEX_DOWN      1 
#define INDEX_RIGHT     2 
#define INDEX_LEFT      3 
#define LOOK_UP 4
#define LOOK_DOWN 5
#define INDEX_GUN 6
#define RAW_INPUT 7
#endif
