#ifndef _OFF_SCREEN_BUFFER_
#define _OFF_SCREEN_BUFFER_
#include "os.h"
#include "memutil.h"

typedef struct OFF_SCREEN_BUFF * poff_screen_buff;

typedef UCHAR * video_data_ptr;

#ifdef OS_DOS
typedef struct OFF_SCREEN_BUFF {
   video_data_ptr * buff_ptr_address;
  } off_screen_buff;
#endif

#ifdef OS_WINDOWS

typedef struct OFF_SCREEN_BUFF {
   video_data_ptr * buff_ptr_address;
   HBITMAP hbitmap;
} off_screen_buff;
#endif

poff_screen_buff Create_Offscreen_Buffer(video_data_ptr * buff_ptr_address);
void Blt_Buffer(poff_screen_buff os_buffer);
void Clear_Buffer(poff_screen_buff os_buffer);
void Dispose_Buffer(poff_screen_buff os_buffer);

#endif

