#include "os.h"
#include "scrcntl.h"
#include "palette.h"
#include <mem.h>
#include <stdlib.h>

pal_component pal_entries[MAX_PAL_ENTRIES * PAL_ENTRY_SIZE];

#ifdef OS_WINDOWS
#include "winpal.h"
HPALETTE hpalApp=NULL;
RQBQUAD win_palette[MAX_PAL_ENTRIES];
#endif

#ifdef OS_DOS
#include "screen.h"
#endif

void Init_Palette() {

memset(pal_entries, 0, (MAX_PAL_ENTRIES * PAL_ENTRY_SIZE));

#ifdef OS_WINDOWS
   ClearSystemPalette();
#endif
}

void Load_Palette(palette_ptr new_palette, short start_pos, short num_entries) {
int cur_color;

memcpy(pal_entries+(start_pos * PAL_ENTRY_SIZE), new_palette,
        num_entries * PAL_ENTRY_SIZE);

#ifdef OS_WINDOWS
//my palette vals are stored 0..64, but most systems except DOS are 0..256
for (cur_color=start_pos; cur_color<(start_pos+num_entries); cur_color++) {
   pal_entries[cur_color*PAL_ENTRY_SIZE]<<=2;
   pal_entries[cur_color*PAL_ENTRY_SIZE+1]<<=2;
   pal_entries[cur_color*PAL_ENTRY_SIZE+2]<<=2;
} /* endfor */
#endif

#ifdef OS_WINDOWS
for (cur_color=0; cur_color<MAX_PAL_ENTRIES; cur_color++) {
  win_palette[cur_color].rgbRed=pal_entries[cur_color*PAL_ENTRY_SIZE];
  win_palette[cur_color].rgbBlue=pal_entries[cur_color*PAL_ENTRY_SIZE+1];
  win_palette[cur_color].rgbGreen=pal_entries[cur_color*PAL_ENTRY_SIZE+2];
  win_palette[cur_color].rgbReserved=0;
} /* endfor */

if (hpalApp)
   DeleteObject(hpalApp);
hpalApp=CreateIdentityPalette(win_palette, MAX_PAL_ENTRIES);

#endif
}

void Get_Palette(palette_ptr receive_palette, short start_pos, short num_entries) {
memcpy(receive_palette, pal_entries+(start_pos * PAL_ENTRY_SIZE),
        num_entries * PAL_ENTRY_SIZE);
}

void Activate_Palette(BOOL active) {
#ifdef OS_DOS
   setpalette(pal_entries);
#endif

#ifdef OS_WINDOWS
// *** Remap the system colors and deal with the palette

AppActivate(active);
if (hpalApp) {
   UnrealizeObject(hpalApp);
   SelectPalette(Get_Screen_Window(), hpalApp, FALSE);
   RealizePalette(Get_Screen_Window());
   }

#endif
}

BOOL Update_Palette() {
#ifdef OS_DOS
   setpalette(pal_entries);
   return TRUE;
#endif

#ifdef OS_WINDOWS
if (hpalApp)
   SelectPalette(Get_Screen_Window(), hpalApp, FALSE);
BOOL f=RealizePalette(Get_Screen_Window());
return TRUE;

#endif
}

void Close_Palette() {
#ifdef OS_WINDOWS
	if(hpalApp)
	{
		DeleteObject(hpalApp);
	}
#endif
}

pal_component Get_Palette_Red_Val(short color_index) {
   return pal_entries[color_index*PAL_ENTRY_SIZE];
}

pal_component Get_Palette_Green_Val(short color_index) {
   return pal_entries[color_index*PAL_ENTRY_SIZE+1];
}

pal_component Get_Palette_Blue_Val(short color_index) {
   return pal_entries[color_index*PAL_ENTRY_SIZE+2];
}
