#ifndef _RAYFILE_
#define _RAYFILE_

#include <string.h>
#include <fstream.h>
#include "ray.h"
#include "globals.h"
#include "filetype.h"

#define RESOURCE_LENGTH 8
#define F_NUM_TYPES 10

extern "C++" BOOL world_loaded;
extern "C++" BOOL wall_tex_loaded;
extern "C++" BOOL floor_tex_loaded;
extern "C++" BOOL sound_loaded;
extern "C++" fstream fp;
extern "C++" WFHeader header;
extern "C++" dir_entry * directory;
extern "C++" short base_index;
extern "C++" BOOL binary_mode;
extern "C++" void * cur_table;

BOOL Cmp_Str_N(char * s1, char * s2, short n);
void F_Clear_World();
void F_Clear_WT();
void F_Clear_FT();
void F_Clear_Sky();
void F_Clear_Sound();
void F_Load_World();
void F_Get_Wall_Textures();
void F_Get_Floor_Textures();
void F_Get_Sky();
void F_Get_Vectors();
void F_Get_SDs();
void F_Get_LDs();
void F_Get_Segs();
void F_Get_SSectors();
void F_Get_Sectors();
void F_Get_Objects();
void F_Get_Object_Types();
void F_Get_BSP();
void Load_Vox_Map(PUCHAR & vox_ptr, long offset);
void F_Get_Sound();
void F_Setup(char * filename);
void F_Close();
void F_Get_Dir();
void F_Seek(long offset);
short F_Find_And_Setup(char * string, void ** table, short memsize);
SHORT F_Find_Dir(char * name);
void F_D_Setup(char * filename);
void F_D_Load_World();
void F_D_Get_Vectors();
void F_D_Get_SDs();
void F_D_Get_LDs();
void F_D_Get_Segs();
void F_D_Get_SSectors();
void F_D_Get_Sectors();
void F_D_Get_BSP();
void F_D_Get_Player_Loc();
void Doom_Sort_SSector(ssector * cur_ss);
void Swap_Segs(seg * base_seg, seg * swap_seg);

inline void F_Go_To_Next_Line()
{
if (!binary_mode) { 
  char ch;
  fp >> ch;
  while (ch=='#') {
    fp.ignore(-1, '\n');
    fp >> ch;
    }
  fp.putback(ch);
  }
}

inline void F_Get_Long(long & value)
{
F_Go_To_Next_Line();
if (binary_mode)
  fp.read((char *)&value, sizeof(long));
else fp >> value;
}

inline void F_Get_Short(short & value)
{
F_Go_To_Next_Line();
if (binary_mode)
   fp.read((char *)&value, sizeof(short));
else fp >> value;
}

inline void F_Get_UShort(USHORT & value)
{
F_Get_Short((short &)value);
}

inline void F_Get_ULong(ULONG & value)
{
F_Get_Long((long &)value);
}

inline void F_Get_Byte(Byte & value)
{

F_Go_To_Next_Line();
if (binary_mode) {
fp >> value;
} else {
short temp_value;
fp >> temp_value;
value=(Byte)temp_value;
}

}

inline void F_Get_String(char * str, short length)
{
F_Go_To_Next_Line();
if (binary_mode)
  fp.read(str, length);
else { 
  fp >> str;
  short counter=(short)strlen(str);
  for (;counter<length; counter++)
    str[counter]=' ';
  }
}

inline void F_Get_String_NT(char * str, short length)
{
F_Go_To_Next_Line();
if (binary_mode) {
   fp.read(str, length);
} else {
   fp >> str;
   } /* endif */
}

inline void F_Get_Bool(BOOL & value) {
if (binary_mode) {
   Byte byte_res;
   F_Get_Byte(byte_res);
   if (byte_res) {
      value=TRUE;
   } else {
      value=FALSE;
   }
} else {
   CHAR string_res [BOOL_NAME_LENGTH];
   F_Get_String_NT(string_res,BOOL_NAME_LENGTH);
   if (!strnicmp(string_res, "TRUE", BOOL_NAME_LENGTH)) {
      value=TRUE;
   } else {
      value=FALSE;
   }
}
}

inline long F_Abs_Pos() {
   return fp.tellg();
}

inline void F_Seek_Abs(long pos) {
   fp.seekg(pos, ios::beg);
}

#endif
