#include "ray.h"
#include "globals.h"
#include "voxinter.h"
#include "prevarr.h"
#include "sprinter.h"
#include <stdio.h>
#include <mem.h>
#include <stdlib.h>
#include <string.h>
#include "sprinter.h"
#include "scrconf.h"
#include "fixed.h"
#include "raybuff.h"
#include "getangle.h"

void    initRay()
        {
        F_Init();
        Init_Objects();
        WINDOW_HEIGHT=Get_Phys_Screen_Height();
        WINDOW_MIDDLE=WINDOW_HEIGHT/2;
        WINDOW_WIDTH=Get_Phys_Screen_Width();
        WINDOW_MIDDLEW=WINDOW_WIDTH/2;
        HORIZ_VIEW_RANGE=ANGLE_60;
        VERTICAL_VIEW_RANGE=ANGLE_60;
        VERTICAL_SCALE=13312;
        Build_Tables();
        Init_Get_Angle();
        SCALE_FACTOR=fixeddiv(WINDOW_MIDDLEW, tan_table[HORIZ_VIEW_RANGE>>1]);
        Init_Buffer();
        Setup_Prev_Arrays();
        Set_View_Angle(ANGLE_0);
        Render_Init();
        SetRenderMode(MODE_3D);
        Init_Voxel();
        }

void closeRay()
{
Clear_Prev_Arrays();
Close_Objects();
Render_Close();
Close_Voxel();
F_Shutdown();
DelPtr(tan_table);
DelPtr(inv_tan_table);
DelPtr(rcos_table);
DelPtr(rsin_table);
DelPtr(inv_cos_table);
DelPtr(distance_table);
//DelPtr(movement_table;
DelPtr(height_table);
}

