#include "ray.h"
#include "fixed.h"
#include "rayrt.h"
#include "slopes.h"
#include "globals.h"
#include "abs.h"
#include <stddef.h>
#include "verttan.h"

#define MIN_SLOPE_DIFF 5000
#define MAX_WALL_RUNS 8000
#define MAX_FLOOR_RUNS 4000

extern "C" MYFIXED
Win_Top_Sum, Win_Height_Sum,
Win_Top_Increment, Win_Height_Increment;

extern "C" long cur_angle_diff, intercept;

extern "C" long render_x, render_y, render_z, render_view_angle;

extern "C" MYFIXED vec_int_x, vec_int_y;

extern "C" short WINDOW_LEFT, WINDOW_RIGHT;

extern "C" long rotate_x, rotate_y, rotate_angle;

extern "C" long int_x_diff;

extern "C" long ray_slope;

extern "C" long int_y_diff;

extern "C" floor_run_info * floor_runs;

extern "C" long floor_run_count;

extern "C" wall_run_info * wall_runs;

extern "C" long wall_run_count;

inline short Get_Wall_Texture_Height(ptexture index) {
   return wall[index].height;
}

inline short Get_Floor_Texture_Height(ptexture index) {
   return floortex[index].height;
}

inline short Get_Sprite_Texture_Height(ptexture index) {
   return wall[index].height;
}

inline short Get_Wall_Texture_Width(ptexture index) {
   return wall[index].width;
}

inline short Get_Floor_Texture_Width(ptexture index) {
   return floortex[index].width;
}
inline short Get_Sprite_Texture_Width(ptexture index) {
   return wall[index].width;
}

inline Byte Get_Wall_Texture_Shift(ptexture index) {
   return wall[index].shift;
}

inline Byte Get_Floor_Texture_Shift(ptexture index) {
   return floortex[index].shift;
}

inline Byte Get_Sprite_Texture_Shift(ptexture index) {
   return wall[index].shift;
}

inline Byte * Get_Wall_Texture(ptexture index) {
   return wall[index].images[wall[index].cur_image];
}

inline Byte * Get_Sprite_Texture(ptexture index, short cur_anim) {
   return wall[index].images[cur_anim];
}

inline Byte * Get_Floor_Texture(ptexture index) {
   return floortex[index].images[floortex[index].cur_image];
}

inline Byte SecLight(sector * sec)
{
return (UCHAR)(sec->light & (UCHAR)SEC_LIGHT_MASK);
}

inline Byte SecLTSpeed(sector * sec)
{
return (UCHAR)((sec->light & (UCHAR)SEC_LTSPEED_MASK) >> (UCHAR)SEC_LTSPEED_SHIFT);
}

inline MYFIXED RotateX() {
   return (rotate_x*rcos_table[rotate_angle]+rotate_y*rsin_table[rotate_angle]);
}

inline MYFIXED FixedRotateX() {
   return (fixedmult(rotate_x,rcos_table[rotate_angle])+
        fixedmult(rotate_y,rsin_table[rotate_angle]));
}

inline MYFIXED RotateY() {
   return (rotate_y*rcos_table[rotate_angle]-rotate_x*rsin_table[rotate_angle]);
}

inline MYFIXED FixedRotateY() {
   return (fixedmult(rotate_y,rcos_table[rotate_angle])-
        fixedmult(rotate_x,rsin_table[rotate_angle]));
}

inline short Project(MYFIXED x, MYFIXED y) {
   return (fixedmd(-x, SCALE_FACTOR, y) )+WINDOW_MIDDLEW;
}

inline sector * GetOppSec(seg * cur_seg)
{
sidedef * cur_sd=cur_seg->ld->s[!(short)cur_seg->left_sidedef];
if (cur_sd != NULL) {
   return cur_sd->sec;
} else {
   return NULL;
}
}

inline MYFIXED GetCeilScVal(sector * sec, long distance)
{
if (distance<0)
   return MAXMYFIXED;
if (distance>=(MAXDIS<<SHIFT))
   return (WINDOW_MIDDLE<<SHIFT);
return fixedmult((((render_z-sec->ceil_height)<<SHIFT)+
        fixedmult(distance, vert_angle_tangent)),fixeddiv(y_trans, distance))+
        (WINDOW_MIDDLE << SHIFT);
}

inline MYFIXED GetFloorScVal(sector * sec, long distance)
{
if (distance<0)
   return MAXMYFIXED;
if (distance>=(MAXDIS<<SHIFT))
   return (WINDOW_MIDDLE<<SHIFT);
return fixedmult((((render_z-sec->floor_height)<<SHIFT)+
        fixedmult(distance, vert_angle_tangent)),fixeddiv(y_trans, distance))+
        (WINDOW_MIDDLE << SHIFT);
}

inline MYFIXED GetZScVal(long z, long distance)
{
if (distance<0)
   return MAXMYFIXED;
if (distance>=(MAXDIS<<SHIFT))
   return (WINDOW_MIDDLE<<SHIFT);
return fixedmult((((render_z-z)<<SHIFT)+
        fixedmult(distance, vert_angle_tangent)),fixeddiv(y_trans, distance))+
        (WINDOW_MIDDLE << SHIFT);
}

inline void Setup_Intersection(pvector2 base_v, pvector2 dest_v)
{
   long x_diff, y_diff;
   x_diff=dest_v->x-base_v->x;
   int_x_diff=x_diff;
   y_diff=dest_v->y-base_v->y;
   fixedmult64(y_diff, base_v->x);
   fixedma64(-x_diff, base_v->y);
   int_y_diff=y_diff;
}

inline long Get_Intersection_Y(short ray)
{
ray_slope=Get_Slope(ray);
MYFIXED ray_x_diff=fixedmult(ray_slope,int_y_diff);
   if (ABS(ray_x_diff-int_x_diff)>MIN_SLOPE_DIFF)
      vec_int_y=fixeddiv64(ray_x_diff - int_x_diff);
   else vec_int_y=MAXDIS;
return vec_int_y;
}

inline long Get_Intersection_X()
{
   vec_int_x=fixedmult(vec_int_y, ray_slope);
   return vec_int_x;
}

inline sector * GetSecFromSSec(ssector * cur_ss)
{
   seg * cur_seg=Seg_List+cur_ss->seg_start;
   return (cur_seg->ld->s[(short)cur_seg->left_sidedef]->sec);
}

inline sector * GetSecFromSeg(seg * cur_seg)
{
   return (cur_seg->ld->s[(short)cur_seg->left_sidedef]->sec);
}

void BSP_Recursion_Draw();
void Draw_Sub_Sector(pssector cur_ss);
void Draw_Sub_Sector_Setup();
void Draw_Sub_Sector_Close();
void Translate_Vectors();
void Ray_Caster(long x, long y, long z, long view_angle);
void Render_2d(long x, long y, long view_angle);
void Draw_SS_Sprites(pssector cur_ss);
