#include "ray.h"
#include "globals.h"
#include "defobj.h"
#include "player.h"
#include "bullet.h"
#include "turret.h"
#include "sprfunc.h"
#include "sprrend.h"
#include "sprrload.h"
#include "inventor.h"
#include "monster.h"
#include "message.h"
#include "explosio.h"

pupdate_func update_funcs;
pupdate_z_func update_z_funcs;
pload_extra_func load_extra_funcs;
prender_func render_funcs;
prender_data_loader render_data_loaders;
pmessage_func message_funcs;

void Error_Update_Func(pobject cur_object, long update_num) {
   Error("Object calls update function that does not exist. World file is corrupt!");
}
void Error_Update_Z_Func(pobject cur_object, psector new_sec) {
   Error("Object calls update  z function that does not exist. World file is corrupt!");
}
void Error_Load_Extra_Func(pobject cur_object, long extra_data_offset) {
   Error("Object calls load extra function that does not exist. World file is corrupt!");
}
void Error_Render_Func(pobject cur_object) {
   Error("Object calls render function that does not exist. World file is corrupt!");
}
void Error_Render_Data_Loader(pobject_type cur_type, long extra_data_offset) {
   Error("Object calls render data loader function that does not exist. World file is corrupt!");
}

ULONG Error_Message_Func(pobject send_obj, pobject receive_obj, ULONG message, pdata extra_data) {
   Error("Object calls message function that does not exist. World file is corrupt!");
   return NORMAL_MESSAGE;
}

void Init_Spr_Funcs() {
  update_funcs=(pupdate_func)NewPtr(sizeof(update_func) * TYPE_COUNT);
  update_z_funcs=(pupdate_z_func)NewPtr(sizeof(update_z_func) * TYPE_COUNT);
  load_extra_funcs=(pload_extra_func)NewPtr(sizeof(load_extra_func) * TYPE_COUNT);
  message_funcs=(pmessage_func)NewPtr(sizeof(message_func) * TYPE_COUNT);
  render_funcs=(prender_func)NewPtr(sizeof(render_func) * TYPE_COUNT);
  render_data_loaders=
     (prender_data_loader)NewPtr(sizeof(render_data_loader) * TYPE_COUNT);
 
  for (short cur_func=0; cur_func<TYPE_COUNT; cur_func++) {
     update_funcs[cur_func]=Error_Update_Func;
     update_z_funcs[cur_func]=Error_Update_Z_Func;
     load_extra_funcs[cur_func]=Error_Load_Extra_Func;
     render_funcs[cur_func]=Error_Render_Func;
     render_data_loaders[cur_func]=Error_Render_Data_Loader;
     message_funcs[cur_func]=Error_Message_Func;
  }

  Init_Def_Obj(DEF_INDEX);
  Init_Player_Obj(PLAYER_INDEX);
  Init_Bullets(BULLET_INDEX);
  Init_Turrets(TURRET_INDEX);
  Init_Monsters(MONSTER_INDEX);
  Init_Inventory(INVENTORY_INDEX);
  Init_Explosion(EXPLOSION_INDEX);
  render_funcs[NORM_RENDER]=(render_func)Draw_Sprite;
  render_funcs[FLAT_RENDER]=(render_func)Draw_Flat_Sprite;
  render_data_loaders[NORM_RENDER]=(render_data_loader)Load_Norm_Render;
  render_data_loaders[FLAT_RENDER]=(render_data_loader)Load_Flat_Render;
  }

update_func Get_Update_Func(func_index update_index) {
  if (update_index>=TYPE_COUNT)
     return Error_Update_Func;
  return update_funcs[update_index];
  }

update_z_func Get_Update_Z_Func(func_index update_z_index) {
  if (update_z_index>=TYPE_COUNT)
     return Error_Update_Z_Func;
  return update_z_funcs[update_z_index];
  }

load_extra_func Get_Load_Extra_Func(func_index load_extra_index) {
  if (load_extra_index>=TYPE_COUNT)
     return Error_Load_Extra_Func;
  return load_extra_funcs[load_extra_index];
  }

render_func Get_Render_Func(func_index render_index) {
   if (render_index>=TYPE_COUNT)
      return Error_Render_Func;
   return render_funcs[render_index];
}

render_data_loader Get_Render_Data_Loader(func_index loader_index) {
   if (loader_index>=TYPE_COUNT)
      return Error_Render_Data_Loader;
   return render_data_loaders[loader_index];
}

message_func Get_Message_Func(func_index message_index) {
   if (message_index>=TYPE_COUNT)
      return Error_Message_Func;
   return message_funcs[message_index];
}

void Close_Spr_Funcs() {
   DelPtr(update_funcs);
   DelPtr(update_z_funcs);
   DelPtr(load_extra_funcs);
   DelPtr(render_data_loaders);
   DelPtr(render_funcs);
   DelPtr(message_funcs);
   }

