#ifndef _SPRUTILS_
#define _SPRUTILS_
#include "ray.h"
#include "globals.h"

#define BAD_LOAD_OFFSET -1

inline sector * Get_Sec_From_SSec(ssector * cur_ss)
{
   seg * cur_seg=Seg_List+cur_ss->seg_start;
   return (cur_seg->ld->s[(short)cur_seg->left_sidedef]->sec);
}

inline long Sprite_Y(pobject_node the_obj)
{
   return (the_obj->data->ty);
}

inline BOOL OL_Empty_Node(pobject_node the_node)
{
return ( (the_node==NULL) ? TRUE : FALSE);
}

inline pobject_node OL_Next_Node(pobject_node cur_node)
{
return cur_node->front;
}

inline void OL_Swap_SS_Nodes(pobject_node swap1, pobject_node swap2)
{
   pobject data1, data2;
   data1=swap1->data;
   data2=swap2->data;
   swap1->data=data2;
   swap2->data=data1;

   if (data1->ss_node==swap1)
      data1->ss_node=swap2;
   else if (data1->global_node==swap1)
      data1->global_node=swap2;

   if (data2->ss_node==swap2)
      data2->ss_node=swap1;
   else if (data2->global_node==swap2)
      data2->global_node=swap1;

}

inline void OL_Delete_Node(pobject_node delete_node, pobject_node & list)
{
if (list==delete_node)
   list=list->front;
else {
   pobject_node d_front, d_back;
   d_front=delete_node->front;
   d_back=delete_node->back;
   d_back->front=d_front;
   if (d_front!=NULL)
      d_front->back=d_back;
}
}

inline void OL_Push_Node(pobject_node push_node, pobject_node & list)
{
push_node->back=NULL;
push_node->front=list;
if (list!=NULL)
   list->back=push_node;
list=push_node;
}

#endif
