#include "ray.h"
#include "globals.h"
#include "visible.h"
#include "blockmap.h"
#include "rayrend.h"
#include "isect.h"
#include "forever.h"

BOOL Check_Object_Visibility(pobject seeing_obj, pobject check_object);
BOOL Do_Cone_Check(pobject seeing_obj, pobject check_obj);
BOOL Do_Wall_Check(pobject seeing_obj, pobject check_obj);

pobject Check_For_Visible_Enemies(pobject seeing_obj) {
   if (Check_Object_Visibility(seeing_obj, the_player))
      return the_player;
   else return NULL;
}

BOOL Check_Object_Visibility(pobject seeing_obj, pobject check_obj) {
   if (Do_Cone_Check(seeing_obj, check_obj)) {
      return Do_Wall_Check(seeing_obj, check_obj);
   } else return FALSE;
}
 
BOOL Do_Cone_Check(pobject seeing_obj, pobject check_obj) {

   MYFIXED trans_x, trans_y;

   rotate_x=check_obj->x-seeing_obj->x;
   rotate_y=check_obj->y-seeing_obj->y;
   rotate_angle=seeing_obj->angle;

   trans_x=FixedRotateY();
   trans_y=FixedRotateX();

   // is object in front of seeing object but not too far away
   if ((trans_y<=0) || (trans_y>(seeing_obj->type->stats.sight_dis<<SHIFT)))
      return FALSE;

   // is object within 90 degree view cone
   if (ABS(trans_x)>trans_y)
      return FALSE;

   return TRUE;
}

BOOL Do_Wall_Check(pobject seeing_obj, pobject check_obj) {
   vector2 source_vec, dest_vec, cur_vec;
   pvector2 sl_vec, dl_vec;
   short cur_block_x, cur_block_y, dest_block_x, dest_block_y, next_block_x, next_block_y;
   long dist_major, dist_minor, next_x_line, next_y_line;
   pline_list cur_line_list;
   short cur_line_index;
   BOOL y_done, x_done;

   source_vec.x=seeing_obj->x>>SHIFT;
   source_vec.y=seeing_obj->y>>SHIFT;
   dest_vec.x=check_obj->x>>SHIFT;
   dest_vec.y=check_obj->y>>SHIFT;
   cur_vec.x=seeing_obj->x;
   cur_vec.y=seeing_obj->y;

   cur_block_x=Block_X(seeing_obj->x);
   cur_block_y=Block_Y(seeing_obj->y);
   dest_block_x=Block_X(check_obj->x);
   dest_block_y=Block_Y(check_obj->y);
           
   FOREVER {
      cur_line_list=Get_Block_Line_List(cur_block_x, cur_block_y);
      for (cur_line_index=0; cur_line_index< cur_line_list->line_count; cur_line_index++) {
         sl_vec=Vector_List+cur_line_list->lines[cur_line_index]->v[0];
         dl_vec=Vector_List+cur_line_list->lines[cur_line_index]->v[1];
         if (Intersect_Abs(&source_vec, &dest_vec, sl_vec, dl_vec)) {
            return FALSE;
         }
      }

   if (dest_vec.x>source_vec.x) {
      if (cur_block_x>=dest_block_x) {
         x_done=TRUE;
      } else {
         x_done=FALSE;
      }
   } else {
      if (cur_block_x<=dest_block_x) {
         x_done=TRUE;
      } else {
         x_done=FALSE;
      }
   }

   if (dest_vec.y>source_vec.y) {
      if (cur_block_y>=dest_block_y) {
         y_done=TRUE;
      } else {
         y_done=FALSE;
      }
   } else {
      if (cur_block_y<=dest_block_y) {
         y_done=TRUE;
      } else {
         y_done=FALSE;
      }
   }

   if (x_done && y_done) {
      break;
   }

   if ( (dest_vec.x-source_vec.x) >= 0) {
      next_block_x=cur_block_x+1;
      next_x_line=Block_Right_Line(cur_vec.x);
   } else {
      next_block_x=cur_block_x-1;
      next_x_line=Block_Left_Line(cur_vec.x)-1;
   }

   if ( (dest_vec.y-source_vec.y) >= 0) {
      next_block_y=cur_block_y+1;
      next_y_line=Block_Top_Line(cur_vec.y);
   } else {
      next_block_y=cur_block_y-1;
      next_y_line=Block_Bottom_Line(cur_vec.y)-1;
   }

   if (ABS(dest_vec.x-source_vec.x)>ABS(dest_vec.y-source_vec.y)) {
      
      dist_minor=next_y_line-cur_vec.y;
      dist_major=fixedmd(next_x_line-cur_vec.x,
         dest_vec.y-source_vec.y, dest_vec.x-source_vec.x); 
      
      if (ABS(dist_major)<ABS(dist_minor)) {
         cur_vec.x=next_x_line;
         cur_vec.y+=dist_major;
         cur_block_x=next_block_x;
         cur_block_y=Block_Y(cur_vec.y);
      } else {
         cur_vec.y=next_y_line;
         cur_vec.x+=fixedmd(dist_minor, dest_vec.x-source_vec.x, dest_vec.y-source_vec.y);
         cur_block_y=next_block_y;
         cur_block_x=Block_X(cur_vec.x);
      }

   } else {
   
      dist_minor=next_x_line-cur_vec.x;
      dist_major=fixedmd((next_y_line-cur_vec.y),
         dest_vec.x-source_vec.x, dest_vec.y-source_vec.y); 
      
      if (ABS(dist_major)<ABS(dist_minor)) {
         cur_vec.y=next_y_line;
         cur_vec.x+=dist_major;
         cur_block_y=next_block_y;
         cur_block_x=Block_X(cur_vec.x);
      } else {
         cur_vec.x=next_x_line;
         cur_vec.y+=fixedmd(dist_minor, dest_vec.y-source_vec.y, dest_vec.x-source_vec.x);
         cur_block_x=next_block_x;
         cur_block_y=Block_Y(cur_vec.y);
      }

   }

   }

return TRUE;
}
